/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.it;

import com.google.cloud.Page;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryError;
import com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.CopyJobConfiguration;
import com.google.cloud.bigquery.Dataset;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.DatasetInfo;
import com.google.cloud.bigquery.ExternalTableDefinition;
import com.google.cloud.bigquery.ExtractJobConfiguration;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldValue;
import com.google.cloud.bigquery.FormatOptions;
import com.google.cloud.bigquery.InsertAllRequest;
import com.google.cloud.bigquery.InsertAllResponse;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.JobConfiguration;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.JobStatistics;
import com.google.cloud.bigquery.LoadJobConfiguration;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.QueryRequest;
import com.google.cloud.bigquery.QueryResponse;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.Table;
import com.google.cloud.bigquery.TableDataWriteChannel;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.ViewDefinition;
import com.google.cloud.bigquery.WriteChannelConfiguration;
import com.google.cloud.bigquery.testing.RemoteBigQueryHelper;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.BucketInfo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.testing.RemoteStorageHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public class ITBigQueryTest {
    private static final Logger LOG = Logger.getLogger(ITBigQueryTest.class.getName());
    private static final String DATASET = RemoteBigQueryHelper.generateDatasetName();
    private static final String DESCRIPTION = "Test dataset";
    private static final String OTHER_DATASET = RemoteBigQueryHelper.generateDatasetName();
    private static final Field TIMESTAMP_FIELD_SCHEMA = Field.builder((String)"TimestampField", (Field.Type)Field.Type.timestamp()).mode(Field.Mode.NULLABLE).description("TimestampDescription").build();
    private static final Field STRING_FIELD_SCHEMA = Field.builder((String)"StringField", (Field.Type)Field.Type.string()).mode(Field.Mode.NULLABLE).description("StringDescription").build();
    private static final Field INTEGER_FIELD_SCHEMA = Field.builder((String)"IntegerField", (Field.Type)Field.Type.integer()).mode(Field.Mode.REPEATED).description("IntegerDescription").build();
    private static final Field BOOLEAN_FIELD_SCHEMA = Field.builder((String)"BooleanField", (Field.Type)Field.Type.bool()).mode(Field.Mode.NULLABLE).description("BooleanDescription").build();
    private static final Field RECORD_FIELD_SCHEMA = Field.builder((String)"RecordField", (Field.Type)Field.Type.record((Field[])new Field[]{TIMESTAMP_FIELD_SCHEMA, STRING_FIELD_SCHEMA, INTEGER_FIELD_SCHEMA, BOOLEAN_FIELD_SCHEMA})).mode(Field.Mode.REQUIRED).description("RecordDescription").build();
    private static final Schema TABLE_SCHEMA = Schema.of((Field[])new Field[]{TIMESTAMP_FIELD_SCHEMA, STRING_FIELD_SCHEMA, INTEGER_FIELD_SCHEMA, BOOLEAN_FIELD_SCHEMA, RECORD_FIELD_SCHEMA});
    private static final Schema SIMPLE_SCHEMA = Schema.of((Field[])new Field[]{STRING_FIELD_SCHEMA});
    private static final Schema QUERY_RESULT_SCHEMA = Schema.builder().addField(Field.builder((String)"TimestampField", (Field.Type)Field.Type.timestamp()).mode(Field.Mode.NULLABLE).build()).addField(Field.builder((String)"StringField", (Field.Type)Field.Type.string()).mode(Field.Mode.NULLABLE).build()).addField(Field.builder((String)"BooleanField", (Field.Type)Field.Type.bool()).mode(Field.Mode.NULLABLE).build()).build();
    private static final String LOAD_FILE = "load.csv";
    private static final String JSON_LOAD_FILE = "load.json";
    private static final String EXTRACT_FILE = "extract.csv";
    private static final String BUCKET = RemoteStorageHelper.generateBucketName();
    private static final TableId TABLE_ID = TableId.of((String)DATASET, (String)"testing_table");
    private static final String CSV_CONTENT = "StringValue1\nStringValue2\n";
    private static final String JSON_CONTENT = "{\"TimestampField\": \"2014-08-19 07:41:35.220 -05:00\",\"StringField\": \"stringValue\",\"IntegerField\": [\"0\", \"1\"],\"BooleanField\": \"false\",\"RecordField\": {\"TimestampField\": \"1969-07-20 20:18:04 UTC\",\"StringField\": null,\"IntegerField\": [\"1\",\"0\"],\"BooleanField\": \"true\"}}\n{\"TimestampField\": \"2014-08-19 07:41:35.220 -05:00\",\"StringField\": \"stringValue\",\"IntegerField\": [\"0\", \"1\"],\"BooleanField\": \"false\",\"RecordField\": {\"TimestampField\": \"1969-07-20 20:18:04 UTC\",\"StringField\": null,\"IntegerField\": [\"1\",\"0\"],\"BooleanField\": \"true\"}}";
    private static BigQuery bigquery;
    private static Storage storage;
    @Rule
    public Timeout globalTimeout = Timeout.seconds((long)300L);

    @BeforeClass
    public static void beforeClass() throws InterruptedException {
        RemoteBigQueryHelper bigqueryHelper = RemoteBigQueryHelper.create();
        RemoteStorageHelper storageHelper = RemoteStorageHelper.create();
        bigquery = (BigQuery)bigqueryHelper.options().service();
        storage = (Storage)storageHelper.options().service();
        storage.create(BucketInfo.of((String)BUCKET), new Storage.BucketTargetOption[0]);
        storage.create(BlobInfo.builder((String)BUCKET, (String)LOAD_FILE).contentType("text/plain").build(), CSV_CONTENT.getBytes(StandardCharsets.UTF_8), new Storage.BlobTargetOption[0]);
        storage.create(BlobInfo.builder((String)BUCKET, (String)JSON_LOAD_FILE).contentType("application/json").build(), JSON_CONTENT.getBytes(StandardCharsets.UTF_8), new Storage.BlobTargetOption[0]);
        DatasetInfo info = DatasetInfo.builder((String)DATASET).description(DESCRIPTION).build();
        bigquery.create(info, new BigQuery.DatasetOption[0]);
        LoadJobConfiguration configuration = LoadJobConfiguration.builder((TableId)TABLE_ID, (String)("gs://" + BUCKET + "/" + JSON_LOAD_FILE), (FormatOptions)FormatOptions.json()).createDisposition(JobInfo.CreateDisposition.CREATE_IF_NEEDED).schema(TABLE_SCHEMA).build();
        Job job = bigquery.create(JobInfo.of((JobConfiguration)configuration), new BigQuery.JobOption[0]);
        while (!job.isDone()) {
            Thread.sleep(1000L);
        }
        Assert.assertNull((Object)job.status().error());
    }

    @AfterClass
    public static void afterClass() throws ExecutionException, InterruptedException {
        boolean wasDeleted;
        if (bigquery != null) {
            RemoteBigQueryHelper.forceDelete((BigQuery)bigquery, (String)DATASET);
        }
        if (storage != null && !(wasDeleted = RemoteStorageHelper.forceDelete((Storage)storage, (String)BUCKET, (long)10L, (TimeUnit)TimeUnit.SECONDS).booleanValue()) && LOG.isLoggable(Level.WARNING)) {
            LOG.log(Level.WARNING, "Deletion of bucket {0} timed out, bucket is not empty", BUCKET);
        }
    }

    @Test
    public void testGetDataset() {
        Dataset dataset = bigquery.getDataset(DATASET, new BigQuery.DatasetOption[0]);
        Assert.assertEquals((Object)((BigQueryOptions)bigquery.options()).projectId(), (Object)dataset.datasetId().project());
        Assert.assertEquals((Object)DATASET, (Object)dataset.datasetId().dataset());
        Assert.assertEquals((Object)DESCRIPTION, (Object)dataset.description());
        Assert.assertNotNull((Object)dataset.acl());
        Assert.assertNotNull((Object)dataset.etag());
        Assert.assertNotNull((Object)dataset.generatedId());
        Assert.assertNotNull((Object)dataset.lastModified());
        Assert.assertNotNull((Object)dataset.selfLink());
    }

    @Test
    public void testGetDatasetWithSelectedFields() {
        Dataset dataset = bigquery.getDataset(DATASET, new BigQuery.DatasetOption[]{BigQuery.DatasetOption.fields((BigQuery.DatasetField[])new BigQuery.DatasetField[]{BigQuery.DatasetField.CREATION_TIME})});
        Assert.assertEquals((Object)((BigQueryOptions)bigquery.options()).projectId(), (Object)dataset.datasetId().project());
        Assert.assertEquals((Object)DATASET, (Object)dataset.datasetId().dataset());
        Assert.assertNotNull((Object)dataset.creationTime());
        Assert.assertNull((Object)dataset.description());
        Assert.assertNull((Object)dataset.defaultTableLifetime());
        Assert.assertNull((Object)dataset.acl());
        Assert.assertNull((Object)dataset.etag());
        Assert.assertNull((Object)dataset.friendlyName());
        Assert.assertNull((Object)dataset.generatedId());
        Assert.assertNull((Object)dataset.lastModified());
        Assert.assertNull((Object)dataset.location());
        Assert.assertNull((Object)dataset.selfLink());
    }

    @Test
    public void testUpdateDataset() {
        Dataset dataset = bigquery.create(DatasetInfo.builder((String)OTHER_DATASET).description("Some Description").build(), new BigQuery.DatasetOption[0]);
        Assert.assertNotNull((Object)dataset);
        Assert.assertEquals((Object)((BigQueryOptions)bigquery.options()).projectId(), (Object)dataset.datasetId().project());
        Assert.assertEquals((Object)OTHER_DATASET, (Object)dataset.datasetId().dataset());
        Assert.assertEquals((Object)"Some Description", (Object)dataset.description());
        Dataset updatedDataset = bigquery.update((DatasetInfo)dataset.toBuilder().description("Updated Description").build(), new BigQuery.DatasetOption[0]);
        Assert.assertEquals((Object)"Updated Description", (Object)updatedDataset.description());
        Assert.assertTrue((boolean)dataset.delete());
    }

    @Test
    public void testUpdateDatasetWithSelectedFields() {
        Dataset dataset = bigquery.create(DatasetInfo.builder((String)OTHER_DATASET).description("Some Description").build(), new BigQuery.DatasetOption[0]);
        Assert.assertNotNull((Object)dataset);
        Assert.assertEquals((Object)((BigQueryOptions)bigquery.options()).projectId(), (Object)dataset.datasetId().project());
        Assert.assertEquals((Object)OTHER_DATASET, (Object)dataset.datasetId().dataset());
        Assert.assertEquals((Object)"Some Description", (Object)dataset.description());
        Dataset updatedDataset = bigquery.update((DatasetInfo)dataset.toBuilder().description("Updated Description").build(), new BigQuery.DatasetOption[]{BigQuery.DatasetOption.fields((BigQuery.DatasetField[])new BigQuery.DatasetField[]{BigQuery.DatasetField.DESCRIPTION})});
        Assert.assertEquals((Object)"Updated Description", (Object)updatedDataset.description());
        Assert.assertNull((Object)updatedDataset.creationTime());
        Assert.assertNull((Object)updatedDataset.defaultTableLifetime());
        Assert.assertNull((Object)updatedDataset.acl());
        Assert.assertNull((Object)updatedDataset.etag());
        Assert.assertNull((Object)updatedDataset.friendlyName());
        Assert.assertNull((Object)updatedDataset.generatedId());
        Assert.assertNull((Object)updatedDataset.lastModified());
        Assert.assertNull((Object)updatedDataset.location());
        Assert.assertNull((Object)updatedDataset.selfLink());
        Assert.assertTrue((boolean)dataset.delete());
    }

    @Test
    public void testGetNonExistingTable() {
        Assert.assertNull((Object)bigquery.getTable(DATASET, "test_get_non_existing_table", new BigQuery.TableOption[0]));
    }

    @Test
    public void testCreateAndGetTable() {
        String tableName = "test_create_and_get_table";
        TableId tableId = TableId.of((String)DATASET, (String)tableName);
        StandardTableDefinition tableDefinition = StandardTableDefinition.of((Schema)TABLE_SCHEMA);
        Table createdTable = bigquery.create(TableInfo.of((TableId)tableId, (TableDefinition)tableDefinition), new BigQuery.TableOption[0]);
        Assert.assertNotNull((Object)createdTable);
        Assert.assertEquals((Object)DATASET, (Object)createdTable.tableId().dataset());
        Assert.assertEquals((Object)tableName, (Object)createdTable.tableId().table());
        Table remoteTable = bigquery.getTable(DATASET, tableName, new BigQuery.TableOption[0]);
        Assert.assertNotNull((Object)remoteTable);
        Assert.assertTrue((boolean)(remoteTable.definition() instanceof StandardTableDefinition));
        Assert.assertEquals((Object)createdTable.tableId(), (Object)remoteTable.tableId());
        Assert.assertEquals((Object)TableDefinition.Type.TABLE, (Object)remoteTable.definition().type());
        Assert.assertEquals((Object)TABLE_SCHEMA, (Object)remoteTable.definition().schema());
        Assert.assertNotNull((Object)remoteTable.creationTime());
        Assert.assertNotNull((Object)remoteTable.lastModifiedTime());
        Assert.assertNotNull((Object)((StandardTableDefinition)remoteTable.definition()).numBytes());
        Assert.assertNotNull((Object)((StandardTableDefinition)remoteTable.definition()).numRows());
        Assert.assertTrue((boolean)remoteTable.delete());
    }

    @Test
    public void testCreateAndGetTableWithSelectedField() {
        String tableName = "test_create_and_get_selected_fields_table";
        TableId tableId = TableId.of((String)DATASET, (String)tableName);
        StandardTableDefinition tableDefinition = StandardTableDefinition.of((Schema)TABLE_SCHEMA);
        Table createdTable = bigquery.create(TableInfo.of((TableId)tableId, (TableDefinition)tableDefinition), new BigQuery.TableOption[0]);
        Assert.assertNotNull((Object)createdTable);
        Assert.assertEquals((Object)DATASET, (Object)createdTable.tableId().dataset());
        Assert.assertEquals((Object)tableName, (Object)createdTable.tableId().table());
        Table remoteTable = bigquery.getTable(DATASET, tableName, new BigQuery.TableOption[]{BigQuery.TableOption.fields((BigQuery.TableField[])new BigQuery.TableField[]{BigQuery.TableField.CREATION_TIME})});
        Assert.assertNotNull((Object)remoteTable);
        Assert.assertTrue((boolean)(remoteTable.definition() instanceof StandardTableDefinition));
        Assert.assertEquals((Object)createdTable.tableId(), (Object)remoteTable.tableId());
        Assert.assertEquals((Object)TableDefinition.Type.TABLE, (Object)remoteTable.definition().type());
        Assert.assertNotNull((Object)remoteTable.creationTime());
        Assert.assertNull((Object)remoteTable.definition().schema());
        Assert.assertNull((Object)remoteTable.lastModifiedTime());
        Assert.assertNull((Object)((StandardTableDefinition)remoteTable.definition()).numBytes());
        Assert.assertNull((Object)((StandardTableDefinition)remoteTable.definition()).numRows());
        Assert.assertTrue((boolean)remoteTable.delete());
    }

    @Test
    public void testCreateExternalTable() throws InterruptedException {
        String tableName = "test_create_external_table";
        TableId tableId = TableId.of((String)DATASET, (String)tableName);
        ExternalTableDefinition externalTableDefinition = ExternalTableDefinition.of((String)("gs://" + BUCKET + "/" + JSON_LOAD_FILE), (Schema)TABLE_SCHEMA, (FormatOptions)FormatOptions.json());
        TableInfo tableInfo = TableInfo.of((TableId)tableId, (TableDefinition)externalTableDefinition);
        Table createdTable = bigquery.create(tableInfo, new BigQuery.TableOption[0]);
        Assert.assertNotNull((Object)createdTable);
        Assert.assertEquals((Object)DATASET, (Object)createdTable.tableId().dataset());
        Assert.assertEquals((Object)tableName, (Object)createdTable.tableId().table());
        Table remoteTable = bigquery.getTable(DATASET, tableName, new BigQuery.TableOption[0]);
        Assert.assertNotNull((Object)remoteTable);
        Assert.assertTrue((boolean)(remoteTable.definition() instanceof ExternalTableDefinition));
        Assert.assertEquals((Object)createdTable.tableId(), (Object)remoteTable.tableId());
        Assert.assertEquals((Object)TABLE_SCHEMA, (Object)remoteTable.definition().schema());
        QueryRequest request = QueryRequest.builder((String)("SELECT TimestampField, StringField, IntegerField, BooleanField FROM " + DATASET + "." + tableName)).defaultDataset(DatasetId.of((String)DATASET)).maxWaitTime(Long.valueOf(60000L)).pageSize(Long.valueOf(1000L)).build();
        QueryResponse response = bigquery.query(request);
        while (!response.jobCompleted()) {
            response = bigquery.getQueryResults(response.jobId(), new BigQuery.QueryResultsOption[0]);
            Thread.sleep(1000L);
        }
        long integerValue = 0L;
        int rowCount = 0;
        for (List row : response.result().values()) {
            FieldValue timestampCell = (FieldValue)row.get(0);
            FieldValue stringCell = (FieldValue)row.get(1);
            FieldValue integerCell = (FieldValue)row.get(2);
            FieldValue booleanCell = (FieldValue)row.get(3);
            Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)timestampCell.attribute());
            Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)stringCell.attribute());
            Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)integerCell.attribute());
            Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)booleanCell.attribute());
            Assert.assertEquals((long)1408452095220000L, (long)timestampCell.timestampValue());
            Assert.assertEquals((Object)"stringValue", (Object)stringCell.stringValue());
            Assert.assertEquals((long)integerValue, (long)integerCell.longValue());
            Assert.assertEquals((Object)false, (Object)booleanCell.booleanValue());
            integerValue = (integerValue ^ 0xFFFFFFFFFFFFFFFFL) & 1L;
            ++rowCount;
        }
        Assert.assertEquals((long)4L, (long)rowCount);
        Assert.assertTrue((boolean)remoteTable.delete());
    }

    @Test
    public void testCreateViewTable() throws InterruptedException {
        String tableName = "test_create_view_table";
        TableId tableId = TableId.of((String)DATASET, (String)tableName);
        ViewDefinition viewDefinition = ViewDefinition.of((String)("SELECT TimestampField, StringField, BooleanField FROM " + DATASET + "." + TABLE_ID.table()));
        TableInfo tableInfo = TableInfo.of((TableId)tableId, (TableDefinition)viewDefinition);
        Table createdTable = bigquery.create(tableInfo, new BigQuery.TableOption[0]);
        Assert.assertNotNull((Object)createdTable);
        Assert.assertEquals((Object)DATASET, (Object)createdTable.tableId().dataset());
        Assert.assertEquals((Object)tableName, (Object)createdTable.tableId().table());
        Table remoteTable = bigquery.getTable(DATASET, tableName, new BigQuery.TableOption[0]);
        Assert.assertNotNull((Object)remoteTable);
        Assert.assertEquals((Object)createdTable.tableId(), (Object)remoteTable.tableId());
        Assert.assertTrue((boolean)(remoteTable.definition() instanceof ViewDefinition));
        Schema expectedSchema = Schema.builder().addField(Field.builder((String)"TimestampField", (Field.Type)Field.Type.timestamp()).mode(Field.Mode.NULLABLE).build()).addField(Field.builder((String)"StringField", (Field.Type)Field.Type.string()).mode(Field.Mode.NULLABLE).build()).addField(Field.builder((String)"BooleanField", (Field.Type)Field.Type.bool()).mode(Field.Mode.NULLABLE).build()).build();
        Assert.assertEquals((Object)expectedSchema, (Object)remoteTable.definition().schema());
        QueryRequest request = QueryRequest.builder((String)("SELECT * FROM " + tableName)).defaultDataset(DatasetId.of((String)DATASET)).maxWaitTime(Long.valueOf(60000L)).pageSize(Long.valueOf(1000L)).build();
        QueryResponse response = bigquery.query(request);
        while (!response.jobCompleted()) {
            response = bigquery.getQueryResults(response.jobId(), new BigQuery.QueryResultsOption[0]);
            Thread.sleep(1000L);
        }
        int rowCount = 0;
        for (List row : response.result().values()) {
            FieldValue timestampCell = (FieldValue)row.get(0);
            FieldValue stringCell = (FieldValue)row.get(1);
            FieldValue booleanCell = (FieldValue)row.get(2);
            Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)timestampCell.attribute());
            Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)stringCell.attribute());
            Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)booleanCell.attribute());
            Assert.assertEquals((long)1408452095220000L, (long)timestampCell.timestampValue());
            Assert.assertEquals((Object)"stringValue", (Object)stringCell.stringValue());
            Assert.assertEquals((Object)false, (Object)booleanCell.booleanValue());
            ++rowCount;
        }
        Assert.assertEquals((long)2L, (long)rowCount);
        Assert.assertTrue((boolean)remoteTable.delete());
    }

    @Test
    public void testListTables() {
        String tableName = "test_list_tables";
        StandardTableDefinition tableDefinition = StandardTableDefinition.of((Schema)TABLE_SCHEMA);
        TableInfo tableInfo = TableInfo.of((TableId)TableId.of((String)DATASET, (String)tableName), (TableDefinition)tableDefinition);
        Table createdTable = bigquery.create(tableInfo, new BigQuery.TableOption[0]);
        Assert.assertNotNull((Object)createdTable);
        Page tables = bigquery.listTables(DATASET, new BigQuery.TableListOption[0]);
        boolean found = false;
        Iterator tableIterator = tables.values().iterator();
        while (tableIterator.hasNext() && !found) {
            if (!((Table)tableIterator.next()).tableId().equals((Object)createdTable.tableId())) continue;
            found = true;
        }
        Assert.assertTrue((boolean)found);
        Assert.assertTrue((boolean)createdTable.delete());
    }

    @Test
    public void testUpdateTable() {
        String tableName = "test_update_table";
        StandardTableDefinition tableDefinition = StandardTableDefinition.of((Schema)TABLE_SCHEMA);
        TableInfo tableInfo = TableInfo.of((TableId)TableId.of((String)DATASET, (String)tableName), (TableDefinition)tableDefinition);
        Table createdTable = bigquery.create(tableInfo, new BigQuery.TableOption[0]);
        Assert.assertNotNull((Object)createdTable);
        Table updatedTable = bigquery.update(tableInfo.toBuilder().description("newDescription").build(), new BigQuery.TableOption[0]);
        Assert.assertEquals((Object)DATASET, (Object)updatedTable.tableId().dataset());
        Assert.assertEquals((Object)tableName, (Object)updatedTable.tableId().table());
        Assert.assertEquals((Object)TABLE_SCHEMA, (Object)updatedTable.definition().schema());
        Assert.assertEquals((Object)"newDescription", (Object)updatedTable.description());
        Assert.assertTrue((boolean)updatedTable.delete());
    }

    @Test
    public void testUpdateTableWithSelectedFields() {
        String tableName = "test_update_with_selected_fields_table";
        StandardTableDefinition tableDefinition = StandardTableDefinition.of((Schema)TABLE_SCHEMA);
        TableInfo tableInfo = TableInfo.of((TableId)TableId.of((String)DATASET, (String)tableName), (TableDefinition)tableDefinition);
        Table createdTable = bigquery.create(tableInfo, new BigQuery.TableOption[0]);
        Assert.assertNotNull((Object)createdTable);
        Table updatedTable = bigquery.update(tableInfo.toBuilder().description("newDescr").build(), new BigQuery.TableOption[]{BigQuery.TableOption.fields((BigQuery.TableField[])new BigQuery.TableField[]{BigQuery.TableField.DESCRIPTION})});
        Assert.assertTrue((boolean)(updatedTable.definition() instanceof StandardTableDefinition));
        Assert.assertEquals((Object)DATASET, (Object)updatedTable.tableId().dataset());
        Assert.assertEquals((Object)tableName, (Object)updatedTable.tableId().table());
        Assert.assertEquals((Object)"newDescr", (Object)updatedTable.description());
        Assert.assertNull((Object)updatedTable.definition().schema());
        Assert.assertNull((Object)updatedTable.lastModifiedTime());
        Assert.assertNull((Object)((StandardTableDefinition)updatedTable.definition()).numBytes());
        Assert.assertNull((Object)((StandardTableDefinition)updatedTable.definition()).numRows());
        Assert.assertTrue((boolean)createdTable.delete());
    }

    @Test
    public void testUpdateNonExistingTable() {
        TableInfo tableInfo = TableInfo.of((TableId)TableId.of((String)DATASET, (String)"test_update_non_existing_table"), (TableDefinition)StandardTableDefinition.of((Schema)SIMPLE_SCHEMA));
        try {
            bigquery.update(tableInfo, new BigQuery.TableOption[0]);
            Assert.fail((String)"BigQueryException was expected");
        }
        catch (BigQueryException e) {
            BigQueryError error = e.error();
            Assert.assertNotNull((Object)error);
            Assert.assertEquals((Object)"notFound", (Object)error.reason());
            Assert.assertNotNull((Object)error.message());
        }
    }

    @Test
    public void testDeleteNonExistingTable() {
        Assert.assertFalse((boolean)bigquery.delete(DATASET, "test_delete_non_existing_table"));
    }

    @Test
    public void testInsertAll() {
        String tableName = "test_insert_all_table";
        StandardTableDefinition tableDefinition = StandardTableDefinition.of((Schema)TABLE_SCHEMA);
        TableInfo tableInfo = TableInfo.of((TableId)TableId.of((String)DATASET, (String)tableName), (TableDefinition)tableDefinition);
        Assert.assertNotNull((Object)bigquery.create(tableInfo, new BigQuery.TableOption[0]));
        InsertAllRequest request = InsertAllRequest.builder((TableId)tableInfo.tableId()).addRow((Map)ImmutableMap.of((Object)"TimestampField", (Object)"2014-08-19 07:41:35.220 -05:00", (Object)"StringField", (Object)"stringValue", (Object)"IntegerField", (Object)ImmutableList.of((Object)0, (Object)1), (Object)"BooleanField", (Object)false, (Object)"RecordField", (Object)ImmutableMap.of((Object)"TimestampField", (Object)"1969-07-20 20:18:04 UTC", (Object)"IntegerField", (Object)ImmutableList.of((Object)1, (Object)0), (Object)"BooleanField", (Object)true))).addRow((Map)ImmutableMap.of((Object)"TimestampField", (Object)"2014-08-19 07:41:35.220 -05:00", (Object)"StringField", (Object)"stringValue", (Object)"IntegerField", (Object)ImmutableList.of((Object)0, (Object)1), (Object)"BooleanField", (Object)false, (Object)"RecordField", (Object)ImmutableMap.of((Object)"TimestampField", (Object)"1969-07-20 20:18:04 UTC", (Object)"IntegerField", (Object)ImmutableList.of((Object)1, (Object)0), (Object)"BooleanField", (Object)true))).build();
        InsertAllResponse response = bigquery.insertAll(request);
        Assert.assertFalse((boolean)response.hasErrors());
        Assert.assertEquals((long)0L, (long)response.insertErrors().size());
        Assert.assertTrue((boolean)bigquery.delete(TableId.of((String)DATASET, (String)tableName)));
    }

    @Test
    public void testInsertAllWithSuffix() throws InterruptedException {
        String tableName = "test_insert_all_with_suffix_table";
        StandardTableDefinition tableDefinition = StandardTableDefinition.of((Schema)TABLE_SCHEMA);
        TableInfo tableInfo = TableInfo.of((TableId)TableId.of((String)DATASET, (String)tableName), (TableDefinition)tableDefinition);
        Assert.assertNotNull((Object)bigquery.create(tableInfo, new BigQuery.TableOption[0]));
        InsertAllRequest request = InsertAllRequest.builder((TableId)tableInfo.tableId()).addRow((Map)ImmutableMap.of((Object)"TimestampField", (Object)"2014-08-19 07:41:35.220 -05:00", (Object)"StringField", (Object)"stringValue", (Object)"IntegerField", (Object)ImmutableList.of((Object)0, (Object)1), (Object)"BooleanField", (Object)false, (Object)"RecordField", (Object)ImmutableMap.of((Object)"TimestampField", (Object)"1969-07-20 20:18:04 UTC", (Object)"IntegerField", (Object)ImmutableList.of((Object)1, (Object)0), (Object)"BooleanField", (Object)true))).addRow((Map)ImmutableMap.of((Object)"TimestampField", (Object)"2014-08-19 07:41:35.220 -05:00", (Object)"StringField", (Object)"stringValue", (Object)"IntegerField", (Object)ImmutableList.of((Object)0, (Object)1), (Object)"BooleanField", (Object)false, (Object)"RecordField", (Object)ImmutableMap.of((Object)"TimestampField", (Object)"1969-07-20 20:18:04 UTC", (Object)"IntegerField", (Object)ImmutableList.of((Object)1, (Object)0), (Object)"BooleanField", (Object)true))).templateSuffix("_suffix").build();
        InsertAllResponse response = bigquery.insertAll(request);
        Assert.assertFalse((boolean)response.hasErrors());
        Assert.assertEquals((long)0L, (long)response.insertErrors().size());
        String newTableName = tableName + "_suffix";
        Table suffixTable = bigquery.getTable(DATASET, newTableName, new BigQuery.TableOption[]{BigQuery.TableOption.fields((BigQuery.TableField[])new BigQuery.TableField[0])});
        while (suffixTable == null) {
            Thread.sleep(1000L);
            suffixTable = bigquery.getTable(DATASET, newTableName, new BigQuery.TableOption[]{BigQuery.TableOption.fields((BigQuery.TableField[])new BigQuery.TableField[0])});
        }
        Assert.assertTrue((boolean)bigquery.delete(TableId.of((String)DATASET, (String)tableName)));
        Assert.assertTrue((boolean)suffixTable.delete());
    }

    @Test
    public void testInsertAllWithErrors() {
        String tableName = "test_insert_all_with_errors_table";
        StandardTableDefinition tableDefinition = StandardTableDefinition.of((Schema)TABLE_SCHEMA);
        TableInfo tableInfo = TableInfo.of((TableId)TableId.of((String)DATASET, (String)tableName), (TableDefinition)tableDefinition);
        Assert.assertNotNull((Object)bigquery.create(tableInfo, new BigQuery.TableOption[0]));
        InsertAllRequest request = InsertAllRequest.builder((TableId)tableInfo.tableId()).addRow((Map)ImmutableMap.of((Object)"TimestampField", (Object)"2014-08-19 07:41:35.220 -05:00", (Object)"StringField", (Object)"stringValue", (Object)"IntegerField", (Object)ImmutableList.of((Object)0, (Object)1), (Object)"BooleanField", (Object)false, (Object)"RecordField", (Object)ImmutableMap.of((Object)"TimestampField", (Object)"1969-07-20 20:18:04 UTC", (Object)"IntegerField", (Object)ImmutableList.of((Object)1, (Object)0), (Object)"BooleanField", (Object)true))).addRow((Map)ImmutableMap.of((Object)"TimestampField", (Object)"invalidDate", (Object)"StringField", (Object)"stringValue", (Object)"IntegerField", (Object)ImmutableList.of((Object)0, (Object)1), (Object)"BooleanField", (Object)false, (Object)"RecordField", (Object)ImmutableMap.of((Object)"TimestampField", (Object)"1969-07-20 20:18:04 UTC", (Object)"IntegerField", (Object)ImmutableList.of((Object)1, (Object)0), (Object)"BooleanField", (Object)true))).addRow((Map)ImmutableMap.of((Object)"TimestampField", (Object)"1969-07-20 20:18:04 UTC", (Object)"StringField", (Object)"stringValue", (Object)"IntegerField", (Object)ImmutableList.of((Object)0, (Object)1), (Object)"BooleanField", (Object)false)).skipInvalidRows(true).build();
        InsertAllResponse response = bigquery.insertAll(request);
        Assert.assertTrue((boolean)response.hasErrors());
        Assert.assertEquals((long)2L, (long)response.insertErrors().size());
        Assert.assertNotNull((Object)response.errorsFor(1L));
        Assert.assertNotNull((Object)response.errorsFor(2L));
        Assert.assertTrue((boolean)bigquery.delete(TableId.of((String)DATASET, (String)tableName)));
    }

    @Test
    public void testListAllTableData() {
        Page rows = bigquery.listTableData(TABLE_ID, new BigQuery.TableDataListOption[0]);
        int rowCount = 0;
        for (List row : rows.values()) {
            FieldValue timestampCell = (FieldValue)row.get(0);
            FieldValue stringCell = (FieldValue)row.get(1);
            FieldValue integerCell = (FieldValue)row.get(2);
            FieldValue booleanCell = (FieldValue)row.get(3);
            FieldValue recordCell = (FieldValue)row.get(4);
            Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)timestampCell.attribute());
            Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)stringCell.attribute());
            Assert.assertEquals((Object)FieldValue.Attribute.REPEATED, (Object)integerCell.attribute());
            Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)booleanCell.attribute());
            Assert.assertEquals((Object)FieldValue.Attribute.RECORD, (Object)recordCell.attribute());
            Assert.assertEquals((long)1408452095220000L, (long)timestampCell.timestampValue());
            Assert.assertEquals((Object)"stringValue", (Object)stringCell.stringValue());
            Assert.assertEquals((long)0L, (long)((FieldValue)integerCell.repeatedValue().get(0)).longValue());
            Assert.assertEquals((long)1L, (long)((FieldValue)integerCell.repeatedValue().get(1)).longValue());
            Assert.assertEquals((Object)false, (Object)booleanCell.booleanValue());
            Assert.assertEquals((long)-14182916000000L, (long)((FieldValue)recordCell.recordValue().get(0)).timestampValue());
            Assert.assertTrue((boolean)((FieldValue)recordCell.recordValue().get(1)).isNull());
            Assert.assertEquals((long)1L, (long)((FieldValue)((FieldValue)recordCell.recordValue().get(2)).repeatedValue().get(0)).longValue());
            Assert.assertEquals((long)0L, (long)((FieldValue)((FieldValue)recordCell.recordValue().get(2)).repeatedValue().get(1)).longValue());
            Assert.assertEquals((Object)true, (Object)((FieldValue)recordCell.recordValue().get(3)).booleanValue());
            ++rowCount;
        }
        Assert.assertEquals((long)2L, (long)rowCount);
    }

    @Test
    public void testQuery() throws InterruptedException {
        String query = "SELECT TimestampField, StringField, BooleanField FROM " + TABLE_ID.table();
        QueryRequest request = QueryRequest.builder((String)query).defaultDataset(DatasetId.of((String)DATASET)).maxWaitTime(Long.valueOf(60000L)).pageSize(Long.valueOf(1000L)).build();
        QueryResponse response = bigquery.query(request);
        while (!response.jobCompleted()) {
            Thread.sleep(1000L);
            response = bigquery.getQueryResults(response.jobId(), new BigQuery.QueryResultsOption[0]);
        }
        Assert.assertEquals((Object)QUERY_RESULT_SCHEMA, (Object)response.result().schema());
        int rowCount = 0;
        for (List row : response.result().values()) {
            FieldValue timestampCell = (FieldValue)row.get(0);
            FieldValue stringCell = (FieldValue)row.get(1);
            FieldValue booleanCell = (FieldValue)row.get(2);
            Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)timestampCell.attribute());
            Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)stringCell.attribute());
            Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)booleanCell.attribute());
            Assert.assertEquals((long)1408452095220000L, (long)timestampCell.timestampValue());
            Assert.assertEquals((Object)"stringValue", (Object)stringCell.stringValue());
            Assert.assertEquals((Object)false, (Object)booleanCell.booleanValue());
            ++rowCount;
        }
        Assert.assertEquals((long)2L, (long)rowCount);
        Job queryJob = bigquery.getJob(response.jobId(), new BigQuery.JobOption[0]);
        JobStatistics.QueryStatistics statistics = (JobStatistics.QueryStatistics)queryJob.statistics();
        Assert.assertNotNull((Object)statistics.queryPlan());
    }

    @Test
    public void testListJobs() {
        Page jobs = bigquery.listJobs(new BigQuery.JobListOption[0]);
        for (Job job : jobs.values()) {
            Assert.assertNotNull((Object)job.jobId());
            Assert.assertNotNull((Object)job.statistics());
            Assert.assertNotNull((Object)job.status());
            Assert.assertNotNull((Object)job.userEmail());
            Assert.assertNotNull((Object)job.generatedId());
        }
    }

    @Test
    public void testListJobsWithSelectedFields() {
        Page jobs = bigquery.listJobs(new BigQuery.JobListOption[]{BigQuery.JobListOption.fields((BigQuery.JobField[])new BigQuery.JobField[]{BigQuery.JobField.USER_EMAIL})});
        for (Job job : jobs.values()) {
            Assert.assertNotNull((Object)job.jobId());
            Assert.assertNotNull((Object)job.status());
            Assert.assertNotNull((Object)job.userEmail());
            Assert.assertNull((Object)job.statistics());
            Assert.assertNull((Object)job.generatedId());
        }
    }

    @Test
    public void testCreateAndGetJob() {
        String sourceTableName = "test_create_and_get_job_source_table";
        String destinationTableName = "test_create_and_get_job_destination_table";
        TableId sourceTable = TableId.of((String)DATASET, (String)sourceTableName);
        StandardTableDefinition tableDefinition = StandardTableDefinition.of((Schema)TABLE_SCHEMA);
        TableInfo tableInfo = TableInfo.of((TableId)sourceTable, (TableDefinition)tableDefinition);
        Table createdTable = bigquery.create(tableInfo, new BigQuery.TableOption[0]);
        Assert.assertNotNull((Object)createdTable);
        Assert.assertEquals((Object)DATASET, (Object)createdTable.tableId().dataset());
        Assert.assertEquals((Object)sourceTableName, (Object)createdTable.tableId().table());
        TableId destinationTable = TableId.of((String)DATASET, (String)destinationTableName);
        CopyJobConfiguration copyJobConfiguration = CopyJobConfiguration.of((TableId)destinationTable, (TableId)sourceTable);
        Job createdJob = bigquery.create(JobInfo.of((JobConfiguration)copyJobConfiguration), new BigQuery.JobOption[0]);
        Job remoteJob = bigquery.getJob(createdJob.jobId(), new BigQuery.JobOption[0]);
        Assert.assertEquals((Object)createdJob.jobId(), (Object)remoteJob.jobId());
        CopyJobConfiguration createdConfiguration = (CopyJobConfiguration)createdJob.configuration();
        CopyJobConfiguration remoteConfiguration = (CopyJobConfiguration)remoteJob.configuration();
        Assert.assertEquals((Object)createdConfiguration.sourceTables(), (Object)remoteConfiguration.sourceTables());
        Assert.assertEquals((Object)createdConfiguration.destinationTable(), (Object)remoteConfiguration.destinationTable());
        Assert.assertEquals((Object)createdConfiguration.createDisposition(), (Object)remoteConfiguration.createDisposition());
        Assert.assertEquals((Object)createdConfiguration.writeDisposition(), (Object)remoteConfiguration.writeDisposition());
        Assert.assertNotNull((Object)remoteJob.etag());
        Assert.assertNotNull((Object)remoteJob.statistics());
        Assert.assertNotNull((Object)remoteJob.status());
        Assert.assertEquals((Object)createdJob.selfLink(), (Object)remoteJob.selfLink());
        Assert.assertEquals((Object)createdJob.userEmail(), (Object)remoteJob.userEmail());
        Assert.assertTrue((boolean)createdTable.delete());
        Assert.assertTrue((boolean)bigquery.delete(DATASET, destinationTableName));
    }

    @Test
    public void testCreateAndGetJobWithSelectedFields() {
        String sourceTableName = "test_create_and_get_job_with_selected_fields_source_table";
        String destinationTableName = "test_create_and_get_job_with_selected_fields_destination_table";
        TableId sourceTable = TableId.of((String)DATASET, (String)sourceTableName);
        StandardTableDefinition tableDefinition = StandardTableDefinition.of((Schema)TABLE_SCHEMA);
        TableInfo tableInfo = TableInfo.of((TableId)sourceTable, (TableDefinition)tableDefinition);
        Table createdTable = bigquery.create(tableInfo, new BigQuery.TableOption[0]);
        Assert.assertNotNull((Object)createdTable);
        Assert.assertEquals((Object)DATASET, (Object)createdTable.tableId().dataset());
        Assert.assertEquals((Object)sourceTableName, (Object)createdTable.tableId().table());
        TableId destinationTable = TableId.of((String)DATASET, (String)destinationTableName);
        CopyJobConfiguration configuration = CopyJobConfiguration.of((TableId)destinationTable, (TableId)sourceTable);
        Job createdJob = bigquery.create(JobInfo.of((JobConfiguration)configuration), new BigQuery.JobOption[]{BigQuery.JobOption.fields((BigQuery.JobField[])new BigQuery.JobField[]{BigQuery.JobField.ETAG})});
        CopyJobConfiguration createdConfiguration = (CopyJobConfiguration)createdJob.configuration();
        Assert.assertNotNull((Object)createdJob.jobId());
        Assert.assertNotNull((Object)createdConfiguration.sourceTables());
        Assert.assertNotNull((Object)createdConfiguration.destinationTable());
        Assert.assertNotNull((Object)createdJob.etag());
        Assert.assertNull((Object)createdJob.statistics());
        Assert.assertNull((Object)createdJob.status());
        Assert.assertNull((Object)createdJob.selfLink());
        Assert.assertNull((Object)createdJob.userEmail());
        Job remoteJob = bigquery.getJob(createdJob.jobId(), new BigQuery.JobOption[]{BigQuery.JobOption.fields((BigQuery.JobField[])new BigQuery.JobField[]{BigQuery.JobField.ETAG})});
        CopyJobConfiguration remoteConfiguration = (CopyJobConfiguration)remoteJob.configuration();
        Assert.assertEquals((Object)createdJob.jobId(), (Object)remoteJob.jobId());
        Assert.assertEquals((Object)createdConfiguration.sourceTables(), (Object)remoteConfiguration.sourceTables());
        Assert.assertEquals((Object)createdConfiguration.destinationTable(), (Object)remoteConfiguration.destinationTable());
        Assert.assertEquals((Object)createdConfiguration.createDisposition(), (Object)remoteConfiguration.createDisposition());
        Assert.assertEquals((Object)createdConfiguration.writeDisposition(), (Object)remoteConfiguration.writeDisposition());
        Assert.assertNotNull((Object)remoteJob.etag());
        Assert.assertNull((Object)remoteJob.statistics());
        Assert.assertNull((Object)remoteJob.status());
        Assert.assertNull((Object)remoteJob.selfLink());
        Assert.assertNull((Object)remoteJob.userEmail());
        Assert.assertTrue((boolean)createdTable.delete());
        Assert.assertTrue((boolean)bigquery.delete(DATASET, destinationTableName));
    }

    @Test
    public void testCopyJob() throws InterruptedException {
        String sourceTableName = "test_copy_job_source_table";
        String destinationTableName = "test_copy_job_destination_table";
        TableId sourceTable = TableId.of((String)DATASET, (String)sourceTableName);
        StandardTableDefinition tableDefinition = StandardTableDefinition.of((Schema)TABLE_SCHEMA);
        TableInfo tableInfo = TableInfo.of((TableId)sourceTable, (TableDefinition)tableDefinition);
        Table createdTable = bigquery.create(tableInfo, new BigQuery.TableOption[0]);
        Assert.assertNotNull((Object)createdTable);
        Assert.assertEquals((Object)DATASET, (Object)createdTable.tableId().dataset());
        Assert.assertEquals((Object)sourceTableName, (Object)createdTable.tableId().table());
        TableId destinationTable = TableId.of((String)DATASET, (String)destinationTableName);
        CopyJobConfiguration configuration = CopyJobConfiguration.of((TableId)destinationTable, (TableId)sourceTable);
        Job remoteJob = bigquery.create(JobInfo.of((JobConfiguration)configuration), new BigQuery.JobOption[0]);
        while (!remoteJob.isDone()) {
            Thread.sleep(1000L);
        }
        Assert.assertNull((Object)remoteJob.status().error());
        Table remoteTable = bigquery.getTable(DATASET, destinationTableName, new BigQuery.TableOption[0]);
        Assert.assertNotNull((Object)remoteTable);
        Assert.assertEquals((Object)destinationTable.dataset(), (Object)remoteTable.tableId().dataset());
        Assert.assertEquals((Object)destinationTableName, (Object)remoteTable.tableId().table());
        Assert.assertEquals((Object)TABLE_SCHEMA, (Object)remoteTable.definition().schema());
        Assert.assertTrue((boolean)createdTable.delete());
        Assert.assertTrue((boolean)remoteTable.delete());
    }

    @Test
    public void testQueryJob() throws InterruptedException {
        String tableName = "test_query_job_table";
        String query = "SELECT TimestampField, StringField, BooleanField FROM " + TABLE_ID.table();
        TableId destinationTable = TableId.of((String)DATASET, (String)tableName);
        QueryJobConfiguration configuration = QueryJobConfiguration.builder((String)query).defaultDataset(DatasetId.of((String)DATASET)).destinationTable(destinationTable).build();
        Job remoteJob = bigquery.create(JobInfo.of((JobConfiguration)configuration), new BigQuery.JobOption[0]);
        while (!remoteJob.isDone()) {
            Thread.sleep(1000L);
        }
        Assert.assertNull((Object)remoteJob.status().error());
        QueryResponse response = bigquery.getQueryResults(remoteJob.jobId(), new BigQuery.QueryResultsOption[0]);
        while (!response.jobCompleted()) {
            Thread.sleep(1000L);
            response = bigquery.getQueryResults(response.jobId(), new BigQuery.QueryResultsOption[0]);
        }
        Assert.assertFalse((boolean)response.hasErrors());
        Assert.assertEquals((Object)QUERY_RESULT_SCHEMA, (Object)response.result().schema());
        int rowCount = 0;
        for (List row : response.result().values()) {
            FieldValue timestampCell = (FieldValue)row.get(0);
            FieldValue stringCell = (FieldValue)row.get(1);
            FieldValue booleanCell = (FieldValue)row.get(2);
            Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)timestampCell.attribute());
            Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)stringCell.attribute());
            Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)booleanCell.attribute());
            Assert.assertEquals((long)1408452095220000L, (long)timestampCell.timestampValue());
            Assert.assertEquals((Object)"stringValue", (Object)stringCell.stringValue());
            Assert.assertEquals((Object)false, (Object)booleanCell.booleanValue());
            ++rowCount;
        }
        Assert.assertEquals((long)2L, (long)rowCount);
        Assert.assertTrue((boolean)bigquery.delete(DATASET, tableName));
        Job queryJob = bigquery.getJob(remoteJob.jobId(), new BigQuery.JobOption[0]);
        JobStatistics.QueryStatistics statistics = (JobStatistics.QueryStatistics)queryJob.statistics();
        Assert.assertNotNull((Object)statistics.queryPlan());
    }

    @Test
    public void testExtractJob() throws InterruptedException {
        String tableName = "test_export_job_table";
        TableId destinationTable = TableId.of((String)DATASET, (String)tableName);
        LoadJobConfiguration configuration = LoadJobConfiguration.builder((TableId)destinationTable, (String)("gs://" + BUCKET + "/" + LOAD_FILE)).schema(SIMPLE_SCHEMA).build();
        Job remoteLoadJob = bigquery.create(JobInfo.of((JobConfiguration)configuration), new BigQuery.JobOption[0]);
        while (!remoteLoadJob.isDone()) {
            Thread.sleep(1000L);
        }
        Assert.assertNull((Object)remoteLoadJob.status().error());
        ExtractJobConfiguration extractConfiguration = ExtractJobConfiguration.builder((TableId)destinationTable, (String)("gs://" + BUCKET + "/" + EXTRACT_FILE)).printHeader(Boolean.valueOf(false)).build();
        Job remoteExtractJob = bigquery.create(JobInfo.of((JobConfiguration)extractConfiguration), new BigQuery.JobOption[0]);
        while (!remoteExtractJob.isDone()) {
            Thread.sleep(1000L);
        }
        Assert.assertNull((Object)remoteExtractJob.status().error());
        Assert.assertEquals((Object)CSV_CONTENT, (Object)new String(storage.readAllBytes(BUCKET, EXTRACT_FILE, new Storage.BlobSourceOption[0]), StandardCharsets.UTF_8));
        Assert.assertTrue((boolean)bigquery.delete(DATASET, tableName));
    }

    @Test
    public void testCancelJob() throws InterruptedException {
        String destinationTableName = "test_cancel_query_job_table";
        String query = "SELECT TimestampField, StringField, BooleanField FROM " + TABLE_ID.table();
        TableId destinationTable = TableId.of((String)DATASET, (String)destinationTableName);
        QueryJobConfiguration configuration = QueryJobConfiguration.builder((String)query).defaultDataset(DatasetId.of((String)DATASET)).destinationTable(destinationTable).build();
        Job remoteJob = bigquery.create(JobInfo.of((JobConfiguration)configuration), new BigQuery.JobOption[0]);
        Assert.assertTrue((boolean)remoteJob.cancel());
        while (!remoteJob.isDone()) {
            Thread.sleep(1000L);
        }
        Assert.assertNull((Object)remoteJob.status().error());
    }

    @Test
    public void testCancelNonExistingJob() {
        Assert.assertFalse((boolean)bigquery.cancel("test_cancel_non_existing_job"));
    }

    @Test
    public void testInsertFromFile() throws InterruptedException {
        String destinationTableName = "test_insert_from_file_table";
        TableId tableId = TableId.of((String)DATASET, (String)destinationTableName);
        WriteChannelConfiguration configuration = WriteChannelConfiguration.builder((TableId)tableId).formatOptions(FormatOptions.json()).createDisposition(JobInfo.CreateDisposition.CREATE_IF_NEEDED).schema(TABLE_SCHEMA).build();
        try (TableDataWriteChannel channel = bigquery.writer(configuration);){
            channel.write(ByteBuffer.wrap(JSON_CONTENT.getBytes(StandardCharsets.UTF_8)));
        }
        catch (IOException e) {
            Assert.fail((String)"IOException was not expected");
        }
        while (bigquery.getTable(tableId, new BigQuery.TableOption[0]) == null) {
            Thread.sleep(1000L);
        }
        Page rows = bigquery.listTableData(tableId, new BigQuery.TableDataListOption[0]);
        int rowCount = 0;
        for (List row : rows.values()) {
            FieldValue timestampCell = (FieldValue)row.get(0);
            FieldValue stringCell = (FieldValue)row.get(1);
            FieldValue integerCell = (FieldValue)row.get(2);
            FieldValue booleanCell = (FieldValue)row.get(3);
            FieldValue recordCell = (FieldValue)row.get(4);
            Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)timestampCell.attribute());
            Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)stringCell.attribute());
            Assert.assertEquals((Object)FieldValue.Attribute.REPEATED, (Object)integerCell.attribute());
            Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)booleanCell.attribute());
            Assert.assertEquals((Object)FieldValue.Attribute.RECORD, (Object)recordCell.attribute());
            Assert.assertEquals((long)1408452095220000L, (long)timestampCell.timestampValue());
            Assert.assertEquals((Object)"stringValue", (Object)stringCell.stringValue());
            Assert.assertEquals((long)0L, (long)((FieldValue)integerCell.repeatedValue().get(0)).longValue());
            Assert.assertEquals((long)1L, (long)((FieldValue)integerCell.repeatedValue().get(1)).longValue());
            Assert.assertEquals((Object)false, (Object)booleanCell.booleanValue());
            Assert.assertEquals((long)-14182916000000L, (long)((FieldValue)recordCell.recordValue().get(0)).timestampValue());
            Assert.assertTrue((boolean)((FieldValue)recordCell.recordValue().get(1)).isNull());
            Assert.assertEquals((long)1L, (long)((FieldValue)((FieldValue)recordCell.recordValue().get(2)).repeatedValue().get(0)).longValue());
            Assert.assertEquals((long)0L, (long)((FieldValue)((FieldValue)recordCell.recordValue().get(2)).repeatedValue().get(1)).longValue());
            Assert.assertEquals((Object)true, (Object)((FieldValue)recordCell.recordValue().get(3)).booleanValue());
            ++rowCount;
        }
        Assert.assertEquals((long)2L, (long)rowCount);
        Assert.assertTrue((boolean)bigquery.delete(DATASET, destinationTableName));
    }
}

