/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.JobConfigurationQuery;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.ExternalTableDefinition;
import com.google.cloud.bigquery.JobConfiguration;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.UserDefinedFunction;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class QueryJobConfiguration
extends JobConfiguration {
    private static final long serialVersionUID = -1108948249081804890L;
    private final String query;
    private final TableId destinationTable;
    private final Map<String, ExternalTableDefinition> tableDefinitions;
    private final List<UserDefinedFunction> userDefinedFunctions;
    private final JobInfo.CreateDisposition createDisposition;
    private final JobInfo.WriteDisposition writeDisposition;
    private final DatasetId defaultDataset;
    private final Priority priority;
    private final Boolean allowLargeResults;
    private final Boolean useQueryCache;
    private final Boolean flattenResults;
    private final Boolean dryRun;

    private QueryJobConfiguration(Builder builder) {
        super(builder);
        this.query = (String)Preconditions.checkNotNull((Object)builder.query);
        this.allowLargeResults = builder.allowLargeResults;
        this.createDisposition = builder.createDisposition;
        this.defaultDataset = builder.defaultDataset;
        this.destinationTable = builder.destinationTable;
        this.flattenResults = builder.flattenResults;
        this.priority = builder.priority;
        this.useQueryCache = builder.useQueryCache;
        this.userDefinedFunctions = builder.userDefinedFunctions;
        this.writeDisposition = builder.writeDisposition;
        this.tableDefinitions = builder.tableDefinitions != null ? ImmutableMap.copyOf((Map)builder.tableDefinitions) : null;
        this.dryRun = builder.dryRun;
    }

    public Boolean allowLargeResults() {
        return this.allowLargeResults;
    }

    public JobInfo.CreateDisposition createDisposition() {
        return this.createDisposition;
    }

    public DatasetId defaultDataset() {
        return this.defaultDataset;
    }

    public TableId destinationTable() {
        return this.destinationTable;
    }

    public Boolean flattenResults() {
        return this.flattenResults;
    }

    public Priority priority() {
        return this.priority;
    }

    public String query() {
        return this.query;
    }

    public Map<String, ExternalTableDefinition> tableDefinitions() {
        return this.tableDefinitions;
    }

    public Boolean useQueryCache() {
        return this.useQueryCache;
    }

    public List<UserDefinedFunction> userDefinedFunctions() {
        return this.userDefinedFunctions;
    }

    public JobInfo.WriteDisposition writeDisposition() {
        return this.writeDisposition;
    }

    public Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("query", (Object)this.query).add("destinationTable", (Object)this.destinationTable).add("defaultDataset", (Object)this.defaultDataset).add("allowLargeResults", (Object)this.allowLargeResults).add("flattenResults", (Object)this.flattenResults).add("priority", (Object)this.priority).add("tableDefinitions", this.tableDefinitions).add("userQueryCache", (Object)this.useQueryCache).add("userDefinedFunctions", this.userDefinedFunctions).add("createDisposition", (Object)this.createDisposition).add("writeDisposition", (Object)this.writeDisposition).add("dryRun", (Object)this.dryRun);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof QueryJobConfiguration && this.baseEquals((QueryJobConfiguration)obj);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.baseHashCode(), this.allowLargeResults, this.createDisposition, this.destinationTable, this.defaultDataset, this.flattenResults, this.priority, this.query, this.tableDefinitions, this.useQueryCache, this.userDefinedFunctions, this.writeDisposition, this.dryRun});
    }

    @Override
    QueryJobConfiguration setProjectId(String projectId) {
        Builder builder = this.toBuilder();
        if (this.destinationTable() != null) {
            builder.destinationTable(this.destinationTable().setProjectId(projectId));
        }
        if (this.defaultDataset() != null) {
            builder.defaultDataset(this.defaultDataset().setProjectId(projectId));
        }
        return builder.build();
    }

    @Override
    com.google.api.services.bigquery.model.JobConfiguration toPb() {
        com.google.api.services.bigquery.model.JobConfiguration configurationPb = new com.google.api.services.bigquery.model.JobConfiguration();
        JobConfigurationQuery queryConfigurationPb = new JobConfigurationQuery();
        queryConfigurationPb.setQuery(this.query);
        configurationPb.setDryRun(this.dryRun());
        if (this.allowLargeResults != null) {
            queryConfigurationPb.setAllowLargeResults(this.allowLargeResults);
        }
        if (this.createDisposition != null) {
            queryConfigurationPb.setCreateDisposition(this.createDisposition.toString());
        }
        if (this.destinationTable != null) {
            queryConfigurationPb.setDestinationTable(this.destinationTable.toPb());
        }
        if (this.defaultDataset != null) {
            queryConfigurationPb.setDefaultDataset(this.defaultDataset.toPb());
        }
        if (this.flattenResults != null) {
            queryConfigurationPb.setFlattenResults(this.flattenResults);
        }
        if (this.priority != null) {
            queryConfigurationPb.setPriority(this.priority.toString());
        }
        if (this.tableDefinitions != null) {
            queryConfigurationPb.setTableDefinitions(Maps.transformValues(this.tableDefinitions, ExternalTableDefinition.TO_EXTERNAL_DATA_FUNCTION));
        }
        if (this.useQueryCache != null) {
            queryConfigurationPb.setUseQueryCache(this.useQueryCache);
        }
        if (this.userDefinedFunctions != null) {
            queryConfigurationPb.setUserDefinedFunctionResources(Lists.transform(this.userDefinedFunctions, UserDefinedFunction.TO_PB_FUNCTION));
        }
        if (this.writeDisposition != null) {
            queryConfigurationPb.setWriteDisposition(this.writeDisposition.toString());
        }
        return configurationPb.setQuery(queryConfigurationPb);
    }

    public static Builder builder(String query) {
        return new Builder().query(query);
    }

    public static QueryJobConfiguration of(String query) {
        return QueryJobConfiguration.builder(query).build();
    }

    static QueryJobConfiguration fromPb(com.google.api.services.bigquery.model.JobConfiguration jobPb) {
        return new Builder(jobPb).build();
    }

    public static final class Builder
    extends JobConfiguration.Builder<QueryJobConfiguration, Builder> {
        private String query;
        private TableId destinationTable;
        private Map<String, ExternalTableDefinition> tableDefinitions;
        private List<UserDefinedFunction> userDefinedFunctions;
        private JobInfo.CreateDisposition createDisposition;
        private JobInfo.WriteDisposition writeDisposition;
        private DatasetId defaultDataset;
        private Priority priority;
        private Boolean allowLargeResults;
        private Boolean useQueryCache;
        private Boolean flattenResults;
        private Boolean dryRun;

        private Builder() {
            super(JobConfiguration.Type.QUERY);
        }

        private Builder(QueryJobConfiguration jobConfiguration) {
            this();
            this.query = jobConfiguration.query;
            this.destinationTable = jobConfiguration.destinationTable;
            this.tableDefinitions = jobConfiguration.tableDefinitions;
            this.userDefinedFunctions = jobConfiguration.userDefinedFunctions;
            this.createDisposition = jobConfiguration.createDisposition;
            this.writeDisposition = jobConfiguration.writeDisposition;
            this.defaultDataset = jobConfiguration.defaultDataset;
            this.priority = jobConfiguration.priority;
            this.allowLargeResults = jobConfiguration.allowLargeResults;
            this.useQueryCache = jobConfiguration.useQueryCache;
            this.flattenResults = jobConfiguration.flattenResults;
            this.dryRun = jobConfiguration.dryRun;
        }

        private Builder(com.google.api.services.bigquery.model.JobConfiguration configurationPb) {
            this();
            JobConfigurationQuery queryConfigurationPb = configurationPb.getQuery();
            this.query = queryConfigurationPb.getQuery();
            this.allowLargeResults = queryConfigurationPb.getAllowLargeResults();
            this.useQueryCache = queryConfigurationPb.getUseQueryCache();
            this.flattenResults = queryConfigurationPb.getFlattenResults();
            this.dryRun = configurationPb.getDryRun();
            if (queryConfigurationPb.getDestinationTable() != null) {
                this.destinationTable = TableId.fromPb(queryConfigurationPb.getDestinationTable());
            }
            if (queryConfigurationPb.getDefaultDataset() != null) {
                this.defaultDataset = DatasetId.fromPb(queryConfigurationPb.getDefaultDataset());
            }
            if (queryConfigurationPb.getPriority() != null) {
                this.priority = Priority.valueOf(queryConfigurationPb.getPriority());
            }
            if (queryConfigurationPb.getTableDefinitions() != null) {
                this.tableDefinitions = Maps.transformValues((Map)queryConfigurationPb.getTableDefinitions(), ExternalTableDefinition.FROM_EXTERNAL_DATA_FUNCTION);
            }
            if (queryConfigurationPb.getUserDefinedFunctionResources() != null) {
                this.userDefinedFunctions = Lists.transform((List)queryConfigurationPb.getUserDefinedFunctionResources(), UserDefinedFunction.FROM_PB_FUNCTION);
            }
            if (queryConfigurationPb.getCreateDisposition() != null) {
                this.createDisposition = JobInfo.CreateDisposition.valueOf(queryConfigurationPb.getCreateDisposition());
            }
            if (queryConfigurationPb.getWriteDisposition() != null) {
                this.writeDisposition = JobInfo.WriteDisposition.valueOf(queryConfigurationPb.getWriteDisposition());
            }
        }

        public Builder query(String query) {
            this.query = query;
            return this;
        }

        public Builder destinationTable(TableId destinationTable) {
            this.destinationTable = destinationTable;
            return this;
        }

        public Builder tableDefinitions(Map<String, ExternalTableDefinition> tableDefinitions) {
            this.tableDefinitions = tableDefinitions != null ? Maps.newHashMap(tableDefinitions) : null;
            return this;
        }

        public Builder addTableDefinition(String tableName, ExternalTableDefinition tableDefinition) {
            if (this.tableDefinitions == null) {
                this.tableDefinitions = Maps.newHashMap();
            }
            this.tableDefinitions.put((String)Preconditions.checkNotNull((Object)tableName), (ExternalTableDefinition)Preconditions.checkNotNull((Object)tableDefinition));
            return this;
        }

        public Builder userDefinedFunctions(List<UserDefinedFunction> userDefinedFunctions) {
            this.userDefinedFunctions = userDefinedFunctions != null ? ImmutableList.copyOf(userDefinedFunctions) : null;
            return this;
        }

        public Builder createDisposition(JobInfo.CreateDisposition createDisposition) {
            this.createDisposition = createDisposition;
            return this;
        }

        public Builder writeDisposition(JobInfo.WriteDisposition writeDisposition) {
            this.writeDisposition = writeDisposition;
            return this;
        }

        public Builder defaultDataset(DatasetId defaultDataset) {
            this.defaultDataset = defaultDataset;
            return this;
        }

        public Builder defaultDataset(String defaultDataset) {
            return this.defaultDataset(DatasetId.of(defaultDataset));
        }

        public Builder priority(Priority priority) {
            this.priority = priority;
            return this;
        }

        public Builder allowLargeResults(Boolean allowLargeResults) {
            this.allowLargeResults = allowLargeResults;
            return this;
        }

        public Builder useQueryCache(Boolean useQueryCache) {
            this.useQueryCache = useQueryCache;
            return this;
        }

        public Builder flattenResults(Boolean flattenResults) {
            this.flattenResults = flattenResults;
            return this;
        }

        public Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public QueryJobConfiguration build() {
            return new QueryJobConfiguration(this);
        }
    }

    public static enum Priority {
        INTERACTIVE,
        BATCH;

    }
}

