/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.bigquery.CsvOptions;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Objects;

public class FormatOptions
implements Serializable {
    static final String CSV = "CSV";
    static final String JSON = "NEWLINE_DELIMITED_JSON";
    static final String DATASTORE_BACKUP = "DATASTORE_BACKUP";
    private static final long serialVersionUID = -443376052020423691L;
    private final String type;

    FormatOptions(String type) {
        this.type = type;
    }

    public String type() {
        return this.type;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("format", (Object)this.type).toString();
    }

    public int hashCode() {
        return Objects.hash(this.type);
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(FormatOptions.class) && Objects.equals(this.type, ((FormatOptions)obj).type());
    }

    public static CsvOptions csv() {
        return CsvOptions.builder().build();
    }

    public static FormatOptions json() {
        return new FormatOptions(JSON);
    }

    public static FormatOptions datastoreBackup() {
        return new FormatOptions(DATASTORE_BACKUP);
    }

    public static FormatOptions of(String format) {
        if (((String)Preconditions.checkNotNull((Object)format)).equals(CSV)) {
            return FormatOptions.csv();
        }
        return new FormatOptions(format);
    }
}

