/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.examples.datastore;

import com.google.cloud.datastore.Datastore;
import com.google.cloud.datastore.DatastoreOptions;
import com.google.cloud.datastore.DateTime;
import com.google.cloud.datastore.Entity;
import com.google.cloud.datastore.EntityQuery;
import com.google.cloud.datastore.FullEntity;
import com.google.cloud.datastore.IncompleteKey;
import com.google.cloud.datastore.Key;
import com.google.cloud.datastore.KeyFactory;
import com.google.cloud.datastore.KeyQuery;
import com.google.cloud.datastore.Query;
import com.google.cloud.datastore.QueryResults;
import com.google.cloud.datastore.StructuredQuery;
import com.google.cloud.datastore.Transaction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class DatastoreExample {
    private static final String USER_KIND = "_DS_EXAMPLE_USER";
    private static final String COMMENT_KIND = "_DS_EXAMPLE_COMMENT";
    private static final String NAMESPACE = "gcloud_java_example";
    private static final String DEFAULT_ACTION = "display";
    private static final Map<String, DatastoreAction> ACTIONS = new HashMap<String, DatastoreAction>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String ... args) {
        String projectId = args.length > 0 ? args[0] : null;
        DatastoreOptions options = ((DatastoreOptions.Builder)DatastoreOptions.builder().projectId(projectId)).namespace(NAMESPACE).build();
        String name = args.length > 1 ? args[1] : System.getProperty("user.name");
        Datastore datastore = (Datastore)options.service();
        KeyFactory keyFactory = (KeyFactory)datastore.newKeyFactory().kind(USER_KIND);
        Key key = keyFactory.newKey(name);
        String actionName = args.length > 2 ? args[2].toLowerCase() : DEFAULT_ACTION;
        DatastoreAction action = ACTIONS.get(actionName);
        if (action == null) {
            StringBuilder actionAndParams = new StringBuilder();
            for (Map.Entry<String, DatastoreAction> entry : ACTIONS.entrySet()) {
                actionAndParams.append(entry.getKey());
                String param = entry.getValue().getRequiredParams();
                if (param != null && !param.isEmpty()) {
                    actionAndParams.append(' ').append(param);
                }
                actionAndParams.append('|');
            }
            actionAndParams.setLength(actionAndParams.length() - 1);
            System.out.printf("Usage: %s [projectId] [user] [%s]%n", DatastoreExample.class.getSimpleName(), actionAndParams);
            return;
        }
        args = args.length > 3 ? Arrays.copyOfRange(args, 3, args.length) : new String[]{};
        Transaction tx = datastore.newTransaction();
        try {
            action.run(tx, key, args);
            tx.commit();
        }
        finally {
            if (tx.active()) {
                tx.rollback();
            }
        }
    }

    static {
        ACTIONS.put("delete", new DeleteAction());
        ACTIONS.put("add", new AddAction());
        ACTIONS.put(DEFAULT_ACTION, new DisplayAction());
    }

    private static class AddAction
    implements DatastoreAction {
        private AddAction() {
        }

        @Override
        public void run(Transaction tx, Key userKey, String ... args) {
            Entity user = tx.get(userKey);
            if (user == null) {
                System.out.println("Adding a new user.");
                user = ((Entity.Builder)Entity.builder((Key)userKey).set("count", 1L)).build();
                tx.add((FullEntity)user);
            } else {
                user = ((Entity.Builder)Entity.builder((Entity)user).set("count", user.getLong("count") + 1L)).build();
                tx.update(new Entity[]{user});
            }
            String content = "No comment.";
            if (args.length > 0) {
                StringBuilder stBuilder = new StringBuilder();
                for (String arg : args) {
                    stBuilder.append(arg).append(' ');
                }
                stBuilder.setLength(stBuilder.length() - 1);
                content = stBuilder.toString();
            }
            IncompleteKey commentKey = IncompleteKey.builder((Key)userKey, (String)DatastoreExample.COMMENT_KIND).build();
            FullEntity comment = ((FullEntity.Builder)((FullEntity.Builder)FullEntity.builder((IncompleteKey)commentKey).set("content", content)).set("timestamp", DateTime.now())).build();
            tx.addWithDeferredIdAllocation(new FullEntity[]{comment});
            System.out.println("Adding a comment to user '" + userKey.name() + "'.");
        }

        @Override
        public String getRequiredParams() {
            return "comment";
        }
    }

    private static class DisplayAction
    implements DatastoreAction {
        private DisplayAction() {
        }

        @Override
        public void run(Transaction tx, Key userKey, String ... args) {
            Entity user = tx.get(userKey);
            if (user == null) {
                System.out.println("No comments for '" + userKey.name() + "'.");
                return;
            }
            System.out.printf("User '%s' has %d comment[s].%n", userKey.name(), user.getLong("count"));
            int limit = 200;
            TreeMap<DateTime, String> sortedComments = new TreeMap<DateTime, String>();
            EntityQuery query = ((EntityQuery.Builder)((EntityQuery.Builder)((EntityQuery.Builder)((EntityQuery.Builder)Query.entityQueryBuilder().namespace(DatastoreExample.NAMESPACE)).kind(DatastoreExample.COMMENT_KIND)).filter((StructuredQuery.Filter)StructuredQuery.PropertyFilter.hasAncestor((Key)userKey))).limit(Integer.valueOf(limit))).build();
            while (true) {
                QueryResults results = tx.run((Query)query);
                int resultCount = 0;
                while (results.hasNext()) {
                    Entity result = (Entity)results.next();
                    sortedComments.put(result.getDateTime("timestamp"), result.getString("content"));
                    ++resultCount;
                }
                if (resultCount < limit) break;
                query = query.toBuilder().startCursor(results.cursorAfter()).build();
            }
            for (Map.Entry entry : sortedComments.entrySet()) {
                System.out.printf("\t%s: %s%n", entry.getKey(), entry.getValue());
            }
        }

        @Override
        public String getRequiredParams() {
            return "";
        }
    }

    private static class DeleteAction
    implements DatastoreAction {
        private DeleteAction() {
        }

        @Override
        public void run(Transaction tx, Key userKey, String ... args) {
            Entity user = tx.get(userKey);
            if (user == null) {
                System.out.println("Nothing to delete, user does not exist.");
                return;
            }
            KeyQuery query = ((KeyQuery.Builder)((KeyQuery.Builder)((KeyQuery.Builder)Query.keyQueryBuilder().namespace(DatastoreExample.NAMESPACE)).kind(DatastoreExample.COMMENT_KIND)).filter((StructuredQuery.Filter)StructuredQuery.PropertyFilter.hasAncestor((Key)userKey))).build();
            QueryResults comments = tx.run((Query)query);
            int count = 0;
            while (comments.hasNext()) {
                tx.delete(new Key[]{(Key)comments.next()});
                ++count;
            }
            tx.delete(new Key[]{userKey});
            System.out.printf("Deleting user '%s' and %d comment[s].%n", userKey.name(), count);
        }

        @Override
        public String getRequiredParams() {
            return "";
        }
    }

    private static interface DatastoreAction {
        public void run(Transaction var1, Key var2, String ... var3);

        public String getRequiredParams();
    }
}

