/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.examples.bigquery;

import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryError;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.CopyJobConfiguration;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.DatasetInfo;
import com.google.cloud.bigquery.ExternalTableDefinition;
import com.google.cloud.bigquery.ExtractJobConfiguration;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FormatOptions;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.JobConfiguration;
import com.google.cloud.bigquery.JobId;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.LoadJobConfiguration;
import com.google.cloud.bigquery.QueryRequest;
import com.google.cloud.bigquery.QueryResponse;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.Table;
import com.google.cloud.bigquery.TableDataWriteChannel;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.ViewDefinition;
import com.google.cloud.bigquery.WriteChannelConfiguration;
import com.google.cloud.bigquery.spi.BigQueryRpc;
import com.google.common.collect.ImmutableMap;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class BigQueryExample {
    private static final int CHUNK_SIZE = 0x200000;
    private static final Map<String, BigQueryAction> CREATE_ACTIONS = new HashMap<String, BigQueryAction>();
    private static final Map<String, BigQueryAction> INFO_ACTIONS = new HashMap<String, BigQueryAction>();
    private static final Map<String, BigQueryAction> LIST_ACTIONS = new HashMap<String, BigQueryAction>();
    private static final Map<String, BigQueryAction> DELETE_ACTIONS = new HashMap<String, BigQueryAction>();
    private static final Map<String, BigQueryAction> ACTIONS = new HashMap<String, BigQueryAction>();

    private static void printUsage() {
        StringBuilder actionAndParams = new StringBuilder();
        for (Map.Entry<String, BigQueryAction> entry : ACTIONS.entrySet()) {
            actionAndParams.append("\n\t").append(entry.getKey());
            String param = entry.getValue().params();
            if (param == null || param.isEmpty()) continue;
            actionAndParams.append(' ').append(param.replace("\n", "\n\t\t"));
        }
        System.out.printf("Usage: %s [<project_id>] operation [entity] <args>*%s%n", BigQueryExample.class.getSimpleName(), actionAndParams);
    }

    public static void main(String ... args) throws Exception {
        Object arg;
        BigQueryAction action;
        String actionName;
        if (args.length < 1) {
            System.out.println("Missing required project id and action");
            BigQueryExample.printUsage();
            return;
        }
        BigQueryOptions.Builder optionsBuilder = BigQueryOptions.builder();
        if (args.length >= 2 && !ACTIONS.containsKey(args[0])) {
            actionName = args[1];
            optionsBuilder.projectId(args[0]);
            action = ACTIONS.get(args[1]);
            args = Arrays.copyOfRange(args, 2, args.length);
        } else {
            actionName = args[0];
            action = ACTIONS.get(args[0]);
            args = Arrays.copyOfRange(args, 1, args.length);
        }
        if (action == null) {
            System.out.println("Unrecognized action.");
            BigQueryExample.printUsage();
            return;
        }
        BigQuery bigquery = (BigQuery)optionsBuilder.build().service();
        try {
            arg = action.parse(args);
        }
        catch (IllegalArgumentException ex) {
            System.out.printf("Invalid input for action '%s'. %s%n", actionName, ex.getMessage());
            System.out.printf("Expected: %s%n", action.params());
            return;
        }
        catch (Exception ex) {
            System.out.println("Failed to parse arguments.");
            ex.printStackTrace();
            return;
        }
        action.run(bigquery, arg);
    }

    static {
        CREATE_ACTIONS.put("dataset", new CreateDatasetAction());
        CREATE_ACTIONS.put("table", new CreateSimpleTableAction());
        CREATE_ACTIONS.put("view", new CreateViewAction());
        CREATE_ACTIONS.put("external-table", new CreateExternalTableAction());
        INFO_ACTIONS.put("dataset", new DatasetInfoAction());
        INFO_ACTIONS.put("table", new TableInfoAction());
        INFO_ACTIONS.put("job", new JobInfoAction());
        LIST_ACTIONS.put("datasets", new ListDatasetsAction());
        LIST_ACTIONS.put("tables", new ListTablesAction());
        LIST_ACTIONS.put("jobs", new ListJobsAction());
        LIST_ACTIONS.put("data", new ListTableDataAction());
        DELETE_ACTIONS.put("dataset", new DeleteDatasetAction());
        DELETE_ACTIONS.put("table", new DeleteTableAction());
        ACTIONS.put("create", new ParentAction(CREATE_ACTIONS));
        ACTIONS.put("info", new ParentAction(INFO_ACTIONS));
        ACTIONS.put("list", new ParentAction(LIST_ACTIONS));
        ACTIONS.put("delete", new ParentAction(DELETE_ACTIONS));
        ACTIONS.put("cancel", new CancelJobAction());
        ACTIONS.put("load", new LoadAction());
        ACTIONS.put("extract", new ExtractAction());
        ACTIONS.put("copy", new CopyAction());
        ACTIONS.put("query", new QueryAction());
        ACTIONS.put("load-file", new LoadFileAction());
    }

    private static class LoadFileAction
    extends BigQueryAction<BigQueryRpc.Tuple<WriteChannelConfiguration, String>> {
        private LoadFileAction() {
        }

        @Override
        void run(BigQuery bigquery, BigQueryRpc.Tuple<WriteChannelConfiguration, String> configuration) throws Exception {
            System.out.println("Running insert");
            try (FileChannel fileChannel = FileChannel.open(Paths.get((String)configuration.y(), new String[0]), new OpenOption[0]);){
                TableDataWriteChannel writeChannel = bigquery.writer((WriteChannelConfiguration)configuration.x());
                long position = 0L;
                long written = fileChannel.transferTo(position, 0x200000L, (WritableByteChannel)writeChannel);
                while (written > 0L) {
                    written = fileChannel.transferTo(position += written, 0x200000L, (WritableByteChannel)writeChannel);
                }
                writeChannel.close();
            }
        }

        @Override
        BigQueryRpc.Tuple<WriteChannelConfiguration, String> parse(String ... args) throws Exception {
            if (args.length == 4) {
                String dataset = args[0];
                String table = args[1];
                String format = args[2];
                TableId tableId = TableId.of((String)dataset, (String)table);
                WriteChannelConfiguration configuration = WriteChannelConfiguration.of((TableId)tableId, (FormatOptions)FormatOptions.of((String)format));
                return BigQueryRpc.Tuple.of((Object)configuration, (Object)args[3]);
            }
            throw new IllegalArgumentException("Missing required arguments.");
        }

        @Override
        protected String params() {
            return "<dataset> <table> <format> <filePath>";
        }
    }

    private static class QueryAction
    extends BigQueryAction<QueryRequest> {
        private QueryAction() {
        }

        @Override
        void run(BigQuery bigquery, QueryRequest queryRequest) throws Exception {
            System.out.println("Running query");
            QueryResponse queryResponse = bigquery.query(queryRequest);
            while (!queryResponse.jobCompleted()) {
                System.out.println("Waiting for query job " + queryResponse.jobId() + " to complete");
                Thread.sleep(1000L);
                queryResponse = bigquery.getQueryResults(queryResponse.jobId(), new BigQuery.QueryResultsOption[0]);
            }
            if (!queryResponse.hasErrors()) {
                System.out.println("Query succeeded. Results:");
                Iterator iterator = queryResponse.result().iterateAll();
                while (iterator.hasNext()) {
                    System.out.println(iterator.next());
                }
            } else {
                System.out.println("Query completed with errors. Errors:");
                for (BigQueryError err : queryResponse.executionErrors()) {
                    System.out.println(err);
                }
            }
        }

        @Override
        QueryRequest parse(String ... args) throws Exception {
            if (args.length == 1) {
                return QueryRequest.of((String)args[0]);
            }
            String message = args.length > 1 ? "Too many arguments." : "Missing required query.";
            throw new IllegalArgumentException(message);
        }

        @Override
        protected String params() {
            return "<query>";
        }
    }

    private static class CopyAction
    extends JobRunAction {
        private CopyAction() {
        }

        @Override
        JobInfo parse(String ... args) throws Exception {
            if (args.length == 4) {
                TableId sourceTableId = TableId.of((String)args[0], (String)args[1]);
                TableId destinationTableId = TableId.of((String)args[2], (String)args[3]);
                return JobInfo.of((JobConfiguration)CopyJobConfiguration.of((TableId)destinationTableId, (TableId)sourceTableId));
            }
            String message = args.length < 3 ? "Missing required source or destination table." : "Too many arguments.";
            throw new IllegalArgumentException(message);
        }

        @Override
        protected String params() {
            return "<sourceDataset> <sourceTable> <destinationDataset> <destinationTable>";
        }
    }

    private static class ExtractAction
    extends JobRunAction {
        private ExtractAction() {
        }

        @Override
        JobInfo parse(String ... args) throws Exception {
            if (args.length >= 4) {
                String dataset = args[0];
                String table = args[1];
                String format = args[2];
                TableId tableId = TableId.of((String)dataset, (String)table);
                ExtractJobConfiguration configuration = ExtractJobConfiguration.of((TableId)tableId, Arrays.asList(args).subList(3, args.length), (String)format);
                return JobInfo.of((JobConfiguration)configuration);
            }
            throw new IllegalArgumentException("Missing required arguments.");
        }

        @Override
        protected String params() {
            return "<dataset> <table> <format> <destinationUri>+";
        }
    }

    private static class LoadAction
    extends JobRunAction {
        private LoadAction() {
        }

        @Override
        JobInfo parse(String ... args) throws Exception {
            if (args.length >= 4) {
                String dataset = args[0];
                String table = args[1];
                String format = args[2];
                TableId tableId = TableId.of((String)dataset, (String)table);
                LoadJobConfiguration configuration = LoadJobConfiguration.of((TableId)tableId, Arrays.asList(args).subList(3, args.length), (FormatOptions)FormatOptions.of((String)format));
                return JobInfo.of((JobConfiguration)configuration);
            }
            throw new IllegalArgumentException("Missing required arguments.");
        }

        @Override
        protected String params() {
            return "<dataset> <table> <format> <sourceUri>+";
        }
    }

    private static abstract class JobRunAction
    extends BigQueryAction<JobInfo> {
        private JobRunAction() {
        }

        @Override
        void run(BigQuery bigquery, JobInfo job) throws Exception {
            System.out.println("Creating job");
            Job startedJob = bigquery.create(job, new BigQuery.JobOption[0]);
            while (!startedJob.isDone()) {
                System.out.println("Waiting for job " + startedJob.jobId().job() + " to complete");
                Thread.sleep(1000L);
            }
            if (startedJob.status().error() == null) {
                System.out.println("Job " + startedJob.jobId().job() + " succeeded");
            } else {
                System.out.println("Job " + startedJob.jobId().job() + " failed");
                System.out.println("Error: " + startedJob.status().error());
            }
        }
    }

    private static class CreateViewAction
    extends CreateTableAction {
        private CreateViewAction() {
        }

        @Override
        TableInfo parse(String ... args) throws Exception {
            if (args.length == 3) {
                String dataset = args[0];
                String table = args[1];
                String query = args[2];
                TableId tableId = TableId.of((String)dataset, (String)table);
                return TableInfo.of((TableId)tableId, (TableDefinition)ViewDefinition.of((String)query));
            }
            String message = args.length < 3 ? "Missing required dataset id, table id or query." : "Too many arguments.";
            throw new IllegalArgumentException(message);
        }

        @Override
        protected String params() {
            return "<dataset> <table> <query>";
        }
    }

    private static class CreateExternalTableAction
    extends CreateTableAction {
        private CreateExternalTableAction() {
        }

        @Override
        TableInfo parse(String ... args) throws Exception {
            if (args.length >= 5) {
                String dataset = args[0];
                String table = args[1];
                TableId tableId = TableId.of((String)dataset, (String)table);
                ExternalTableDefinition externalTableDefinition = ExternalTableDefinition.of((String)args[args.length - 1], (Schema)CreateExternalTableAction.parseSchema(args, 3, args.length - 1), (FormatOptions)FormatOptions.of((String)args[2]));
                return TableInfo.of((TableId)tableId, (TableDefinition)externalTableDefinition);
            }
            throw new IllegalArgumentException("Missing required arguments.");
        }

        @Override
        protected String params() {
            return "<dataset> <table> <format> (<fieldName>:<primitiveType>)+ <sourceUri>";
        }
    }

    private static class CreateSimpleTableAction
    extends CreateTableAction {
        private CreateSimpleTableAction() {
        }

        @Override
        TableInfo parse(String ... args) throws Exception {
            if (args.length >= 3) {
                String dataset = args[0];
                String table = args[1];
                TableId tableId = TableId.of((String)dataset, (String)table);
                return TableInfo.of((TableId)tableId, (TableDefinition)StandardTableDefinition.of((Schema)CreateSimpleTableAction.parseSchema(args, 2, args.length)));
            }
            throw new IllegalArgumentException("Missing required arguments.");
        }

        @Override
        protected String params() {
            return "<dataset> <table> (<fieldName>:<primitiveType>)+";
        }
    }

    private static abstract class CreateTableAction
    extends BigQueryAction<TableInfo> {
        private CreateTableAction() {
        }

        @Override
        void run(BigQuery bigquery, TableInfo table) throws Exception {
            Table createTable = bigquery.create(table, new BigQuery.TableOption[0]);
            System.out.println("Created table:");
            System.out.println(createTable.toString());
        }

        static Schema parseSchema(String[] args, int start, int end) {
            Schema.Builder builder = Schema.builder();
            for (int i = start; i < end; ++i) {
                Field.Type fieldType;
                String typeString;
                String[] fieldsArray = args[i].split(":");
                if (fieldsArray.length != 2) {
                    throw new IllegalArgumentException("Unrecognized field definition '" + args[i] + "'.");
                }
                String fieldName = fieldsArray[0];
                switch (typeString = fieldsArray[1].toLowerCase()) {
                    case "string": {
                        fieldType = Field.Type.string();
                        break;
                    }
                    case "integer": {
                        fieldType = Field.Type.integer();
                        break;
                    }
                    case "timestamp": {
                        fieldType = Field.Type.timestamp();
                        break;
                    }
                    case "float": {
                        fieldType = Field.Type.floatingPoint();
                        break;
                    }
                    case "boolean": {
                        fieldType = Field.Type.bool();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unrecognized field type '" + typeString + "'.");
                    }
                }
                builder.addField(Field.of((String)fieldName, (Field.Type)fieldType));
            }
            return builder.build();
        }
    }

    private static class CancelJobAction
    extends JobAction {
        private CancelJobAction() {
        }

        @Override
        public void run(BigQuery bigquery, JobId jobId) {
            if (bigquery.cancel(jobId)) {
                System.out.println("Requested cancel for job " + jobId);
            } else {
                System.out.println("Job " + jobId + " not found");
            }
        }
    }

    private static class JobInfoAction
    extends JobAction {
        private JobInfoAction() {
        }

        @Override
        public void run(BigQuery bigquery, JobId jobId) {
            System.out.println("Job info: " + bigquery.getJob(jobId, new BigQuery.JobOption[0]));
        }
    }

    private static class ListJobsAction
    extends NoArgsAction {
        private ListJobsAction() {
        }

        @Override
        public void run(BigQuery bigquery, Void arg) {
            Iterator datasetInfoIterator = bigquery.listJobs(new BigQuery.JobListOption[0]).iterateAll();
            while (datasetInfoIterator.hasNext()) {
                System.out.println(datasetInfoIterator.next());
            }
        }
    }

    private static abstract class JobAction
    extends BigQueryAction<JobId> {
        private JobAction() {
        }

        @Override
        JobId parse(String ... args) throws Exception {
            if (args.length == 1) {
                return JobId.of((String)args[0]);
            }
            String message = args.length > 1 ? "Too many arguments." : "Missing required query.";
            throw new IllegalArgumentException(message);
        }

        @Override
        public String params() {
            return "<job>";
        }
    }

    private static class ListTableDataAction
    extends TableAction {
        private ListTableDataAction() {
        }

        @Override
        public void run(BigQuery bigquery, TableId tableId) {
            Iterator iterator = bigquery.listTableData(tableId, new BigQuery.TableDataListOption[0]).iterateAll();
            while (iterator.hasNext()) {
                System.out.println(iterator.next());
            }
        }
    }

    private static class DeleteTableAction
    extends TableAction {
        private DeleteTableAction() {
        }

        @Override
        public void run(BigQuery bigquery, TableId tableId) {
            if (bigquery.delete(tableId)) {
                System.out.println("Table " + tableId + " was deleted");
            } else {
                System.out.println("Table " + tableId + " not found");
            }
        }
    }

    private static class TableInfoAction
    extends TableAction {
        private TableInfoAction() {
        }

        @Override
        public void run(BigQuery bigquery, TableId tableId) {
            System.out.println("Table info: " + bigquery.getTable(tableId, new BigQuery.TableOption[0]));
        }
    }

    private static abstract class TableAction
    extends BigQueryAction<TableId> {
        private TableAction() {
        }

        @Override
        TableId parse(String ... args) throws Exception {
            if (args.length == 2) {
                return TableId.of((String)args[0], (String)args[1]);
            }
            String message = args.length < 2 ? "Missing required dataset and table id." : "Too many arguments.";
            throw new IllegalArgumentException(message);
        }

        @Override
        public String params() {
            return "<dataset> <table>";
        }
    }

    private static class DeleteDatasetAction
    extends DatasetAction {
        private DeleteDatasetAction() {
        }

        @Override
        public void run(BigQuery bigquery, DatasetId datasetId) {
            if (bigquery.delete(datasetId, new BigQuery.DatasetDeleteOption[0])) {
                System.out.println("Dataset " + datasetId + " was deleted");
            } else {
                System.out.println("Dataset " + datasetId + " not found");
            }
        }
    }

    private static class CreateDatasetAction
    extends DatasetAction {
        private CreateDatasetAction() {
        }

        @Override
        public void run(BigQuery bigquery, DatasetId datasetId) {
            bigquery.create(DatasetInfo.builder((DatasetId)datasetId).build(), new BigQuery.DatasetOption[0]);
            System.out.println("Created dataset " + datasetId);
        }
    }

    private static class DatasetInfoAction
    extends DatasetAction {
        private DatasetInfoAction() {
        }

        @Override
        public void run(BigQuery bigquery, DatasetId datasetId) {
            System.out.println("Dataset info: " + bigquery.getDataset(datasetId, new BigQuery.DatasetOption[0]));
        }
    }

    private static class ListTablesAction
    extends DatasetAction {
        private ListTablesAction() {
        }

        @Override
        public void run(BigQuery bigquery, DatasetId datasetId) {
            Iterator tableInfoIterator = bigquery.listTables(datasetId, new BigQuery.TableListOption[0]).iterateAll();
            while (tableInfoIterator.hasNext()) {
                System.out.println(tableInfoIterator.next());
            }
        }
    }

    private static abstract class DatasetAction
    extends BigQueryAction<DatasetId> {
        private DatasetAction() {
        }

        @Override
        DatasetId parse(String ... args) throws Exception {
            if (args.length == 1) {
                return DatasetId.of((String)args[0]);
            }
            String message = args.length > 1 ? "Too many arguments." : "Missing required dataset id.";
            throw new IllegalArgumentException(message);
        }

        @Override
        public String params() {
            return "<dataset>";
        }
    }

    private static class ListDatasetsAction
    extends NoArgsAction {
        private ListDatasetsAction() {
        }

        @Override
        public void run(BigQuery bigquery, Void arg) {
            Iterator datasetInfoIterator = bigquery.listDatasets(new BigQuery.DatasetListOption[0]).iterateAll();
            while (datasetInfoIterator.hasNext()) {
                System.out.println(datasetInfoIterator.next());
            }
        }
    }

    private static abstract class NoArgsAction
    extends BigQueryAction<Void> {
        private NoArgsAction() {
        }

        @Override
        Void parse(String ... args) throws Exception {
            if (args.length == 0) {
                return null;
            }
            throw new IllegalArgumentException("This action takes no arguments.");
        }
    }

    private static class ParentAction
    extends BigQueryAction<BigQueryRpc.Tuple<BigQueryAction, Object>> {
        private final Map<String, BigQueryAction> subActions;

        public ParentAction(Map<String, BigQueryAction> subActions) {
            this.subActions = ImmutableMap.copyOf(subActions);
        }

        @Override
        void run(BigQuery bigquery, BigQueryRpc.Tuple<BigQueryAction, Object> subaction) throws Exception {
            ((BigQueryAction)subaction.x()).run(bigquery, subaction.y());
        }

        @Override
        BigQueryRpc.Tuple<BigQueryAction, Object> parse(String ... args) throws Exception {
            if (args.length >= 1) {
                BigQueryAction action = this.subActions.get(args[0]);
                if (action != null) {
                    Object actionArguments = action.parse(Arrays.copyOfRange(args, 1, args.length));
                    return BigQueryRpc.Tuple.of((Object)action, actionArguments);
                }
                throw new IllegalArgumentException("Unrecognized entity '" + args[0] + "'.");
            }
            throw new IllegalArgumentException("Missing required entity.");
        }

        @Override
        public String params() {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<String, BigQueryAction> entry : this.subActions.entrySet()) {
                builder.append('\n').append(entry.getKey());
                String param = entry.getValue().params();
                if (param == null || param.isEmpty()) continue;
                builder.append(' ').append(param);
            }
            return builder.toString();
        }
    }

    private static abstract class BigQueryAction<T> {
        private BigQueryAction() {
        }

        abstract void run(BigQuery var1, T var2) throws Exception;

        abstract T parse(String ... var1) throws Exception;

        protected String params() {
            return "";
        }
    }
}

