/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.examples.datastore;

import com.google.cloud.datastore.Datastore;
import com.google.cloud.datastore.DatastoreOptions;
import com.google.cloud.datastore.DateTime;
import com.google.cloud.datastore.Entity;
import com.google.cloud.datastore.EntityQuery;
import com.google.cloud.datastore.FullEntity;
import com.google.cloud.datastore.IncompleteKey;
import com.google.cloud.datastore.Key;
import com.google.cloud.datastore.KeyFactory;
import com.google.cloud.datastore.KeyQuery;
import com.google.cloud.datastore.Query;
import com.google.cloud.datastore.QueryResults;
import com.google.cloud.datastore.StructuredQuery;
import com.google.cloud.datastore.Transaction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class DatastoreExample {
    private static final String USER_KIND = "_DS_EXAMPLE_USER";
    private static final String COMMENT_KIND = "_DS_EXAMPLE_COMMENT";
    private static final String NAMESPACE = "gcloud_java_example";
    private static final String DEFAULT_ACTION = "display";
    private static final Map<String, DatastoreAction> ACTIONS = new HashMap<String, DatastoreAction>();

    private static void printUsage() {
        StringBuilder actionAndParams = new StringBuilder();
        for (Map.Entry<String, DatastoreAction> entry : ACTIONS.entrySet()) {
            actionAndParams.append("\n\t").append(entry.getKey());
            String param = entry.getValue().params();
            if (param == null || param.isEmpty()) continue;
            actionAndParams.append(' ').append(param);
        }
        System.out.printf("Usage: %s <project_id> <user> operation <args>*%s%n", DatastoreExample.class.getSimpleName(), actionAndParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String ... args) throws Exception {
        Object request;
        String projectId = args.length > 0 ? args[0] : null;
        DatastoreOptions options = ((DatastoreOptions.Builder)DatastoreOptions.builder().projectId(projectId)).namespace(NAMESPACE).build();
        String name = args.length > 1 ? args[1] : System.getProperty("user.name");
        Datastore datastore = (Datastore)options.service();
        KeyFactory keyFactory = (KeyFactory)datastore.newKeyFactory().kind(USER_KIND);
        Key key = keyFactory.newKey(name);
        String actionName = args.length > 2 ? args[2].toLowerCase() : DEFAULT_ACTION;
        DatastoreAction action = ACTIONS.get(actionName);
        if (action == null) {
            System.out.println("Unrecognized action.");
            DatastoreExample.printUsage();
            return;
        }
        args = args.length > 3 ? Arrays.copyOfRange(args, 3, args.length) : new String[]{};
        Transaction tx = datastore.newTransaction();
        try {
            request = action.parse(args);
        }
        catch (IllegalArgumentException ex) {
            System.out.printf("Invalid input for action '%s'. %s%n", actionName, ex.getMessage());
            System.out.printf("Expected: %s%n", action.params());
            return;
        }
        catch (Exception ex) {
            System.out.println("Failed to parse request.");
            ex.printStackTrace();
            return;
        }
        try {
            action.run(tx, key, request);
            tx.commit();
        }
        finally {
            if (tx.active()) {
                tx.rollback();
            }
        }
    }

    static {
        ACTIONS.put("delete", new DeleteAction());
        ACTIONS.put("add", new AddCommentAction());
        ACTIONS.put("set", new SetContactAction());
        ACTIONS.put(DEFAULT_ACTION, new DisplayAction());
    }

    private static class SetContactAction
    extends DatastoreAction<Contact> {
        private SetContactAction() {
        }

        @Override
        public void run(Transaction tx, Key userKey, Contact contact) {
            Entity user = tx.get(userKey);
            if (user == null) {
                System.out.println("Adding a new user.");
                user = ((Entity.Builder)Entity.builder((Key)userKey).set("count", 0L)).build();
                tx.add((FullEntity)user);
            }
            FullEntity contactEntity = ((FullEntity.Builder)((FullEntity.Builder)FullEntity.builder().set("email", contact.email())).set("phone", contact.phone())).build();
            tx.update(new Entity[]{((Entity.Builder)Entity.builder((Entity)user).set("contact", contactEntity)).build()});
            System.out.printf("Setting contact for user '%s'.%n", userKey.name());
        }

        @Override
        Contact parse(String ... args) throws Exception {
            if (args.length == 2) {
                return new Contact(args[0], args[1]);
            }
            String message = args.length > 2 ? "Too many arguments." : "Missing required email and phone.";
            throw new IllegalArgumentException(message);
        }

        @Override
        protected String params() {
            return "<email> <phone>";
        }

        static final class Contact {
            private final String email;
            private final String phone;

            Contact(String email, String phone) {
                this.email = email;
                this.phone = phone;
            }

            String email() {
                return this.email;
            }

            String phone() {
                return this.phone;
            }
        }
    }

    private static class AddCommentAction
    extends DatastoreAction<String> {
        private AddCommentAction() {
        }

        @Override
        public void run(Transaction tx, Key userKey, String content) {
            Entity user = tx.get(userKey);
            if (user == null) {
                System.out.println("Adding a new user.");
                user = ((Entity.Builder)Entity.builder((Key)userKey).set("count", 1L)).build();
                tx.add((FullEntity)user);
            } else {
                user = ((Entity.Builder)Entity.builder((Entity)user).set("count", user.getLong("count") + 1L)).build();
                tx.update(new Entity[]{user});
            }
            IncompleteKey commentKey = IncompleteKey.builder((Key)userKey, (String)DatastoreExample.COMMENT_KIND).build();
            FullEntity comment = ((FullEntity.Builder)((FullEntity.Builder)FullEntity.builder((IncompleteKey)commentKey).set("content", content)).set("timestamp", DateTime.now())).build();
            tx.addWithDeferredIdAllocation(new FullEntity[]{comment});
            System.out.printf("Adding a comment to user '%s'.%n", userKey.name());
        }

        @Override
        String parse(String ... args) throws Exception {
            String content = "No comment.";
            if (args.length > 0) {
                StringBuilder stBuilder = new StringBuilder();
                for (String arg : args) {
                    stBuilder.append(arg).append(' ');
                }
                stBuilder.setLength(stBuilder.length() - 1);
                content = stBuilder.toString();
            }
            return content;
        }

        @Override
        protected String params() {
            return "<comment>";
        }
    }

    private static class DisplayAction
    extends DatastoreAction<Void> {
        private DisplayAction() {
        }

        @Override
        public void run(Transaction tx, Key userKey, Void arg) {
            Entity user = tx.get(userKey);
            if (user == null) {
                System.out.printf("User '%s' does not exist.%n", userKey.name());
                return;
            }
            if (user.contains("contact")) {
                FullEntity contact = user.getEntity("contact");
                String email = contact.getString("email");
                String phone = contact.getString("phone");
                System.out.printf("User '%s' email is '%s', phone is '%s'.%n", userKey.name(), email, phone);
            }
            System.out.printf("User '%s' has %d comment[s].%n", userKey.name(), user.getLong("count"));
            int limit = 200;
            TreeMap<DateTime, String> sortedComments = new TreeMap<DateTime, String>();
            EntityQuery query = ((EntityQuery.Builder)((EntityQuery.Builder)((EntityQuery.Builder)((EntityQuery.Builder)Query.entityQueryBuilder().namespace(DatastoreExample.NAMESPACE)).kind(DatastoreExample.COMMENT_KIND)).filter((StructuredQuery.Filter)StructuredQuery.PropertyFilter.hasAncestor((Key)userKey))).limit(Integer.valueOf(limit))).build();
            while (true) {
                QueryResults results = tx.run((Query)query);
                int resultCount = 0;
                while (results.hasNext()) {
                    Entity result = (Entity)results.next();
                    sortedComments.put(result.getDateTime("timestamp"), result.getString("content"));
                    ++resultCount;
                }
                if (resultCount < limit) break;
                query = query.toBuilder().startCursor(results.cursorAfter()).build();
            }
            for (Map.Entry entry : sortedComments.entrySet()) {
                System.out.printf("\t%s: %s%n", entry.getKey(), entry.getValue());
            }
        }

        @Override
        Void parse(String ... args) throws Exception {
            return null;
        }
    }

    private static class DeleteAction
    extends DatastoreAction<Void> {
        private DeleteAction() {
        }

        @Override
        public void run(Transaction tx, Key userKey, Void arg) {
            Entity user = tx.get(userKey);
            if (user == null) {
                System.out.println("Nothing to delete, user does not exist.");
                return;
            }
            KeyQuery query = ((KeyQuery.Builder)((KeyQuery.Builder)((KeyQuery.Builder)Query.keyQueryBuilder().namespace(DatastoreExample.NAMESPACE)).kind(DatastoreExample.COMMENT_KIND)).filter((StructuredQuery.Filter)StructuredQuery.PropertyFilter.hasAncestor((Key)userKey))).build();
            QueryResults comments = tx.run((Query)query);
            int count = 0;
            while (comments.hasNext()) {
                tx.delete(new Key[]{(Key)comments.next()});
                ++count;
            }
            tx.delete(new Key[]{userKey});
            System.out.printf("Deleting user '%s' and %d comment[s].%n", userKey.name(), count);
        }

        @Override
        Void parse(String ... args) throws Exception {
            return null;
        }
    }

    private static abstract class DatastoreAction<T> {
        private DatastoreAction() {
        }

        abstract void run(Transaction var1, Key var2, T var3) throws Exception;

        abstract T parse(String ... var1) throws Exception;

        protected String params() {
            return "";
        }
    }
}

