/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.examples.datastore.snippets;

import com.google.cloud.datastore.Datastore;
import com.google.cloud.datastore.DatastoreOptions;
import com.google.cloud.datastore.Entity;
import com.google.cloud.datastore.EntityQuery;
import com.google.cloud.datastore.Key;
import com.google.cloud.datastore.KeyFactory;
import com.google.cloud.datastore.Query;
import com.google.cloud.datastore.QueryResults;
import com.google.cloud.datastore.StructuredQuery;

public class AddEntitiesAndRunQuery {
    public static void main(String ... args) {
        Datastore datastore = (Datastore)DatastoreOptions.defaultInstance().service();
        KeyFactory keyFactory = (KeyFactory)datastore.newKeyFactory().kind("Person");
        Key key = keyFactory.newKey("john.doe@gmail.com");
        Entity entity = ((Entity.Builder)((Entity.Builder)((Entity.Builder)Entity.builder((Key)key).set("name", "John Doe")).set("age", 51L)).set("favorite_food", "pizza")).build();
        datastore.put(new Entity[]{entity});
        Entity johnEntity = datastore.get(key);
        Key janeKey = keyFactory.newKey("jane.doe@gmail.com");
        Entity janeEntity = ((Entity.Builder)((Entity.Builder)((Entity.Builder)Entity.builder((Key)janeKey).set("name", "Jane Doe")).set("age", 44L)).set("favorite_food", "pizza")).build();
        Key joeKey = keyFactory.newKey("joe.shmoe@gmail.com");
        Entity joeEntity = ((Entity.Builder)((Entity.Builder)((Entity.Builder)Entity.builder((Key)joeKey).set("name", "Joe Shmoe")).set("age", 27L)).set("favorite_food", "sushi")).build();
        datastore.put(new Entity[]{janeEntity, joeEntity});
        EntityQuery query = ((EntityQuery.Builder)((EntityQuery.Builder)Query.entityQueryBuilder().kind("Person")).filter((StructuredQuery.Filter)StructuredQuery.PropertyFilter.eq((String)"favorite_food", (String)"pizza"))).build();
        QueryResults results = datastore.run((Query)query);
        while (results.hasNext()) {
            Entity currentEntity = (Entity)results.next();
            System.out.println(currentEntity.getString("name") + ", you're invited to a pizza party!");
        }
    }
}

