/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.examples.compute;

import com.google.cloud.compute.AddressId;
import com.google.cloud.compute.AddressInfo;
import com.google.cloud.compute.AttachedDisk;
import com.google.cloud.compute.Compute;
import com.google.cloud.compute.ComputeOptions;
import com.google.cloud.compute.DiskConfiguration;
import com.google.cloud.compute.DiskId;
import com.google.cloud.compute.DiskImageConfiguration;
import com.google.cloud.compute.DiskInfo;
import com.google.cloud.compute.DiskTypeId;
import com.google.cloud.compute.GlobalAddressId;
import com.google.cloud.compute.GlobalOperationId;
import com.google.cloud.compute.ImageConfiguration;
import com.google.cloud.compute.ImageDiskConfiguration;
import com.google.cloud.compute.ImageId;
import com.google.cloud.compute.ImageInfo;
import com.google.cloud.compute.Instance;
import com.google.cloud.compute.InstanceId;
import com.google.cloud.compute.InstanceInfo;
import com.google.cloud.compute.LicenseId;
import com.google.cloud.compute.MachineTypeId;
import com.google.cloud.compute.NetworkConfiguration;
import com.google.cloud.compute.NetworkId;
import com.google.cloud.compute.NetworkInfo;
import com.google.cloud.compute.NetworkInterface;
import com.google.cloud.compute.Operation;
import com.google.cloud.compute.OperationId;
import com.google.cloud.compute.RegionAddressId;
import com.google.cloud.compute.RegionId;
import com.google.cloud.compute.RegionOperationId;
import com.google.cloud.compute.SchedulingOptions;
import com.google.cloud.compute.SnapshotDiskConfiguration;
import com.google.cloud.compute.SnapshotId;
import com.google.cloud.compute.SnapshotInfo;
import com.google.cloud.compute.StandardDiskConfiguration;
import com.google.cloud.compute.StandardNetworkConfiguration;
import com.google.cloud.compute.SubnetNetworkConfiguration;
import com.google.cloud.compute.SubnetworkId;
import com.google.cloud.compute.SubnetworkInfo;
import com.google.cloud.compute.ZoneId;
import com.google.cloud.compute.ZoneOperationId;
import com.google.cloud.compute.spi.ComputeRpc;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ComputeExample {
    private static final Map<String, ComputeAction> CREATE_ACTIONS = new HashMap<String, ComputeAction>();
    private static final Map<String, ComputeAction> INFO_ACTIONS = new HashMap<String, ComputeAction>();
    private static final Map<String, ComputeAction> LIST_ACTIONS = new HashMap<String, ComputeAction>();
    private static final Map<String, ComputeAction> DELETE_ACTIONS = new HashMap<String, ComputeAction>();
    private static final Map<String, ComputeAction> ACTIONS = new HashMap<String, ComputeAction>();

    private static void printUsage() {
        StringBuilder actionAndParams = new StringBuilder();
        for (Map.Entry<String, ComputeAction> entry : ACTIONS.entrySet()) {
            actionAndParams.append("\n\t").append(entry.getKey());
            String param = entry.getValue().params();
            if (param == null || param.isEmpty()) continue;
            actionAndParams.append(' ').append(param.replace("\n", "\n\t\t"));
        }
        System.out.printf("Usage: %s [<project_id>] operation [entity] <args>*%s%n", ComputeExample.class.getSimpleName(), actionAndParams);
    }

    public static void main(String ... args) throws Exception {
        Object arg;
        ComputeAction action;
        String actionName;
        if (args.length < 1) {
            System.out.println("Missing required project id and action");
            ComputeExample.printUsage();
            return;
        }
        ComputeOptions.Builder optionsBuilder = ComputeOptions.builder();
        if (args.length >= 2 && !ACTIONS.containsKey(args[0])) {
            actionName = args[1];
            optionsBuilder.projectId(args[0]);
            action = ACTIONS.get(args[1]);
            args = Arrays.copyOfRange(args, 2, args.length);
        } else {
            actionName = args[0];
            action = ACTIONS.get(args[0]);
            args = Arrays.copyOfRange(args, 1, args.length);
        }
        if (action == null) {
            System.out.println("Unrecognized action.");
            ComputeExample.printUsage();
            return;
        }
        Compute compute = (Compute)optionsBuilder.build().service();
        try {
            arg = action.parse(args);
        }
        catch (IllegalArgumentException ex) {
            System.out.printf("Invalid input for action '%s'. %s%n", actionName, ex.getMessage());
            System.out.printf("Expected: %s%n", action.params());
            return;
        }
        catch (Exception ex) {
            System.out.println("Failed to parse arguments.");
            ex.printStackTrace();
            return;
        }
        action.run(compute, arg);
    }

    static {
        CREATE_ACTIONS.put("address", new CreateAddressAction());
        CREATE_ACTIONS.put("snapshot", new CreateSnapshotAction());
        CREATE_ACTIONS.put("image", new CreateImageAction());
        CREATE_ACTIONS.put("standard-disk", new CreateStandardDiskAction());
        CREATE_ACTIONS.put("snapshot-disk", new CreateSnapshotDiskAction());
        CREATE_ACTIONS.put("image-disk", new CreateImageDiskAction());
        CREATE_ACTIONS.put("standard-network", new CreateStandardNetworkAction());
        CREATE_ACTIONS.put("subnet-network", new CreateSubnetNetworkAction());
        CREATE_ACTIONS.put("subnetwork", new CreateSubnetworkAction());
        CREATE_ACTIONS.put("instance", new CreateInstanceAction());
        INFO_ACTIONS.put("diskType", new DiskTypeInfoAction());
        INFO_ACTIONS.put("machineType", new MachineTypeInfoAction());
        INFO_ACTIONS.put("region", new RegionInfoAction());
        INFO_ACTIONS.put("zone", new ZoneInfoAction());
        INFO_ACTIONS.put("global-operation", new GlobalOperationInfoAction());
        INFO_ACTIONS.put("zone-operation", new ZoneOperationInfoAction());
        INFO_ACTIONS.put("region-operation", new RegionOperationInfoAction());
        INFO_ACTIONS.put("license", new LicenseInfoAction());
        INFO_ACTIONS.put("address", new AddressInfoAction());
        INFO_ACTIONS.put("snapshot", new SnapshotInfoAction());
        INFO_ACTIONS.put("image", new ImageInfoAction());
        INFO_ACTIONS.put("disk", new DiskInfoAction());
        INFO_ACTIONS.put("network", new NetworkInfoAction());
        INFO_ACTIONS.put("subnetwork", new SubnetworkInfoAction());
        INFO_ACTIONS.put("instance", new InstanceInfoAction());
        LIST_ACTIONS.put("diskTypes", new ListDiskTypesAction());
        LIST_ACTIONS.put("machineTypes", new ListMachineTypesAction());
        LIST_ACTIONS.put("regions", new ListRegionsAction());
        LIST_ACTIONS.put("zones", new ListZonesAction());
        LIST_ACTIONS.put("global-operations", new ListGlobalOperationsAction());
        LIST_ACTIONS.put("zone-operations", new ListZoneOperationsAction());
        LIST_ACTIONS.put("region-operations", new ListRegionOperationsAction());
        LIST_ACTIONS.put("addresses", new ListAddressesAction());
        LIST_ACTIONS.put("snapshots", new ListSnapshotsAction());
        LIST_ACTIONS.put("images", new ListImagesAction());
        LIST_ACTIONS.put("disks", new ListDisksAction());
        LIST_ACTIONS.put("networks", new ListNetworksAction());
        LIST_ACTIONS.put("subnetworks", new ListSubnetworksAction());
        LIST_ACTIONS.put("instances", new ListInstancesAction());
        DELETE_ACTIONS.put("global-operation", new DeleteGlobalOperationAction());
        DELETE_ACTIONS.put("zone-operation", new DeleteZoneOperationAction());
        DELETE_ACTIONS.put("region-operation", new DeleteRegionOperationAction());
        DELETE_ACTIONS.put("address", new DeleteAddressAction());
        DELETE_ACTIONS.put("snapshot", new DeleteSnapshotAction());
        DELETE_ACTIONS.put("image", new DeleteImageAction());
        DELETE_ACTIONS.put("disk", new DeleteDiskAction());
        DELETE_ACTIONS.put("network", new DeleteNetworkAction());
        DELETE_ACTIONS.put("subnetwork", new DeleteSubnetworkAction());
        DELETE_ACTIONS.put("instance", new DeleteInstanceAction());
        ACTIONS.put("create", new ParentAction(CREATE_ACTIONS));
        ACTIONS.put("info", new ParentAction(INFO_ACTIONS));
        ACTIONS.put("list", new ParentAction(LIST_ACTIONS));
        ACTIONS.put("delete", new ParentAction(DELETE_ACTIONS));
        ACTIONS.put("get-serial-port", new GetSerialPortAction());
        ACTIONS.put("add-access-config", new AddAccessConfigAction());
        ACTIONS.put("delete-access-config", new DeleteAccessConfigAction());
        ACTIONS.put("attach-disk", new AttachDiskAction());
        ACTIONS.put("detach-disk", new DetachDiskAction());
        ACTIONS.put("set-disk-auto-delete", new SetDiskAutoDeleteAction());
        ACTIONS.put("set-machine-type", new SetMachineTypeAction());
        ACTIONS.put("set-tags", new SetTagsAction());
        ACTIONS.put("set-metadata", new SetMetadataAction());
        ACTIONS.put("set-scheduling-options", new SetSchedulingOptionsAction());
        ACTIONS.put("reset", new ResetInstanceAction());
        ACTIONS.put("stop", new StopInstanceAction());
        ACTIONS.put("start", new StartInstanceAction());
    }

    private static class StartInstanceAction
    extends InstanceAction {
        private StartInstanceAction() {
        }

        @Override
        public void run(Compute compute, InstanceId instance) throws InterruptedException {
            Operation operation = compute.start(instance, new Compute.OperationOption[0]);
            if (operation == null) {
                System.out.printf("Instance %s does not exist%n", instance);
                return;
            }
            while (!operation.isDone()) {
                System.out.printf("Waiting for operation %s to complete%n", operation.operationId().operation());
                Thread.sleep(1000L);
            }
            if ((operation = operation.reload(new Compute.OperationOption[0])).errors() == null) {
                System.out.printf("Instance %s was started%n", instance);
            } else {
                System.out.printf("Attempt to start instance %s failed%n", instance);
                System.out.printf("Error: %s%n", operation.errors());
            }
        }
    }

    private static class StopInstanceAction
    extends InstanceAction {
        private StopInstanceAction() {
        }

        @Override
        public void run(Compute compute, InstanceId instance) throws InterruptedException {
            Operation operation = compute.stop(instance, new Compute.OperationOption[0]);
            if (operation == null) {
                System.out.printf("Instance %s does not exist%n", instance);
                return;
            }
            while (!operation.isDone()) {
                System.out.printf("Waiting for operation %s to complete%n", operation.operationId().operation());
                Thread.sleep(1000L);
            }
            if ((operation = operation.reload(new Compute.OperationOption[0])).errors() == null) {
                System.out.printf("Instance %s was stopped%n", instance);
            } else {
                System.out.printf("Attempt to stop instance %s failed%n", instance);
                System.out.printf("Error: %s%n", operation.errors());
            }
        }
    }

    private static class ResetInstanceAction
    extends InstanceAction {
        private ResetInstanceAction() {
        }

        @Override
        public void run(Compute compute, InstanceId instance) throws InterruptedException {
            Operation operation = compute.reset(instance, new Compute.OperationOption[0]);
            if (operation == null) {
                System.out.printf("Instance %s does not exist%n", instance);
                return;
            }
            while (!operation.isDone()) {
                System.out.printf("Waiting for operation %s to complete%n", operation.operationId().operation());
                Thread.sleep(1000L);
            }
            if ((operation = operation.reload(new Compute.OperationOption[0])).errors() == null) {
                System.out.printf("Instance %s was reset%n", instance);
            } else {
                System.out.printf("Attempt to reset instance %s failed%n", instance);
                System.out.printf("Error: %s%n", operation.errors());
            }
        }
    }

    private static class SetSchedulingOptionsAction
    extends ComputeAction<ComputeRpc.Tuple<InstanceId, SchedulingOptions>> {
        private SetSchedulingOptionsAction() {
        }

        @Override
        public void run(Compute compute, ComputeRpc.Tuple<InstanceId, SchedulingOptions> instanceAndScheduling) throws InterruptedException {
            SchedulingOptions schedulingOptions;
            InstanceId instanceId = (InstanceId)instanceAndScheduling.x();
            Operation operation = compute.setSchedulingOptions(instanceId, schedulingOptions = (SchedulingOptions)instanceAndScheduling.y(), new Compute.OperationOption[0]);
            if (operation == null) {
                System.out.printf("Instance %s does not exist%n", instanceId);
                return;
            }
            while (!operation.isDone()) {
                System.out.printf("Waiting for operation %s to complete%n", operation.operationId().operation());
                Thread.sleep(1000L);
            }
            if ((operation = operation.reload(new Compute.OperationOption[0])).errors() == null) {
                System.out.printf("Scheduling options set for instance %s%n", instanceId);
            } else {
                System.out.printf("Attempt to set scheduling options for instance %s failed%n", instanceId);
                System.out.printf("Error: %s%n", operation.errors());
            }
        }

        @Override
        ComputeRpc.Tuple<InstanceId, SchedulingOptions> parse(String ... args) throws Exception {
            String message;
            if (args.length > 2) {
                InstanceId instanceId = InstanceId.of((String)args[0], (String)args[1]);
                if (args.length == 3 && args[2].equals("preemptible")) {
                    return ComputeRpc.Tuple.of((Object)instanceId, (Object)SchedulingOptions.preemptible());
                }
                if (args.length == 5 && args[2].equals("standard")) {
                    boolean automaticRestart;
                    switch (args[3]) {
                        case "true": {
                            automaticRestart = true;
                            break;
                        }
                        case "false": {
                            automaticRestart = false;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Couldn't parse automaticRestart argument (must be either true or false).");
                        }
                    }
                    SchedulingOptions.Maintenance maintenance = SchedulingOptions.Maintenance.valueOf((String)args[4]);
                    return ComputeRpc.Tuple.of((Object)instanceId, (Object)SchedulingOptions.standard((boolean)automaticRestart, (SchedulingOptions.Maintenance)maintenance));
                }
                message = "Unexpected command line arguments.";
            } else {
                message = "Missing required arguments.";
            }
            throw new IllegalArgumentException(message);
        }

        @Override
        protected String params() {
            return "<zone> <instance> preemptible|(standard true|false MIGRATE|TERMINATE)";
        }
    }

    private static class SetMetadataAction
    extends ComputeAction<ComputeRpc.Tuple<InstanceId, Map<String, String>>> {
        private SetMetadataAction() {
        }

        @Override
        public void run(Compute compute, ComputeRpc.Tuple<InstanceId, Map<String, String>> instanceAndMetadata) throws InterruptedException {
            InstanceId instanceId = (InstanceId)instanceAndMetadata.x();
            Map metadata = (Map)instanceAndMetadata.y();
            Instance instance = compute.getInstance(instanceId, new Compute.InstanceOption[0]);
            if (instance == null) {
                System.out.printf("Instance %s does not exist%n", instanceId);
                return;
            }
            Operation operation = instance.setMetadata(metadata, new Compute.OperationOption[0]);
            while (!operation.isDone()) {
                System.out.printf("Waiting for operation %s to complete%n", operation.operationId().operation());
                Thread.sleep(1000L);
            }
            if ((operation = operation.reload(new Compute.OperationOption[0])).errors() == null) {
                System.out.printf("Metadata set for instance %s%n", instanceId);
            } else {
                System.out.printf("Attempt to set metadata for instance %s failed%n", instanceId);
                System.out.printf("Error: %s%n", operation.errors());
            }
        }

        @Override
        ComputeRpc.Tuple<InstanceId, Map<String, String>> parse(String ... args) throws Exception {
            if (args.length >= 2) {
                if ((args.length & 1) == 1) {
                    throw new IllegalArgumentException("Metadata must be a list of key-value pairs.");
                }
                InstanceId instanceId = InstanceId.of((String)args[0], (String)args[1]);
                HashMap metadata = Maps.newHashMapWithExpectedSize((int)(args.length / 2 - 1));
                for (int i = 2; i < args.length; i += 2) {
                    metadata.put(args[i], args[i + 1]);
                }
                return ComputeRpc.Tuple.of((Object)instanceId, (Object)metadata);
            }
            throw new IllegalArgumentException("Missing required arguments.");
        }

        @Override
        protected String params() {
            return "<zone> <instance> (<key> <value>)*";
        }
    }

    private static class SetTagsAction
    extends ComputeAction<ComputeRpc.Tuple<InstanceId, List<String>>> {
        private SetTagsAction() {
        }

        @Override
        public void run(Compute compute, ComputeRpc.Tuple<InstanceId, List<String>> instanceAndTags) throws InterruptedException {
            InstanceId instanceId = (InstanceId)instanceAndTags.x();
            List tags = (List)instanceAndTags.y();
            Instance instance = compute.getInstance(instanceId, new Compute.InstanceOption[0]);
            if (instance == null) {
                System.out.printf("Instance %s does not exist%n", instanceId);
                return;
            }
            Operation operation = instance.setTags((Iterable)tags, new Compute.OperationOption[0]);
            while (!operation.isDone()) {
                System.out.printf("Waiting for operation %s to complete%n", operation.operationId().operation());
                Thread.sleep(1000L);
            }
            if ((operation = operation.reload(new Compute.OperationOption[0])).errors() == null) {
                System.out.printf("Tags set for instance %s%n", instanceId);
            } else {
                System.out.printf("Attempt to set tags for instance %s failed%n", instanceId);
                System.out.printf("Error: %s%n", operation.errors());
            }
        }

        @Override
        ComputeRpc.Tuple<InstanceId, List<String>> parse(String ... args) throws Exception {
            if (args.length >= 2) {
                InstanceId instanceId = InstanceId.of((String)args[0], (String)args[1]);
                ArrayList tags = Lists.newArrayListWithCapacity((int)(args.length - 2));
                tags.addAll(Arrays.asList(args).subList(2, args.length));
                return ComputeRpc.Tuple.of((Object)instanceId, (Object)tags);
            }
            throw new IllegalArgumentException("Missing required arguments.");
        }

        @Override
        protected String params() {
            return "<zone> <instance> <tag>*";
        }
    }

    private static class SetMachineTypeAction
    extends ComputeAction<ComputeRpc.Tuple<InstanceId, MachineTypeId>> {
        private SetMachineTypeAction() {
        }

        @Override
        public void run(Compute compute, ComputeRpc.Tuple<InstanceId, MachineTypeId> instanceAndType) throws InterruptedException {
            MachineTypeId machineType;
            InstanceId instance = (InstanceId)instanceAndType.x();
            Operation operation = compute.setMachineType(instance, machineType = (MachineTypeId)instanceAndType.y(), new Compute.OperationOption[0]);
            if (operation == null) {
                System.out.printf("Instance %s does not exist%n", instance);
                return;
            }
            while (!operation.isDone()) {
                System.out.printf("Waiting for operation %s to complete%n", operation.operationId().operation());
                Thread.sleep(1000L);
            }
            if ((operation = operation.reload(new Compute.OperationOption[0])).errors() == null) {
                System.out.printf("Machine type set for instance %s%n", instance);
            } else {
                System.out.printf("Attempt to set machine type for instance %s failed%n", instance);
                System.out.printf("Error: %s%n", operation.errors());
            }
        }

        @Override
        ComputeRpc.Tuple<InstanceId, MachineTypeId> parse(String ... args) throws Exception {
            if (args.length == 3) {
                String zone = args[0];
                String instance = args[1];
                String machineType = args[2];
                return ComputeRpc.Tuple.of((Object)InstanceId.of((String)zone, (String)instance), (Object)MachineTypeId.of((String)zone, (String)machineType));
            }
            String message = args.length > 3 ? "Too many arguments." : "Missing required arguments.";
            throw new IllegalArgumentException(message);
        }

        @Override
        protected String params() {
            return "<zone> <instance> <machineType>";
        }
    }

    private static class SetDiskAutoDeleteAction
    extends ComputeAction<Triple<InstanceId, String, Boolean>> {
        private SetDiskAutoDeleteAction() {
        }

        @Override
        public void run(Compute compute, Triple<InstanceId, String, Boolean> deviceAndAutoDelete) throws InterruptedException {
            Boolean autoDelete;
            String deviceName;
            InstanceId instance = deviceAndAutoDelete.x();
            Operation operation = compute.setDiskAutoDelete(instance, deviceName = deviceAndAutoDelete.y(), (autoDelete = deviceAndAutoDelete.z()).booleanValue(), new Compute.OperationOption[0]);
            if (operation == null) {
                System.out.printf("Instance %s does not exist%n", instance);
                return;
            }
            while (!operation.isDone()) {
                System.out.printf("Waiting for operation %s to complete%n", operation.operationId().operation());
                Thread.sleep(1000L);
            }
            if ((operation = operation.reload(new Compute.OperationOption[0])).errors() == null) {
                System.out.printf("Auto-delete set for device %s of instance %s%n", deviceName, instance);
            } else {
                System.out.printf("Attempt to set auto-delete for device %s of instance %s failed%n", deviceName, instance);
                System.out.printf("Error: %s%n", operation.errors());
            }
        }

        @Override
        Triple<InstanceId, String, Boolean> parse(String ... args) throws Exception {
            if (args.length == 4) {
                boolean autoDelete;
                InstanceId instance = InstanceId.of((String)args[0], (String)args[1]);
                String deviceName = args[2];
                switch (args[3]) {
                    case "true": {
                        autoDelete = true;
                        break;
                    }
                    case "false": {
                        autoDelete = false;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Couldn't parse autoDelete argument (must be either true or false).");
                    }
                }
                return Triple.of(instance, deviceName, autoDelete);
            }
            String message = args.length > 3 ? "Too many arguments." : "Missing required arguments.";
            throw new IllegalArgumentException(message);
        }

        @Override
        protected String params() {
            return "<zone> <instance> <deviceName> true|false";
        }
    }

    private static class DetachDiskAction
    extends ComputeAction<ComputeRpc.Tuple<InstanceId, String>> {
        private DetachDiskAction() {
        }

        @Override
        public void run(Compute compute, ComputeRpc.Tuple<InstanceId, String> instanceAndDevice) throws InterruptedException {
            String deviceName;
            InstanceId instance = (InstanceId)instanceAndDevice.x();
            Operation operation = compute.detachDisk(instance, deviceName = (String)instanceAndDevice.y(), new Compute.OperationOption[0]);
            if (operation == null) {
                System.out.printf("Instance %s does not exist%n", instance);
                return;
            }
            while (!operation.isDone()) {
                System.out.printf("Waiting for operation %s to complete%n", operation.operationId().operation());
                Thread.sleep(1000L);
            }
            if ((operation = operation.reload(new Compute.OperationOption[0])).errors() == null) {
                System.out.printf("Disk detached from instance %s%n", instance);
            } else {
                System.out.printf("Attempt to detach disk from instance %s failed%n", instance);
                System.out.printf("Error: %s%n", operation.errors());
            }
        }

        @Override
        ComputeRpc.Tuple<InstanceId, String> parse(String ... args) throws Exception {
            if (args.length == 3) {
                String zone = args[0];
                String instance = args[1];
                String deviceName = args[2];
                return ComputeRpc.Tuple.of((Object)InstanceId.of((String)zone, (String)instance), (Object)deviceName);
            }
            String message = args.length > 4 ? "Too many arguments." : "Missing required arguments.";
            throw new IllegalArgumentException(message);
        }

        @Override
        protected String params() {
            return "<zone> <instance> <deviceName>";
        }
    }

    private static class AttachDiskAction
    extends ComputeAction<Triple<InstanceId, String, AttachedDisk.PersistentDiskConfiguration>> {
        private AttachDiskAction() {
        }

        @Override
        public void run(Compute compute, Triple<InstanceId, String, AttachedDisk.PersistentDiskConfiguration> instanceAndDisk) throws InterruptedException {
            AttachedDisk.PersistentDiskConfiguration diskConfiguration;
            String deviceName;
            InstanceId instance = instanceAndDisk.x();
            Operation operation = compute.attachDisk(instance, deviceName = instanceAndDisk.y(), diskConfiguration = instanceAndDisk.z(), new Compute.OperationOption[0]);
            if (operation == null) {
                System.out.printf("Instance %s does not exist%n", instance);
                return;
            }
            while (!operation.isDone()) {
                System.out.printf("Waiting for operation %s to complete%n", operation.operationId().operation());
                Thread.sleep(1000L);
            }
            if ((operation = operation.reload(new Compute.OperationOption[0])).errors() == null) {
                System.out.printf("Disk attached to instance %s%n", instance);
            } else {
                System.out.printf("Attempt to attach disk to instance %s failed%n", instance);
                System.out.printf("Error: %s%n", operation.errors());
            }
        }

        @Override
        Triple<InstanceId, String, AttachedDisk.PersistentDiskConfiguration> parse(String ... args) throws Exception {
            if (args.length == 4) {
                String zone = args[0];
                String instance = args[1];
                String deviceName = args[2];
                String disk = args[3];
                return Triple.of(InstanceId.of((String)zone, (String)instance), deviceName, AttachedDisk.PersistentDiskConfiguration.of((DiskId)DiskId.of((String)zone, (String)disk)));
            }
            String message = args.length > 4 ? "Too many arguments." : "Missing required arguments.";
            throw new IllegalArgumentException(message);
        }

        @Override
        protected String params() {
            return "<zone> <instance> <deviceName> <disk>";
        }
    }

    private static class DeleteAccessConfigAction
    extends ComputeAction<Triple<InstanceId, String, String>> {
        private DeleteAccessConfigAction() {
        }

        @Override
        public void run(Compute compute, Triple<InstanceId, String, String> interfaceAndConfig) throws InterruptedException {
            String accessConfig;
            String networkInterface;
            InstanceId instance = interfaceAndConfig.x();
            Operation operation = compute.deleteAccessConfig(instance, networkInterface = interfaceAndConfig.y(), accessConfig = interfaceAndConfig.z(), new Compute.OperationOption[0]);
            if (operation == null) {
                System.out.printf("Instance %s does not exist%n", instance);
                return;
            }
            while (!operation.isDone()) {
                System.out.printf("Waiting for operation %s to complete%n", operation.operationId().operation());
                Thread.sleep(1000L);
            }
            if ((operation = operation.reload(new Compute.OperationOption[0])).errors() == null) {
                System.out.printf("Access config deleted from network interface %s of instance %s%n", networkInterface, instance);
            } else {
                System.out.printf("Attempt to delete access config from network interface %s of instance %s failed%n", networkInterface, instance);
                System.out.printf("Error: %s%n", operation.errors());
            }
        }

        @Override
        Triple<InstanceId, String, String> parse(String ... args) throws Exception {
            if (args.length == 4) {
                InstanceId instance = InstanceId.of((String)args[0], (String)args[1]);
                String networkInterface = args[2];
                String accessConfig = args[3];
                return Triple.of(instance, networkInterface, accessConfig);
            }
            String message = args.length > 4 ? "Too many arguments." : "Missing required arguments.";
            throw new IllegalArgumentException(message);
        }

        @Override
        protected String params() {
            return "<zone> <instance> <networkInterface> <accessConfig>";
        }
    }

    private static class AddAccessConfigAction
    extends ComputeAction<Triple<InstanceId, String, NetworkInterface.AccessConfig>> {
        private AddAccessConfigAction() {
        }

        @Override
        public void run(Compute compute, Triple<InstanceId, String, NetworkInterface.AccessConfig> interfaceAndConfig) throws InterruptedException {
            NetworkInterface.AccessConfig accessConfig;
            String networkInterface;
            InstanceId instance = interfaceAndConfig.x();
            Operation operation = compute.addAccessConfig(instance, networkInterface = interfaceAndConfig.y(), accessConfig = interfaceAndConfig.z(), new Compute.OperationOption[0]);
            if (operation == null) {
                System.out.printf("Instance %s does not exist%n", instance);
                return;
            }
            while (!operation.isDone()) {
                System.out.printf("Waiting for operation %s to complete%n", operation.operationId().operation());
                Thread.sleep(1000L);
            }
            if ((operation = operation.reload(new Compute.OperationOption[0])).errors() == null) {
                System.out.printf("Access config added to network interface %s of instance %s%n", networkInterface, instance);
            } else {
                System.out.printf("Attempt to add access config to network interface %s of instance %s%n", networkInterface, instance);
                System.out.printf("Error: %s%n", operation.errors());
            }
        }

        @Override
        Triple<InstanceId, String, NetworkInterface.AccessConfig> parse(String ... args) throws Exception {
            String message;
            if (args.length >= 4) {
                InstanceId instance = InstanceId.of((String)args[0], (String)args[1]);
                String networkInterface = args[2];
                String accessConfig = args[3];
                if (args.length == 4) {
                    return Triple.of(instance, networkInterface, NetworkInterface.AccessConfig.builder().name(accessConfig).build());
                }
                if (args.length == 5) {
                    return Triple.of(instance, networkInterface, NetworkInterface.AccessConfig.builder().name(accessConfig).natIp(args[4]).build());
                }
                message = "Too many arguments.";
            } else {
                message = "Missing required arguments.";
            }
            throw new IllegalArgumentException(message);
        }

        @Override
        protected String params() {
            return "<zone> <instance> <networkInterface> <accessConfig> <IPaddress>?";
        }
    }

    private static class GetSerialPortAction
    extends ComputeAction<ComputeRpc.Tuple<InstanceId, Integer>> {
        private GetSerialPortAction() {
        }

        @Override
        public void run(Compute compute, ComputeRpc.Tuple<InstanceId, Integer> instanceAndPort) throws InterruptedException {
            String serialPortOutput;
            InstanceId instance = (InstanceId)instanceAndPort.x();
            Integer port = (Integer)instanceAndPort.y();
            if (port != null) {
                System.out.printf("Getting serial port %d output for instance %s%n", port, instance);
                serialPortOutput = compute.getSerialPortOutput(instance, port.intValue());
            } else {
                System.out.printf("Getting serial port output for instance %s%n", instance);
                serialPortOutput = compute.getSerialPortOutput(instance);
            }
            System.out.println(serialPortOutput);
        }

        @Override
        ComputeRpc.Tuple<InstanceId, Integer> parse(String ... args) throws Exception {
            if (args.length >= 2) {
                InstanceId instanceId = InstanceId.of((String)args[0], (String)args[1]);
                Integer port = null;
                if (args.length == 3) {
                    try {
                        port = Integer.parseInt(args[2]);
                    }
                    catch (NumberFormatException ex) {
                        throw new IllegalArgumentException("Error parsing portNumber parameter (must be a number)");
                    }
                } else if (args.length > 3) {
                    throw new IllegalArgumentException("Too many arguments.");
                }
                return ComputeRpc.Tuple.of((Object)instanceId, (Object)port);
            }
            throw new IllegalArgumentException("Missing required arguments.");
        }

        @Override
        protected String params() {
            return "<zone> <instance> <portNumber>";
        }
    }

    private static class CreateInstanceAction
    extends ComputeAction<InstanceInfo> {
        private CreateInstanceAction() {
        }

        @Override
        public void run(Compute compute, InstanceInfo instance) throws InterruptedException {
            Operation operation = compute.create(instance, new Compute.OperationOption[0]);
            while (!operation.isDone()) {
                System.out.printf("Waiting for operation %s to complete%n", operation.operationId().operation());
                Thread.sleep(1000L);
            }
            if ((operation = operation.reload(new Compute.OperationOption[0])).errors() == null) {
                System.out.printf("Instance %s was created%n", instance.instanceId());
            } else {
                System.out.printf("Creation of instance %s failed%n", instance.instanceId());
                System.out.printf("Error: %s%n", operation.errors());
            }
        }

        @Override
        InstanceInfo parse(String ... args) throws Exception {
            if (args.length == 5) {
                String zone = args[0];
                String instance = args[1];
                InstanceId instanceId = InstanceId.of((String)zone, (String)instance);
                MachineTypeId machineTypeId = MachineTypeId.of((String)zone, (String)args[2]);
                DiskId diskId = DiskId.of((String)zone, (String)args[3]);
                AttachedDisk disk = AttachedDisk.of((AttachedDisk.AttachedDiskConfiguration)AttachedDisk.PersistentDiskConfiguration.builder((DiskId)diskId).boot(true).build());
                NetworkInterface networkInterface = NetworkInterface.of((String)args[4]);
                return InstanceInfo.of((InstanceId)instanceId, (MachineTypeId)machineTypeId, (AttachedDisk)disk, (NetworkInterface)networkInterface);
            }
            String message = args.length > 5 ? "Too many arguments." : "Missing required arguments.";
            throw new IllegalArgumentException(message);
        }

        @Override
        protected String params() {
            return "<zone> <instance> <machineType> <disk> <network>";
        }
    }

    private static class DeleteInstanceAction
    extends InstanceAction {
        private DeleteInstanceAction() {
        }

        @Override
        public void run(Compute compute, InstanceId instance) throws InterruptedException {
            Operation operation = compute.deleteInstance(instance, new Compute.OperationOption[0]);
            if (operation == null) {
                System.out.printf("Instance %s does not exist%n", instance);
                return;
            }
            while (!operation.isDone()) {
                System.out.printf("Waiting for operation %s to complete%n", operation.operationId().operation());
                Thread.sleep(1000L);
            }
            if ((operation = operation.reload(new Compute.OperationOption[0])).errors() == null) {
                System.out.printf("Instance %s was deleted%n", instance);
            } else {
                System.out.printf("Deletion of instance %s failed%n", instance);
                System.out.printf("Error: %s%n", operation.errors());
            }
        }
    }

    private static class InstanceInfoAction
    extends InstanceAction {
        private InstanceInfoAction() {
        }

        @Override
        public void run(Compute compute, InstanceId instance) {
            System.out.printf("Instance info: %s%n", compute.getInstance(instance, new Compute.InstanceOption[0]));
        }
    }

    private static abstract class InstanceAction
    extends ComputeAction<InstanceId> {
        private InstanceAction() {
        }

        @Override
        InstanceId parse(String ... args) throws Exception {
            if (args.length == 2) {
                return InstanceId.of((String)args[0], (String)args[1]);
            }
            String message = args.length > 2 ? "Too many arguments." : "Missing required zone and instance.";
            throw new IllegalArgumentException(message);
        }

        @Override
        public String params() {
            return "<zone> <instance>";
        }
    }

    private static class ListInstancesAction
    extends OptionalZoneAction {
        private ListInstancesAction() {
        }

        @Override
        public void run(Compute compute, ZoneId zone) {
            Iterator instanceIterator = zone != null ? compute.listInstances(zone.zone(), new Compute.InstanceListOption[0]).iterateAll() : compute.listInstances(new Compute.InstanceAggregatedListOption[0]).iterateAll();
            while (instanceIterator.hasNext()) {
                System.out.println(instanceIterator.next());
            }
        }
    }

    private static class CreateSubnetworkAction
    extends ComputeAction<SubnetworkInfo> {
        private CreateSubnetworkAction() {
        }

        @Override
        public void run(Compute compute, SubnetworkInfo subnetwork) throws InterruptedException {
            Operation operation = compute.create(subnetwork, new Compute.OperationOption[0]);
            while (!operation.isDone()) {
                System.out.printf("Waiting for operation %s to complete%n", operation.operationId().operation());
                Thread.sleep(1000L);
            }
            if ((operation = operation.reload(new Compute.OperationOption[0])).errors() == null) {
                System.out.printf("Subnetwork %s was created%n", subnetwork.subnetworkId());
            } else {
                System.out.printf("Creation of subnetwork %s failed%n", subnetwork.subnetworkId());
                System.out.printf("Error: %s%n", operation.errors());
            }
        }

        @Override
        SubnetworkInfo parse(String ... args) throws Exception {
            if (args.length == 4) {
                SubnetworkId subnetwork = SubnetworkId.of((String)args[0], (String)args[1]);
                return SubnetworkInfo.of((SubnetworkId)subnetwork, (NetworkId)NetworkId.of((String)args[2]), (String)args[3]);
            }
            String message = args.length > 4 ? "Too many arguments." : "Missing required arguments.";
            throw new IllegalArgumentException(message);
        }

        @Override
        protected String params() {
            return "<region> <subnetwork> <network> <ipRange>";
        }
    }

    private static class DeleteSubnetworkAction
    extends SubnetworkAction {
        private DeleteSubnetworkAction() {
        }

        @Override
        public void run(Compute compute, SubnetworkId subnetwork) throws InterruptedException {
            Operation operation = compute.deleteSubnetwork(subnetwork, new Compute.OperationOption[0]);
            if (operation == null) {
                System.out.printf("Subnetwork %s does not exist%n", subnetwork);
                return;
            }
            while (!operation.isDone()) {
                System.out.printf("Waiting for operation %s to complete%n", operation.operationId().operation());
                Thread.sleep(1000L);
            }
            if ((operation = operation.reload(new Compute.OperationOption[0])).errors() == null) {
                System.out.printf("Subnetwork %s was deleted%n", subnetwork);
            } else {
                System.out.printf("Deletion of subnetwork %s failed%n", subnetwork);
                System.out.printf("Error: %s%n", operation.errors());
            }
        }
    }

    private static class SubnetworkInfoAction
    extends SubnetworkAction {
        private SubnetworkInfoAction() {
        }

        @Override
        public void run(Compute compute, SubnetworkId subnetwork) {
            System.out.printf("Subnetwork info: %s%n", compute.getSubnetwork(subnetwork, new Compute.SubnetworkOption[0]));
        }
    }

    private static abstract class SubnetworkAction
    extends ComputeAction<SubnetworkId> {
        private SubnetworkAction() {
        }

        @Override
        SubnetworkId parse(String ... args) throws Exception {
            if (args.length == 2) {
                return SubnetworkId.of((String)args[0], (String)args[1]);
            }
            String message = args.length > 2 ? "Too many arguments." : "Missing required region and subnetwork.";
            throw new IllegalArgumentException(message);
        }

        @Override
        public String params() {
            return "<region> <subnetwork>";
        }
    }

    private static class ListSubnetworksAction
    extends OptionalRegionAction {
        private ListSubnetworksAction() {
        }

        @Override
        public void run(Compute compute, RegionId region) {
            Iterator subnetworkIterator = region != null ? compute.listSubnetworks(region.region(), new Compute.SubnetworkListOption[0]).iterateAll() : compute.listSubnetworks(new Compute.SubnetworkAggregatedListOption[0]).iterateAll();
            while (subnetworkIterator.hasNext()) {
                System.out.println(subnetworkIterator.next());
            }
        }
    }

    private static class CreateSubnetNetworkAction
    extends CreateNetworkAction {
        private CreateSubnetNetworkAction() {
        }

        @Override
        NetworkInfo parse(String ... args) throws Exception {
            if (args.length == 2) {
                boolean autoCreateSubnetworks;
                switch (args[1]) {
                    case "true": {
                        autoCreateSubnetworks = true;
                        break;
                    }
                    case "false": {
                        autoCreateSubnetworks = false;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Couldn't parse autoCreateSubnetworks argument (must be either true or false).");
                    }
                }
                return NetworkInfo.of((NetworkId)NetworkId.of((String)args[0]), (NetworkConfiguration)SubnetNetworkConfiguration.of((boolean)autoCreateSubnetworks));
            }
            if (args.length > 2) {
                throw new IllegalArgumentException("Too many arguments.");
            }
            throw new IllegalArgumentException("Missing required arguments.");
        }

        @Override
        protected String params() {
            return "<network> true|false";
        }
    }

    private static class CreateStandardNetworkAction
    extends CreateNetworkAction {
        private CreateStandardNetworkAction() {
        }

        @Override
        NetworkInfo parse(String ... args) throws Exception {
            if (args.length == 2) {
                return NetworkInfo.of((NetworkId)NetworkId.of((String)args[0]), (NetworkConfiguration)StandardNetworkConfiguration.of((String)args[1]));
            }
            if (args.length > 2) {
                throw new IllegalArgumentException("Too many arguments.");
            }
            throw new IllegalArgumentException("Missing required arguments.");
        }

        @Override
        protected String params() {
            return "<network> <ipRange>";
        }
    }

    private static abstract class CreateNetworkAction
    extends ComputeAction<NetworkInfo> {
        private CreateNetworkAction() {
        }

        @Override
        public void run(Compute compute, NetworkInfo network) throws InterruptedException {
            Operation operation = compute.create(network, new Compute.OperationOption[0]);
            while (!operation.isDone()) {
                System.out.printf("Waiting for operation %s to complete%n", operation.operationId().operation());
                Thread.sleep(1000L);
            }
            if ((operation = operation.reload(new Compute.OperationOption[0])).errors() == null) {
                System.out.printf("Network %s was created%n", network.networkId());
            } else {
                System.out.printf("Creation of network %s failed%n", network.networkId());
                System.out.printf("Error: %s%n", operation.errors());
            }
        }
    }

    private static class DeleteNetworkAction
    extends NetworkAction {
        private DeleteNetworkAction() {
        }

        @Override
        public void run(Compute compute, NetworkId network) throws InterruptedException {
            Operation operation = compute.deleteNetwork(network.network(), new Compute.OperationOption[0]);
            if (operation == null) {
                System.out.printf("Network %s does not exist%n", network);
                return;
            }
            while (!operation.isDone()) {
                System.out.printf("Waiting for operation %s to complete%n", operation.operationId().operation());
                Thread.sleep(1000L);
            }
            if ((operation = operation.reload(new Compute.OperationOption[0])).errors() == null) {
                System.out.printf("Network %s was deleted%n", network);
            } else {
                System.out.printf("Deletion of network %s failed%n", network);
                System.out.printf("Error: %s%n", operation.errors());
            }
        }
    }

    private static class NetworkInfoAction
    extends NetworkAction {
        private NetworkInfoAction() {
        }

        @Override
        public void run(Compute compute, NetworkId network) {
            System.out.printf("Network info: %s%n", compute.getNetwork(network.network(), new Compute.NetworkOption[0]));
        }
    }

    private static abstract class NetworkAction
    extends ComputeAction<NetworkId> {
        private NetworkAction() {
        }

        @Override
        NetworkId parse(String ... args) throws Exception {
            if (args.length == 1) {
                return NetworkId.of((String)args[0]);
            }
            String message = args.length > 1 ? "Too many arguments." : "Missing required network id.";
            throw new IllegalArgumentException(message);
        }

        @Override
        public String params() {
            return "<network>";
        }
    }

    private static class ListNetworksAction
    extends NoArgsAction {
        private ListNetworksAction() {
        }

        @Override
        public void run(Compute compute, Void arg) {
            Iterator networkIterator = compute.listNetworks(new Compute.NetworkListOption[0]).iterateAll();
            while (networkIterator.hasNext()) {
                System.out.println(networkIterator.next());
            }
        }
    }

    private static class CreateImageDiskAction
    extends CreateDiskAction {
        private CreateImageDiskAction() {
        }

        @Override
        DiskInfo parse(String ... args) throws Exception {
            if (args.length == 3) {
                DiskId diskId = CreateImageDiskAction.parseDiskId(args);
                return DiskInfo.of((DiskId)diskId, (DiskConfiguration)ImageDiskConfiguration.of((ImageId)ImageId.of((String)args[2])));
            }
            if (args.length == 4) {
                DiskId diskId = CreateImageDiskAction.parseDiskId(args);
                return DiskInfo.of((DiskId)diskId, (DiskConfiguration)ImageDiskConfiguration.of((ImageId)ImageId.of((String)args[2], (String)args[3])));
            }
            if (args.length > 4) {
                throw new IllegalArgumentException("Too many arguments.");
            }
            throw new IllegalArgumentException("Missing required arguments.");
        }

        @Override
        protected String params() {
            return "<zone> <disk> <imageProject>? <image>";
        }
    }

    private static class CreateSnapshotDiskAction
    extends CreateDiskAction {
        private CreateSnapshotDiskAction() {
        }

        @Override
        DiskInfo parse(String ... args) throws Exception {
            if (args.length == 3) {
                DiskId diskId = CreateSnapshotDiskAction.parseDiskId(args);
                return DiskInfo.of((DiskId)diskId, (DiskConfiguration)SnapshotDiskConfiguration.of((SnapshotId)SnapshotId.of((String)args[2])));
            }
            if (args.length > 3) {
                throw new IllegalArgumentException("Too many arguments.");
            }
            throw new IllegalArgumentException("Missing required arguments.");
        }

        @Override
        protected String params() {
            return "<zone> <disk> <snapshot>";
        }
    }

    private static class CreateStandardDiskAction
    extends CreateDiskAction {
        private CreateStandardDiskAction() {
        }

        @Override
        DiskInfo parse(String ... args) throws Exception {
            if (args.length >= 3) {
                StandardDiskConfiguration configuration;
                DiskId diskId = CreateStandardDiskAction.parseDiskId(args);
                String diskType = args[2];
                if (args.length == 4) {
                    try {
                        configuration = StandardDiskConfiguration.of((DiskTypeId)DiskTypeId.of((String)diskId.zone(), (String)diskType), (long)Integer.parseInt(args[3]));
                    }
                    catch (NumberFormatException ex) {
                        throw new IllegalArgumentException("Error parsing disk size parameter.");
                    }
                } else if (args.length == 3) {
                    configuration = StandardDiskConfiguration.of((DiskTypeId)DiskTypeId.of((String)diskId.zone(), (String)diskType));
                } else {
                    throw new IllegalArgumentException("Too many arguments.");
                }
                return DiskInfo.of((DiskId)diskId, (DiskConfiguration)configuration);
            }
            throw new IllegalArgumentException("Missing required arguments.");
        }

        @Override
        protected String params() {
            return "<zone> <disk> <diskType> <diskSizeGb>?";
        }
    }

    private static abstract class CreateDiskAction
    extends ComputeAction<DiskInfo> {
        private CreateDiskAction() {
        }

        @Override
        public void run(Compute compute, DiskInfo disk) throws InterruptedException {
            Operation operation = compute.create(disk, new Compute.OperationOption[0]);
            while (!operation.isDone()) {
                System.out.printf("Waiting for operation %s to complete%n", operation.operationId().operation());
                Thread.sleep(1000L);
            }
            if ((operation = operation.reload(new Compute.OperationOption[0])).errors() == null) {
                System.out.printf("Disk %s was created%n", disk.diskId());
            } else {
                System.out.printf("Creation of disk %s failed%n", disk.diskId());
                System.out.printf("Error: %s%n", operation.errors());
            }
        }

        static DiskId parseDiskId(String[] args) {
            return DiskId.of((String)args[0], (String)args[1]);
        }
    }

    private static class ListDisksAction
    extends OptionalZoneAction {
        private ListDisksAction() {
        }

        @Override
        public void run(Compute compute, ZoneId zone) {
            Iterator diskIterator = compute.listDisks(new Compute.DiskAggregatedListOption[0]).iterateAll();
            while (diskIterator.hasNext()) {
                System.out.println(diskIterator.next());
            }
        }
    }

    private static class DeleteDiskAction
    extends DiskAction {
        private DeleteDiskAction() {
        }

        @Override
        public void run(Compute compute, DiskId disk) throws InterruptedException {
            Operation operation = compute.deleteDisk(disk, new Compute.OperationOption[0]);
            if (operation == null) {
                System.out.printf("Disk %s does not exist%n", disk);
                return;
            }
            while (!operation.isDone()) {
                System.out.printf("Waiting for operation %s to complete%n", operation.operationId().operation());
                Thread.sleep(1000L);
            }
            if ((operation = operation.reload(new Compute.OperationOption[0])).errors() == null) {
                System.out.printf("Disk %s was deleted%n", disk);
            } else {
                System.out.printf("Deletion of disk %s failed%n", disk);
                System.out.printf("Error: %s%n", operation.errors());
            }
        }
    }

    private static class DiskInfoAction
    extends DiskAction {
        private DiskInfoAction() {
        }

        @Override
        public void run(Compute compute, DiskId disk) {
            System.out.printf("Disk info: %s%n", compute.getDisk(disk, new Compute.DiskOption[0]));
        }
    }

    private static abstract class DiskAction
    extends ComputeAction<DiskId> {
        private DiskAction() {
        }

        @Override
        DiskId parse(String ... args) throws Exception {
            if (args.length == 2) {
                return DiskId.of((String)args[0], (String)args[1]);
            }
            String message = args.length > 2 ? "Too many arguments." : "Missing required zone and disk id.";
            throw new IllegalArgumentException(message);
        }

        @Override
        public String params() {
            return "<zone> <disk>";
        }
    }

    private static class CreateImageAction
    extends ComputeAction<ImageInfo> {
        private CreateImageAction() {
        }

        @Override
        public void run(Compute compute, ImageInfo image) throws InterruptedException {
            Operation operation = compute.create(image, new Compute.OperationOption[0]);
            while (!operation.isDone()) {
                System.out.printf("Waiting for operation %s to complete%n", operation.operationId().operation());
                Thread.sleep(1000L);
            }
            if ((operation = operation.reload(new Compute.OperationOption[0])).errors() == null) {
                System.out.printf("Image %s was created%n", image.imageId());
            } else {
                System.out.printf("Creation of image %s failed%n", image.imageId());
                System.out.printf("Error: %s%n", operation.errors());
            }
        }

        @Override
        ImageInfo parse(String ... args) throws Exception {
            if (args.length == 3) {
                String image = args[0];
                String zone = args[1];
                String disk = args[2];
                return ImageInfo.of((ImageId)ImageId.of((String)image), (ImageConfiguration)DiskImageConfiguration.of((DiskId)DiskId.of((String)zone, (String)disk)));
            }
            String message = args.length > 3 ? "Too many arguments." : "Missing required arguments.";
            throw new IllegalArgumentException(message);
        }

        @Override
        protected String params() {
            return "<image> <zone> <disk>";
        }
    }

    private static class DeleteImageAction
    extends ImageAction {
        private DeleteImageAction() {
        }

        @Override
        public void run(Compute compute, ImageId image) throws InterruptedException {
            Operation operation = compute.deleteImage(image, new Compute.OperationOption[0]);
            if (operation == null) {
                System.out.printf("Image %s does not exist%n", image);
                return;
            }
            while (!operation.isDone()) {
                System.out.printf("Waiting for operation %s to complete%n", operation.operationId().operation());
                Thread.sleep(1000L);
            }
            if ((operation = operation.reload(new Compute.OperationOption[0])).errors() == null) {
                System.out.printf("Image %s was deleted%n", image);
            } else {
                System.out.printf("Deletion of image %s failed%n", image);
                System.out.printf("Error: %s%n", operation.errors());
            }
        }
    }

    private static class ImageInfoAction
    extends ImageAction {
        private ImageInfoAction() {
        }

        @Override
        public void run(Compute compute, ImageId image) {
            System.out.printf("Image info: %s%n", compute.getImage(image, new Compute.ImageOption[0]));
        }
    }

    private static abstract class ImageAction
    extends ComputeAction<ImageId> {
        private ImageAction() {
        }

        @Override
        ImageId parse(String ... args) throws Exception {
            if (args.length == 1) {
                return ImageId.of((String)args[0]);
            }
            String message = args.length > 1 ? "Too many arguments." : "Missing required image id.";
            throw new IllegalArgumentException(message);
        }

        @Override
        public String params() {
            return "<image>";
        }
    }

    private static class ListImagesAction
    extends NoArgsAction {
        private ListImagesAction() {
        }

        @Override
        public void run(Compute compute, Void arg) {
            Iterator imageIterator = compute.listImages(new Compute.ImageListOption[0]).iterateAll();
            while (imageIterator.hasNext()) {
                System.out.println(imageIterator.next());
            }
        }
    }

    private static class CreateSnapshotAction
    extends ComputeAction<SnapshotInfo> {
        private CreateSnapshotAction() {
        }

        @Override
        public void run(Compute compute, SnapshotInfo snapshot) throws InterruptedException {
            Operation operation = compute.create(snapshot, new Compute.OperationOption[0]);
            while (!operation.isDone()) {
                System.out.printf("Waiting for operation %s to complete%n", operation.operationId().operation());
                Thread.sleep(1000L);
            }
            if ((operation = operation.reload(new Compute.OperationOption[0])).errors() == null) {
                System.out.printf("Snapshot %s was created%n", snapshot.snapshotId());
            } else {
                System.out.printf("Creation of snapshot %s failed%n", snapshot.snapshotId());
                System.out.printf("Error: %s%n", operation.errors());
            }
        }

        @Override
        SnapshotInfo parse(String ... args) throws Exception {
            if (args.length == 3) {
                String snapshot = args[0];
                String zone = args[1];
                String disk = args[2];
                return SnapshotInfo.of((SnapshotId)SnapshotId.of((String)snapshot), (DiskId)DiskId.of((String)zone, (String)disk));
            }
            String message = args.length > 3 ? "Too many arguments." : "Missing required arguments.";
            throw new IllegalArgumentException(message);
        }

        @Override
        protected String params() {
            return "<snapshot> <zone> <disk>";
        }
    }

    private static class DeleteSnapshotAction
    extends SnapshotAction {
        private DeleteSnapshotAction() {
        }

        @Override
        public void run(Compute compute, SnapshotId snapshot) throws InterruptedException {
            Operation operation = compute.deleteSnapshot(snapshot.snapshot(), new Compute.OperationOption[0]);
            if (operation == null) {
                System.out.printf("Snapshot %s does not exist%n", snapshot);
                return;
            }
            while (!operation.isDone()) {
                System.out.printf("Waiting for operation %s to complete%n", operation.operationId().operation());
                Thread.sleep(1000L);
            }
            if ((operation = operation.reload(new Compute.OperationOption[0])).errors() == null) {
                System.out.printf("Snapshot %s was deleted%n", snapshot);
            } else {
                System.out.printf("Deletion of snapshot %s failed%n", snapshot);
                System.out.printf("Error: %s%n", operation.errors());
            }
        }
    }

    private static class SnapshotInfoAction
    extends SnapshotAction {
        private SnapshotInfoAction() {
        }

        @Override
        public void run(Compute compute, SnapshotId snapshot) {
            System.out.printf("Snapshot info: %s%n", compute.getSnapshot(snapshot.snapshot(), new Compute.SnapshotOption[0]));
        }
    }

    private static abstract class SnapshotAction
    extends ComputeAction<SnapshotId> {
        private SnapshotAction() {
        }

        @Override
        SnapshotId parse(String ... args) throws Exception {
            if (args.length == 1) {
                return SnapshotId.of((String)args[0]);
            }
            String message = args.length > 1 ? "Too many arguments." : "Missing required shapshot id.";
            throw new IllegalArgumentException(message);
        }

        @Override
        public String params() {
            return "<snapshot>";
        }
    }

    private static class ListSnapshotsAction
    extends NoArgsAction {
        private ListSnapshotsAction() {
        }

        @Override
        public void run(Compute compute, Void arg) {
            Iterator snapshotIterator = compute.listSnapshots(new Compute.SnapshotListOption[0]).iterateAll();
            while (snapshotIterator.hasNext()) {
                System.out.println(snapshotIterator.next());
            }
        }
    }

    private static class CreateAddressAction
    extends AddressAction {
        private CreateAddressAction() {
        }

        @Override
        public void run(Compute compute, AddressId address) throws InterruptedException {
            Operation operation = compute.create(AddressInfo.of((AddressId)address), new Compute.OperationOption[0]);
            while (!operation.isDone()) {
                System.out.printf("Waiting for operation %s to complete%n", operation.operationId().operation());
                Thread.sleep(1000L);
            }
            if ((operation = operation.reload(new Compute.OperationOption[0])).errors() == null) {
                System.out.printf("Address %s was created%n", address);
            } else {
                System.out.printf("Creation of address %s failed%n", address);
                System.out.printf("Error: %s%n", operation.errors());
            }
        }
    }

    private static class DeleteAddressAction
    extends AddressAction {
        private DeleteAddressAction() {
        }

        @Override
        public void run(Compute compute, AddressId address) throws InterruptedException {
            Operation operation = compute.deleteAddress(address, new Compute.OperationOption[0]);
            if (operation == null) {
                System.out.printf("Address %s does not exist%n", address);
                return;
            }
            while (!operation.isDone()) {
                System.out.printf("Waiting for operation %s to complete%n", operation.operationId().operation());
                Thread.sleep(1000L);
            }
            if ((operation = operation.reload(new Compute.OperationOption[0])).errors() == null) {
                System.out.printf("Address %s was deleted%n", address);
            } else {
                System.out.printf("Deletion of address %s failed%n", address);
                System.out.printf("Error: %s%n", operation.errors());
            }
        }
    }

    private static class AddressInfoAction
    extends AddressAction {
        private AddressInfoAction() {
        }

        @Override
        public void run(Compute compute, AddressId address) {
            System.out.printf("Address info: %s%n", compute.getAddress(address, new Compute.AddressOption[0]));
        }
    }

    private static abstract class AddressAction
    extends ComputeAction<AddressId> {
        private AddressAction() {
        }

        @Override
        AddressId parse(String ... args) throws Exception {
            if (args.length == 2) {
                return RegionAddressId.of((String)args[0], (String)args[1]);
            }
            if (args.length == 1) {
                return GlobalAddressId.of((String)args[0]);
            }
            String message = args.length > 2 ? "Too many arguments." : "Missing required address id.";
            throw new IllegalArgumentException(message);
        }

        @Override
        public String params() {
            return "<region>? <address>";
        }
    }

    private static class ListAddressesAction
    extends OptionalRegionAction {
        private ListAddressesAction() {
        }

        @Override
        public void run(Compute compute, RegionId region) {
            Iterator addressIterator = region != null ? compute.listRegionAddresses(region.region(), new Compute.AddressListOption[0]).iterateAll() : compute.listAddresses(new Compute.AddressAggregatedListOption[0]).iterateAll();
            while (addressIterator.hasNext()) {
                System.out.println(addressIterator.next());
            }
        }
    }

    private static class DeleteRegionOperationAction
    extends RegionOperationAction {
        private DeleteRegionOperationAction() {
        }

        @Override
        public void run(Compute compute, RegionOperationId operation) {
            if (compute.deleteOperation((OperationId)operation)) {
                System.out.printf("Operation %s was deleted%n", operation);
            } else {
                System.out.printf("Operation %s not found%n", operation);
            }
        }
    }

    private static class DeleteZoneOperationAction
    extends ZoneOperationAction {
        private DeleteZoneOperationAction() {
        }

        @Override
        public void run(Compute compute, ZoneOperationId operation) {
            if (compute.deleteOperation((OperationId)operation)) {
                System.out.printf("Operation %s was deleted%n", operation);
            } else {
                System.out.printf("Operation %s not found%n", operation);
            }
        }
    }

    private static class DeleteGlobalOperationAction
    extends GlobalOperationAction {
        private DeleteGlobalOperationAction() {
        }

        @Override
        public void run(Compute compute, GlobalOperationId operation) {
            if (compute.deleteOperation((OperationId)operation)) {
                System.out.printf("Operation %s was deleted%n", operation);
            } else {
                System.out.printf("Operation %s not found%n", operation);
            }
        }
    }

    private static class RegionOperationInfoAction
    extends RegionOperationAction {
        private RegionOperationInfoAction() {
        }

        @Override
        public void run(Compute compute, RegionOperationId operation) {
            System.out.printf("Operation info: %s%n", compute.getOperation((OperationId)operation, new Compute.OperationOption[0]));
        }
    }

    private static class ZoneOperationInfoAction
    extends ZoneOperationAction {
        private ZoneOperationInfoAction() {
        }

        @Override
        public void run(Compute compute, ZoneOperationId operation) {
            System.out.printf("Operation info: %s%n", compute.getOperation((OperationId)operation, new Compute.OperationOption[0]));
        }
    }

    private static class GlobalOperationInfoAction
    extends GlobalOperationAction {
        private GlobalOperationInfoAction() {
        }

        @Override
        public void run(Compute compute, GlobalOperationId operation) {
            System.out.printf("Operation info: %s%n", compute.getOperation((OperationId)operation, new Compute.OperationOption[0]));
        }
    }

    private static abstract class RegionOperationAction
    extends ComputeAction<RegionOperationId> {
        private RegionOperationAction() {
        }

        @Override
        RegionOperationId parse(String ... args) throws Exception {
            if (args.length == 2) {
                return RegionOperationId.of((String)args[0], (String)args[1]);
            }
            String message = args.length > 2 ? "Too many arguments." : "Missing required region and operation id.";
            throw new IllegalArgumentException(message);
        }

        @Override
        public String params() {
            return "<region> <operation>";
        }
    }

    private static abstract class ZoneOperationAction
    extends ComputeAction<ZoneOperationId> {
        private ZoneOperationAction() {
        }

        @Override
        ZoneOperationId parse(String ... args) throws Exception {
            if (args.length == 2) {
                return ZoneOperationId.of((String)args[0], (String)args[1]);
            }
            String message = args.length > 2 ? "Too many arguments." : "Missing required zone and operation id.";
            throw new IllegalArgumentException(message);
        }

        @Override
        public String params() {
            return "<zone> <operation>";
        }
    }

    private static abstract class GlobalOperationAction
    extends ComputeAction<GlobalOperationId> {
        private GlobalOperationAction() {
        }

        @Override
        GlobalOperationId parse(String ... args) throws Exception {
            if (args.length == 1) {
                return GlobalOperationId.of((String)args[0]);
            }
            String message = args.length > 1 ? "Too many arguments." : "Missing required operation id.";
            throw new IllegalArgumentException(message);
        }

        @Override
        public String params() {
            return "<operation>";
        }
    }

    private static class ListRegionOperationsAction
    extends ComputeAction<RegionId> {
        private ListRegionOperationsAction() {
        }

        @Override
        public void run(Compute compute, RegionId region) {
            Iterator operationIterator = compute.listRegionOperations(region.region(), new Compute.OperationListOption[0]).iterateAll();
            while (operationIterator.hasNext()) {
                System.out.println(operationIterator.next());
            }
        }

        @Override
        RegionId parse(String ... args) throws Exception {
            if (args.length == 1) {
                return RegionId.of((String)args[0]);
            }
            String message = args.length > 1 ? "Too many arguments." : "Missing required region id.";
            throw new IllegalArgumentException(message);
        }

        @Override
        public String params() {
            return "<region>";
        }
    }

    private static class ListZoneOperationsAction
    extends ComputeAction<ZoneId> {
        private ListZoneOperationsAction() {
        }

        @Override
        public void run(Compute compute, ZoneId zone) {
            Iterator operationIterator = compute.listZoneOperations(zone.zone(), new Compute.OperationListOption[0]).iterateAll();
            while (operationIterator.hasNext()) {
                System.out.println(operationIterator.next());
            }
        }

        @Override
        ZoneId parse(String ... args) throws Exception {
            if (args.length == 1) {
                return ZoneId.of((String)args[0]);
            }
            String message = args.length > 1 ? "Too many arguments." : "Missing required zone id.";
            throw new IllegalArgumentException(message);
        }

        @Override
        public String params() {
            return "<zone>";
        }
    }

    private static class ListGlobalOperationsAction
    extends NoArgsAction {
        private ListGlobalOperationsAction() {
        }

        @Override
        public void run(Compute compute, Void arg) {
            Iterator operationIterator = compute.listGlobalOperations(new Compute.OperationListOption[0]).iterateAll();
            while (operationIterator.hasNext()) {
                System.out.println(operationIterator.next());
            }
        }
    }

    private static class LicenseInfoAction
    extends ComputeAction<LicenseId> {
        private LicenseInfoAction() {
        }

        @Override
        public void run(Compute compute, LicenseId license) {
            System.out.printf("License info: %s%n", compute.getLicense(license.license(), new Compute.LicenseOption[0]));
        }

        @Override
        LicenseId parse(String ... args) throws Exception {
            if (args.length == 1) {
                return LicenseId.of((String)args[0]);
            }
            String message = args.length > 1 ? "Too many arguments." : "Missing required license id.";
            throw new IllegalArgumentException(message);
        }

        @Override
        public String params() {
            return "<license>";
        }
    }

    private static class ZoneInfoAction
    extends ComputeAction<ZoneId> {
        private ZoneInfoAction() {
        }

        @Override
        public void run(Compute compute, ZoneId zone) {
            System.out.printf("Zone info: %s%n", compute.getZone(zone.zone(), new Compute.ZoneOption[0]));
        }

        @Override
        ZoneId parse(String ... args) throws Exception {
            if (args.length == 1) {
                return ZoneId.of((String)args[0]);
            }
            String message = args.length > 1 ? "Too many arguments." : "Missing required zone id.";
            throw new IllegalArgumentException(message);
        }

        @Override
        public String params() {
            return "<zone>";
        }
    }

    private static class ListZonesAction
    extends NoArgsAction {
        private ListZonesAction() {
        }

        @Override
        public void run(Compute compute, Void arg) {
            Iterator zoneIterator = compute.listZones(new Compute.ZoneListOption[0]).iterateAll();
            while (zoneIterator.hasNext()) {
                System.out.println(zoneIterator.next());
            }
        }
    }

    private static class RegionInfoAction
    extends ComputeAction<RegionId> {
        private RegionInfoAction() {
        }

        @Override
        public void run(Compute compute, RegionId region) {
            System.out.printf("Region info: %s%n", compute.getRegion(region.region(), new Compute.RegionOption[0]));
        }

        @Override
        RegionId parse(String ... args) throws Exception {
            if (args.length == 1) {
                return RegionId.of((String)args[0]);
            }
            String message = args.length > 1 ? "Too many arguments." : "Missing required region id.";
            throw new IllegalArgumentException(message);
        }

        @Override
        public String params() {
            return "<region>";
        }
    }

    private static class ListRegionsAction
    extends NoArgsAction {
        private ListRegionsAction() {
        }

        @Override
        public void run(Compute compute, Void arg) {
            Iterator regionIterator = compute.listRegions(new Compute.RegionListOption[0]).iterateAll();
            while (regionIterator.hasNext()) {
                System.out.println(regionIterator.next());
            }
        }
    }

    private static class MachineTypeInfoAction
    extends ComputeAction<MachineTypeId> {
        private MachineTypeInfoAction() {
        }

        @Override
        public void run(Compute compute, MachineTypeId machineType) {
            System.out.printf("Machine type info: %s%n", compute.getMachineType(machineType, new Compute.MachineTypeOption[0]));
        }

        @Override
        MachineTypeId parse(String ... args) throws Exception {
            if (args.length == 2) {
                return MachineTypeId.of((String)args[0], (String)args[1]);
            }
            String message = args.length < 2 ? "Missing required zone and machine type id." : "Too many arguments.";
            throw new IllegalArgumentException(message);
        }

        @Override
        public String params() {
            return "<zone> <machineType>";
        }
    }

    private static class ListMachineTypesAction
    extends OptionalZoneAction {
        private ListMachineTypesAction() {
        }

        @Override
        public void run(Compute compute, ZoneId zone) {
            Iterator machineTypeIterator = zone != null ? compute.listMachineTypes(zone.zone(), new Compute.MachineTypeListOption[0]).iterateAll() : compute.listMachineTypes(new Compute.MachineTypeAggregatedListOption[0]).iterateAll();
            while (machineTypeIterator.hasNext()) {
                System.out.println(machineTypeIterator.next());
            }
        }
    }

    private static class DiskTypeInfoAction
    extends ComputeAction<DiskTypeId> {
        private DiskTypeInfoAction() {
        }

        @Override
        public void run(Compute compute, DiskTypeId diskType) {
            System.out.printf("Disk type info: %s%n", compute.getDiskType(diskType, new Compute.DiskTypeOption[0]));
        }

        @Override
        DiskTypeId parse(String ... args) throws Exception {
            if (args.length == 2) {
                return DiskTypeId.of((String)args[0], (String)args[1]);
            }
            String message = args.length < 2 ? "Missing required zone and disk type id." : "Too many arguments.";
            throw new IllegalArgumentException(message);
        }

        @Override
        public String params() {
            return "<zone> <diskType>";
        }
    }

    private static class ListDiskTypesAction
    extends OptionalZoneAction {
        private ListDiskTypesAction() {
        }

        @Override
        public void run(Compute compute, ZoneId zone) {
            Iterator diskTypeIterator = zone != null ? compute.listDiskTypes(zone.zone(), new Compute.DiskTypeListOption[0]).iterateAll() : compute.listDiskTypes(new Compute.DiskTypeAggregatedListOption[0]).iterateAll();
            while (diskTypeIterator.hasNext()) {
                System.out.println(diskTypeIterator.next());
            }
        }
    }

    private static abstract class NoArgsAction
    extends ComputeAction<Void> {
        private NoArgsAction() {
        }

        @Override
        Void parse(String ... args) throws Exception {
            if (args.length == 0) {
                return null;
            }
            throw new IllegalArgumentException("This action takes no arguments.");
        }
    }

    private static abstract class OptionalRegionAction
    extends ComputeAction<RegionId> {
        private OptionalRegionAction() {
        }

        @Override
        RegionId parse(String ... args) throws Exception {
            if (args.length == 1) {
                return RegionId.of((String)args[0]);
            }
            if (args.length <= 1) {
                return null;
            }
            String message = "Too many arguments.";
            throw new IllegalArgumentException(message);
        }

        @Override
        public String params() {
            return "<region>?";
        }
    }

    private static abstract class OptionalZoneAction
    extends ComputeAction<ZoneId> {
        private OptionalZoneAction() {
        }

        @Override
        ZoneId parse(String ... args) throws Exception {
            if (args.length == 1) {
                return ZoneId.of((String)args[0]);
            }
            if (args.length <= 1) {
                return null;
            }
            String message = "Too many arguments.";
            throw new IllegalArgumentException(message);
        }

        @Override
        public String params() {
            return "<zone>?";
        }
    }

    private static class ParentAction
    extends ComputeAction<ComputeRpc.Tuple<ComputeAction, Object>> {
        private final Map<String, ComputeAction> subActions;

        ParentAction(Map<String, ComputeAction> subActions) {
            this.subActions = ImmutableMap.copyOf(subActions);
        }

        @Override
        void run(Compute compute, ComputeRpc.Tuple<ComputeAction, Object> subaction) throws Exception {
            ((ComputeAction)subaction.x()).run(compute, subaction.y());
        }

        @Override
        ComputeRpc.Tuple<ComputeAction, Object> parse(String ... args) throws Exception {
            if (args.length >= 1) {
                ComputeAction action = this.subActions.get(args[0]);
                if (action != null) {
                    Object actionArguments = action.parse(Arrays.copyOfRange(args, 1, args.length));
                    return ComputeRpc.Tuple.of((Object)action, actionArguments);
                }
                throw new IllegalArgumentException("Unrecognized entity '" + args[0] + "'.");
            }
            throw new IllegalArgumentException("Missing required entity.");
        }

        @Override
        public String params() {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<String, ComputeAction> entry : this.subActions.entrySet()) {
                builder.append('\n').append(entry.getKey());
                String param = entry.getValue().params();
                if (param == null || param.isEmpty()) continue;
                builder.append(' ').append(param);
            }
            return builder.toString();
        }
    }

    private static abstract class ComputeAction<T> {
        private ComputeAction() {
        }

        abstract void run(Compute var1, T var2) throws Exception;

        abstract T parse(String ... var1) throws Exception;

        protected String params() {
            return "";
        }
    }

    static class Triple<X, Y, Z> {
        private final X x;
        private final Y y;
        private final Z z;

        private Triple(X x, Y y, Z z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public static <X, Y, Z> Triple<X, Y, Z> of(X x, Y y, Z z) {
            return new Triple<X, Y, Z>(x, y, z);
        }

        X x() {
            return this.x;
        }

        Y y() {
            return this.y;
        }

        Z z() {
            return this.z;
        }
    }
}

