/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.examples.compute.snippets;

import com.google.cloud.WaitForOption;
import com.google.cloud.compute.Address;
import com.google.cloud.compute.AddressId;
import com.google.cloud.compute.AddressInfo;
import com.google.cloud.compute.AttachedDisk;
import com.google.cloud.compute.Compute;
import com.google.cloud.compute.ComputeOptions;
import com.google.cloud.compute.DiskConfiguration;
import com.google.cloud.compute.DiskId;
import com.google.cloud.compute.DiskInfo;
import com.google.cloud.compute.ImageDiskConfiguration;
import com.google.cloud.compute.ImageId;
import com.google.cloud.compute.InstanceId;
import com.google.cloud.compute.InstanceInfo;
import com.google.cloud.compute.MachineTypeId;
import com.google.cloud.compute.NetworkId;
import com.google.cloud.compute.NetworkInterface;
import com.google.cloud.compute.Operation;
import com.google.cloud.compute.RegionAddressId;
import java.util.concurrent.TimeoutException;

public class CreateAddressDiskAndInstance {
    public static void main(String ... args) throws InterruptedException, TimeoutException {
        Compute compute = (Compute)ComputeOptions.defaultInstance().service();
        RegionAddressId addressId = RegionAddressId.of((String)"us-central1", (String)"test-address");
        Operation operation = compute.create(AddressInfo.of((AddressId)addressId), new Compute.OperationOption[0]);
        if ((operation = operation.waitFor(new WaitForOption[0])).errors() != null) {
            throw new RuntimeException("Address creation failed");
        }
        System.out.println("Address " + addressId + " was successfully created");
        ImageId imageId = ImageId.of((String)"debian-cloud", (String)"debian-8-jessie-v20160329");
        DiskId diskId = DiskId.of((String)"us-central1-a", (String)"test-disk");
        ImageDiskConfiguration diskConfiguration = ImageDiskConfiguration.of((ImageId)imageId);
        DiskInfo disk = DiskInfo.of((DiskId)diskId, (DiskConfiguration)diskConfiguration);
        operation = compute.create(disk, new Compute.OperationOption[0]);
        operation = operation.waitFor(new WaitForOption[0]);
        if (operation.errors() != null) {
            throw new RuntimeException("Disk creation failed");
        }
        System.out.println("Disk " + diskId + " was successfully created");
        Address externalIp = compute.getAddress((AddressId)addressId, new Compute.AddressOption[0]);
        InstanceId instanceId = InstanceId.of((String)"us-central1-a", (String)"test-instance");
        NetworkId networkId = NetworkId.of((String)"default");
        AttachedDisk.PersistentDiskConfiguration attachConfiguration = AttachedDisk.PersistentDiskConfiguration.builder((DiskId)diskId).boot(true).build();
        AttachedDisk attachedDisk = AttachedDisk.of((String)"dev0", (AttachedDisk.AttachedDiskConfiguration)attachConfiguration);
        NetworkInterface networkInterface = NetworkInterface.builder((NetworkId)networkId).accessConfigurations(new NetworkInterface.AccessConfig[]{NetworkInterface.AccessConfig.of((String)externalIp.address())}).build();
        MachineTypeId machineTypeId = MachineTypeId.of((String)"us-central1-a", (String)"n1-standard-1");
        InstanceInfo instance = InstanceInfo.of((InstanceId)instanceId, (MachineTypeId)machineTypeId, (AttachedDisk)attachedDisk, (NetworkInterface)networkInterface);
        operation = compute.create(instance, new Compute.OperationOption[0]);
        operation = operation.waitFor(new WaitForOption[0]);
        if (operation.errors() != null) {
            throw new RuntimeException("Instance creation failed");
        }
        System.out.println("Instance " + instanceId + " was successfully created");
    }
}

