/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.examples.dns.snippets;

import com.google.cloud.dns.ChangeRequest;
import com.google.cloud.dns.ChangeRequestInfo;
import com.google.cloud.dns.Dns;
import com.google.cloud.dns.DnsOptions;
import com.google.cloud.dns.RecordSet;
import com.google.cloud.dns.Zone;
import com.google.cloud.dns.ZoneInfo;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ManipulateZonesAndRecordSets {
    public static void main(String ... args) {
        boolean result;
        Dns dns = (Dns)DnsOptions.defaultInstance().service();
        String zoneName = "my-unique-zone";
        String domainName = "someexampledomain.com.";
        String description = "This is a gcloud-java-dns sample zone.";
        ZoneInfo zoneInfo = ZoneInfo.of((String)zoneName, (String)domainName, (String)description);
        Zone zone = dns.create(zoneInfo, new Dns.ZoneOption[0]);
        System.out.printf("Zone was created and assigned ID %s.%n", zone.generatedId());
        List nameServers = zone.nameServers();
        for (String nameServer : nameServers) {
            System.out.println(nameServer);
        }
        String ip = "12.13.14.15";
        RecordSet toCreate = RecordSet.builder((String)"www.someexampledomain.com.", (RecordSet.Type)RecordSet.Type.A).ttl(24, TimeUnit.HOURS).addRecord(ip).build();
        ChangeRequestInfo.Builder changeBuilder = ChangeRequestInfo.builder().add(toCreate);
        Iterator recordSetIterator = zone.listRecordSets(new Dns.RecordSetListOption[0]).iterateAll();
        while (recordSetIterator.hasNext()) {
            RecordSet current = (RecordSet)recordSetIterator.next();
            if (!toCreate.name().equals(current.name()) || !toCreate.type().equals((Object)current.type())) continue;
            changeBuilder.delete(current);
        }
        ChangeRequestInfo changeRequest = changeBuilder.build();
        zone.applyChangeRequest(changeRequest, new Dns.ChangeRequestOption[0]);
        while (ChangeRequestInfo.Status.PENDING.equals((Object)changeRequest.status())) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                System.err.println("The thread was interrupted while waiting...");
            }
            changeRequest = dns.getChangeRequest(zone.name(), changeRequest.generatedId(), new Dns.ChangeRequestOption[0]);
        }
        System.out.println("The change request has been applied.");
        Iterator zoneIterator = dns.listZones(new Dns.ZoneListOption[0]).iterateAll();
        int counter = 1;
        while (zoneIterator.hasNext()) {
            System.out.printf("#%d.: %s%n%n", counter, zoneIterator.next());
            ++counter;
        }
        recordSetIterator = zone.listRecordSets(new Dns.RecordSetListOption[0]).iterateAll();
        System.out.println(String.format("Record sets inside %s:", zone.name()));
        while (recordSetIterator.hasNext()) {
            System.out.println(recordSetIterator.next());
        }
        Iterator changeIterator = zone.listChangeRequests(new Dns.ChangeRequestListOption[0]).iterateAll();
        System.out.println(String.format("The history of changes in %s:", zone.name()));
        while (changeIterator.hasNext()) {
            System.out.println(changeIterator.next());
        }
        changeBuilder = ChangeRequestInfo.builder();
        while (recordSetIterator.hasNext()) {
            RecordSet current = (RecordSet)recordSetIterator.next();
            if (RecordSet.Type.SOA.equals((Object)current.type()) || RecordSet.Type.NS.equals((Object)current.type())) continue;
            changeBuilder.delete(current);
        }
        changeRequest = changeBuilder.build();
        if (!changeRequest.deletions().isEmpty()) {
            ChangeRequest pendingRequest = dns.applyChangeRequest(zoneName, changeRequest, new Dns.ChangeRequestOption[0]);
            while (!pendingRequest.isDone()) {
                System.out.println("Waiting for change to complete. Going to sleep for 500ms...");
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    System.err.println("The thread was interrupted while waiting for change request to be processed.");
                }
            }
        }
        if (result = dns.delete(zoneName)) {
            System.out.println("Zone was deleted.");
        } else {
            System.out.println("Zone was not deleted because it does not exist.");
        }
    }
}

