/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.examples.logging.snippets;

import com.google.cloud.MonitoredResource;
import com.google.cloud.Page;
import com.google.cloud.logging.LogEntry;
import com.google.cloud.logging.Logging;
import com.google.cloud.logging.LoggingOptions;
import com.google.cloud.logging.Payload;
import java.util.Collections;
import java.util.Iterator;

public class WriteAndListLogEntries {
    public static void main(String ... args) throws Exception {
        LoggingOptions options = LoggingOptions.defaultInstance();
        try (Logging logging = (Logging)options.service();){
            LogEntry firstEntry = LogEntry.builder((Payload)Payload.StringPayload.of((String)"message")).logName("test-log").resource(MonitoredResource.builder((String)"global").addLabel("project_id", options.projectId()).build()).build();
            logging.write(Collections.singleton(firstEntry), new Logging.WriteOption[0]);
            Page entries = logging.listLogEntries(new Logging.EntryListOption[]{Logging.EntryListOption.filter((String)("logName=projects/" + options.projectId() + "/logs/test-log"))});
            Iterator entryIterator = entries.iterateAll();
            while (entryIterator.hasNext()) {
                System.out.println(entryIterator.next());
            }
        }
    }
}

