/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.examples.nio;

import com.google.common.base.Stopwatch;
import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.util.concurrent.TimeUnit;

public class CountBytes {
    public static void main(String[] args) throws IOException {
        if (args.length == 0 || args[0].equals("--help")) {
            CountBytes.help();
            return;
        }
        for (String a : args) {
            CountBytes.countFile(a);
        }
    }

    private static void countFile(String fname) {
        int bufSize = 0x3200000;
        try {
            Path path = Paths.get(new URI(fname));
            long size = Files.size(path);
            System.out.println(fname + ": " + size + " bytes.");
            ByteBuffer buf = ByteBuffer.allocate(0x3200000);
            System.out.println("Reading the whole file...");
            Stopwatch sw = Stopwatch.createStarted();
            try (SeekableByteChannel chan = Files.newByteChannel(path, new OpenOption[0]);){
                long total = 0L;
                int readCalls = 0;
                MessageDigest md = MessageDigest.getInstance("MD5");
                while (chan.read(buf) > 0) {
                    ++readCalls;
                    md.update(buf.array(), 0, buf.position());
                    total += (long)buf.position();
                    buf.flip();
                }
                long elapsed = sw.elapsed(TimeUnit.SECONDS);
                System.out.println("Read all " + total + " bytes in " + elapsed + "s. " + "(" + ++readCalls + " calls to chan.read)");
                String hex = String.valueOf(BaseEncoding.base16().encode(md.digest()));
                System.out.println("The MD5 is: 0x" + hex);
                if (total != size) {
                    System.out.println("Wait, this doesn't match! We saw " + total + " bytes, " + "yet the file size is listed at " + size + " bytes.");
                }
            }
        }
        catch (Exception ex) {
            System.out.println(fname + ": " + ex.toString());
        }
    }

    private static void help() {
        String[] help;
        for (String s : help = new String[]{"The argument is a <path>", "and we show the length of that file."}) {
            System.out.println(s);
        }
    }
}

