/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.examples.pubsub;

import com.google.cloud.pubsub.Message;
import com.google.cloud.pubsub.PubSub;
import com.google.cloud.pubsub.PubSubOptions;
import com.google.cloud.pubsub.PushConfig;
import com.google.cloud.pubsub.ReceivedMessage;
import com.google.cloud.pubsub.SubscriptionInfo;
import com.google.cloud.pubsub.TopicInfo;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class PubSubExample {
    private static final Map<String, PubSubAction> CREATE_ACTIONS = new HashMap<String, PubSubAction>();
    private static final Map<String, PubSubAction> INFO_ACTIONS = new HashMap<String, PubSubAction>();
    private static final Map<String, PubSubAction> LIST_ACTIONS = new HashMap<String, PubSubAction>();
    private static final Map<String, PubSubAction> DELETE_ACTIONS = new HashMap<String, PubSubAction>();
    private static final Map<String, PubSubAction> PULL_ACTIONS = new HashMap<String, PubSubAction>();
    private static final Map<String, PubSubAction> ACTIONS = new HashMap<String, PubSubAction>();

    private static void printUsage() {
        StringBuilder actionAndParams = new StringBuilder();
        for (Map.Entry<String, PubSubAction> entry : ACTIONS.entrySet()) {
            actionAndParams.append("\n\t").append(entry.getKey());
            String param = entry.getValue().params();
            if (param == null || param.isEmpty()) continue;
            actionAndParams.append(' ').append(param.replace("\n", "\n\t\t"));
        }
        System.out.printf("Usage: %s [<project_id>] operation [entity] <args>*%s%n", PubSubExample.class.getSimpleName(), actionAndParams);
    }

    /*
     * Loose catch block
     */
    public static void main(String ... args) throws Exception {
        block30: {
            PubSubAction action;
            String actionName;
            if (args.length < 1) {
                System.out.println("Missing required project id and action");
                PubSubExample.printUsage();
                return;
            }
            PubSubOptions.Builder optionsBuilder = PubSubOptions.builder();
            if (args.length >= 2 && !ACTIONS.containsKey(args[0])) {
                actionName = args[1];
                optionsBuilder.projectId(args[0]);
                action = ACTIONS.get(args[1]);
                args = Arrays.copyOfRange(args, 2, args.length);
            } else {
                actionName = args[0];
                action = ACTIONS.get(args[0]);
                args = Arrays.copyOfRange(args, 1, args.length);
            }
            if (action == null) {
                System.out.println("Unrecognized action.");
                PubSubExample.printUsage();
                return;
            }
            Throwable throwable = null;
            try (PubSub pubsub = (PubSub)optionsBuilder.build().service();){
                Object arg;
                try {
                    arg = action.parse(args);
                }
                catch (IllegalArgumentException ex) {
                    System.out.printf("Invalid input for action '%s'. %s%n", actionName, ex.getMessage());
                    System.out.printf("Expected: %s%n", action.params());
                    if (pubsub != null) {
                        if (throwable != null) {
                            try {
                                pubsub.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            pubsub.close();
                        }
                    }
                    return;
                }
                catch (Exception ex) {
                    block28: {
                        block29: {
                            System.out.println("Failed to parse arguments.");
                            ex.printStackTrace();
                            if (pubsub == null) break block28;
                            if (throwable == null) break block29;
                            try {
                                pubsub.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            break block28;
                        }
                        pubsub.close();
                    }
                    return;
                }
                action.run(pubsub, arg);
                break block30;
                {
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throw throwable3;
                    }
                }
            }
        }
    }

    static {
        CREATE_ACTIONS.put("topic", new CreateTopicAction());
        CREATE_ACTIONS.put("subscription", new CreateSubscriptionAction());
        INFO_ACTIONS.put("topic", new TopicInfoAction());
        INFO_ACTIONS.put("subscription", new SubscriptionInfoAction());
        LIST_ACTIONS.put("topics", new ListTopicsAction());
        LIST_ACTIONS.put("subscriptions", new ListSubscriptionsAction());
        DELETE_ACTIONS.put("topic", new DeleteTopicAction());
        DELETE_ACTIONS.put("subscription", new DeleteSubscriptionAction());
        PULL_ACTIONS.put("async", new PullAsyncAction());
        PULL_ACTIONS.put("sync", new PullSyncAction());
        ACTIONS.put("create", new ParentAction(CREATE_ACTIONS));
        ACTIONS.put("info", new ParentAction(INFO_ACTIONS));
        ACTIONS.put("list", new ParentAction(LIST_ACTIONS));
        ACTIONS.put("delete", new ParentAction(DELETE_ACTIONS));
        ACTIONS.put("pull", new ParentAction(PULL_ACTIONS));
        ACTIONS.put("publish", new PublishMessagesAction());
        ACTIONS.put("replace-push-config", new ReplacePushConfigAction());
        ACTIONS.put("ack", new AckMessagesAction());
        ACTIONS.put("nack", new NackMessagesAction());
        ACTIONS.put("modify-ack-deadline", new ModifyAckDeadlineAction());
    }

    private static class PullSyncAction
    extends PubSubAction<Tuple<String, Integer>> {
        private PullSyncAction() {
        }

        @Override
        public void run(PubSub pubsub, Tuple<String, Integer> params) throws Exception {
            String subscription = params.x();
            Integer maxMessages = params.y();
            Iterator messageIterator = pubsub.pull(subscription, maxMessages.intValue());
            int messageCount = 0;
            while (messageIterator.hasNext()) {
                ReceivedMessage message = (ReceivedMessage)messageIterator.next();
                System.out.printf("Received message \"%s\"%n", message);
                message.ack();
                ++messageCount;
            }
            System.out.printf("Pulled %d messages from subscription %s%n", messageCount, subscription);
        }

        @Override
        Tuple<String, Integer> parse(String ... args) throws Exception {
            if (args.length == 2) {
                String subscription = args[0];
                int maxMessages = Integer.parseInt(args[1]);
                return Tuple.of(subscription, maxMessages);
            }
            String message = args.length > 2 ? "Too many arguments." : "Missing required subscription name";
            throw new IllegalArgumentException(message);
        }

        @Override
        public String params() {
            return "<subscription> <maxMessages>";
        }
    }

    private static class PullAsyncAction
    extends PubSubAction<Tuple<String, Long>> {
        private PullAsyncAction() {
        }

        @Override
        public void run(PubSub pubsub, Tuple<String, Long> params) throws Exception {
            String subscription = params.x();
            Long timeout = params.y();
            final AtomicInteger messageCount = new AtomicInteger();
            PubSub.MessageProcessor messageProcessor = new PubSub.MessageProcessor(){

                public void process(Message message) throws Exception {
                    System.out.printf("Received message \"%s\"%n", message);
                    messageCount.incrementAndGet();
                }
            };
            try (PubSub.MessageConsumer consumer = pubsub.pullAsync(subscription, messageProcessor, new PubSub.PullOption[0]);){
                Thread.sleep(timeout);
            }
            System.out.printf("Pulled %d messages from subscription %s%n", messageCount.get(), subscription);
        }

        @Override
        Tuple<String, Long> parse(String ... args) throws Exception {
            String message;
            if (args.length > 2) {
                message = "Too many arguments.";
            } else if (args.length < 1) {
                message = "Missing required subscription name";
            } else {
                String subscription = args[0];
                long timeout = 60000L;
                if (args.length == 2) {
                    timeout = Long.parseLong(args[1]);
                }
                return Tuple.of(subscription, timeout);
            }
            throw new IllegalArgumentException(message);
        }

        @Override
        public String params() {
            return "<subscription> <timeoutMillis>?";
        }
    }

    private static class ModifyAckDeadlineAction
    extends PubSubAction<Tuple<SubscriptionAndDeadline, List<String>>> {
        private ModifyAckDeadlineAction() {
        }

        @Override
        public void run(PubSub pubsub, Tuple<SubscriptionAndDeadline, List<String>> params) throws Exception {
            String subscription = params.x().subscription();
            int deadline = params.x().deadlineMillis();
            List<String> ackIds = params.y();
            pubsub.modifyAckDeadline(subscription, deadline, TimeUnit.MILLISECONDS, ackIds);
            System.out.printf("Ack deadline set to %d for %d messages in subscription %s%n", deadline, ackIds.size(), subscription);
        }

        @Override
        Tuple<SubscriptionAndDeadline, List<String>> parse(String ... args) throws Exception {
            if (args.length < 3) {
                throw new IllegalArgumentException("Missing required subscription, deadline and ack IDs");
            }
            String subscription = args[0];
            int deadline = Integer.parseInt(args[1]);
            return Tuple.of(new SubscriptionAndDeadline(subscription, deadline), Arrays.asList(Arrays.copyOfRange(args, 2, args.length)));
        }

        @Override
        public String params() {
            return "<subscription> <deadlineMillis> <ackId>+";
        }

        static class SubscriptionAndDeadline {
            private final String subscription;
            private final int deadlineMillis;

            private SubscriptionAndDeadline(String subscription, int deadlineMillis) {
                this.subscription = subscription;
                this.deadlineMillis = deadlineMillis;
            }

            String subscription() {
                return this.subscription;
            }

            int deadlineMillis() {
                return this.deadlineMillis;
            }
        }
    }

    private static class NackMessagesAction
    extends MessagesAction {
        private NackMessagesAction() {
        }

        @Override
        public void run(PubSub pubsub, Tuple<String, List<String>> params) {
            String subscription = params.x();
            List<String> ackIds = params.y();
            pubsub.nack(subscription, ackIds);
            System.out.printf("Nacked %d messages for subscription %s%n", ackIds.size(), subscription);
        }
    }

    private static class AckMessagesAction
    extends MessagesAction {
        private AckMessagesAction() {
        }

        @Override
        public void run(PubSub pubsub, Tuple<String, List<String>> params) {
            String subscription = params.x();
            List<String> ackIds = params.y();
            pubsub.ack(subscription, ackIds);
            System.out.printf("Acked %d messages for subscription %s%n", ackIds.size(), subscription);
        }
    }

    private static abstract class MessagesAction
    extends PubSubAction<Tuple<String, List<String>>> {
        private MessagesAction() {
        }

        @Override
        Tuple<String, List<String>> parse(String ... args) throws Exception {
            if (args.length < 2) {
                throw new IllegalArgumentException("Missing required subscription and ack IDs");
            }
            String subscription = args[0];
            return Tuple.of(subscription, Arrays.asList(Arrays.copyOfRange(args, 1, args.length)));
        }

        @Override
        public String params() {
            return "<subscription> <ackId>+";
        }
    }

    private static class ReplacePushConfigAction
    extends PubSubAction<Tuple<String, PushConfig>> {
        private ReplacePushConfigAction() {
        }

        @Override
        public void run(PubSub pubsub, Tuple<String, PushConfig> params) {
            String subscription = params.x();
            PushConfig pushConfig = params.y();
            pubsub.replacePushConfig(subscription, pushConfig);
            System.out.printf("Set push config %s for subscription %s%n", pushConfig, subscription);
        }

        @Override
        Tuple<String, PushConfig> parse(String ... args) throws Exception {
            String message;
            if (args.length > 2) {
                message = "Too many arguments.";
            } else if (args.length < 1) {
                message = "Missing required subscription name";
            } else {
                String subscription = args[0];
                PushConfig pushConfig = null;
                if (args.length == 2) {
                    pushConfig = PushConfig.of((String)args[1]);
                }
                return Tuple.of(subscription, pushConfig);
            }
            throw new IllegalArgumentException(message);
        }

        @Override
        public String params() {
            return "<subscription> <endpoint>?";
        }
    }

    private static class DeleteSubscriptionAction
    extends SubscriptionAction {
        private DeleteSubscriptionAction() {
        }

        @Override
        public void run(PubSub pubsub, String subscription) {
            pubsub.deleteSubscription(subscription);
            System.out.printf("Deleted subscription %s%n", subscription);
        }
    }

    private static class CreateSubscriptionAction
    extends PubSubAction<SubscriptionInfo> {
        private CreateSubscriptionAction() {
        }

        @Override
        public void run(PubSub pubsub, SubscriptionInfo subscription) {
            pubsub.create(subscription);
            System.out.printf("Created subscription %s%n", subscription.name());
        }

        @Override
        SubscriptionInfo parse(String ... args) throws Exception {
            String message;
            if (args.length > 3) {
                message = "Too many arguments.";
            } else if (args.length < 2) {
                message = "Missing required topic or subscription name";
            } else {
                SubscriptionInfo.Builder builder = SubscriptionInfo.builder((String)args[0], (String)args[1]);
                if (args.length == 3) {
                    builder.pushConfig(PushConfig.of((String)args[2]));
                }
                return builder.build();
            }
            throw new IllegalArgumentException(message);
        }

        @Override
        public String params() {
            return "<topic> <subscription> <endpoint>?";
        }
    }

    private static class SubscriptionInfoAction
    extends SubscriptionAction {
        private SubscriptionInfoAction() {
        }

        @Override
        public void run(PubSub pubsub, String subscription) {
            System.out.printf("Subscription info: %s%n", pubsub.getSubscription(subscription));
        }
    }

    private static abstract class SubscriptionAction
    extends PubSubAction<String> {
        private SubscriptionAction() {
        }

        @Override
        String parse(String ... args) throws Exception {
            if (args.length == 1) {
                return args[0];
            }
            String message = args.length > 1 ? "Too many arguments." : "Missing required subscription name.";
            throw new IllegalArgumentException(message);
        }

        @Override
        public String params() {
            return "<subscription>";
        }
    }

    private static class PublishMessagesAction
    extends PubSubAction<Tuple<String, List<Message>>> {
        private PublishMessagesAction() {
        }

        @Override
        public void run(PubSub pubsub, Tuple<String, List<Message>> params) {
            String topic = params.x();
            List<Message> messages = params.y();
            pubsub.publish(topic, messages);
            System.out.printf("Published %d messages to topic %s%n", messages.size(), topic);
        }

        @Override
        Tuple<String, List<Message>> parse(String ... args) throws Exception {
            if (args.length < 2) {
                throw new IllegalArgumentException("Missing required topic and messages");
            }
            String topic = args[0];
            ArrayList<Message> messages = new ArrayList<Message>();
            for (String payload : Arrays.copyOfRange(args, 1, args.length)) {
                messages.add(Message.of((String)payload));
            }
            return Tuple.of(topic, messages);
        }

        @Override
        public String params() {
            return "<topic> <message>+";
        }
    }

    private static class ListSubscriptionsAction
    extends PubSubAction<String> {
        private ListSubscriptionsAction() {
        }

        @Override
        public void run(PubSub pubsub, String topic) {
            if (topic == null) {
                Iterator subscriptionIterator = pubsub.listSubscriptions(new PubSub.ListOption[0]).iterateAll();
                while (subscriptionIterator.hasNext()) {
                    System.out.println(subscriptionIterator.next());
                }
            } else {
                Iterator subscriptionIdIterator = pubsub.listSubscriptions(topic, new PubSub.ListOption[0]).iterateAll();
                while (subscriptionIdIterator.hasNext()) {
                    System.out.println(subscriptionIdIterator.next());
                }
            }
        }

        @Override
        String parse(String ... args) throws Exception {
            if (args.length == 1) {
                return args[0];
            }
            if (args.length == 0) {
                return null;
            }
            throw new IllegalArgumentException("Too many arguments.");
        }

        @Override
        public String params() {
            return "<topic>?";
        }
    }

    private static class DeleteTopicAction
    extends TopicAction {
        private DeleteTopicAction() {
        }

        @Override
        public void run(PubSub pubsub, String topic) {
            pubsub.deleteTopic(topic);
            System.out.printf("Deleted topic %s%n", topic);
        }
    }

    private static class CreateTopicAction
    extends TopicAction {
        private CreateTopicAction() {
        }

        @Override
        public void run(PubSub pubsub, String topic) {
            pubsub.create(TopicInfo.of((String)topic));
            System.out.printf("Created topic %s%n", topic);
        }
    }

    private static class TopicInfoAction
    extends TopicAction {
        private TopicInfoAction() {
        }

        @Override
        public void run(PubSub pubsub, String topic) {
            System.out.printf("Topic info: %s%n", pubsub.getTopic(topic));
        }
    }

    private static abstract class TopicAction
    extends PubSubAction<String> {
        private TopicAction() {
        }

        @Override
        String parse(String ... args) throws Exception {
            if (args.length == 1) {
                return args[0];
            }
            String message = args.length > 1 ? "Too many arguments." : "Missing required topic name.";
            throw new IllegalArgumentException(message);
        }

        @Override
        public String params() {
            return "<topic>";
        }
    }

    private static class ListTopicsAction
    extends NoArgsAction {
        private ListTopicsAction() {
        }

        @Override
        public void run(PubSub pubsub, Void arg) {
            Iterator topicIterator = pubsub.listTopics(new PubSub.ListOption[0]).iterateAll();
            while (topicIterator.hasNext()) {
                System.out.println(topicIterator.next());
            }
        }
    }

    private static abstract class NoArgsAction
    extends PubSubAction<Void> {
        private NoArgsAction() {
        }

        @Override
        Void parse(String ... args) throws Exception {
            if (args.length == 0) {
                return null;
            }
            throw new IllegalArgumentException("This action takes no arguments.");
        }
    }

    private static class ParentAction
    extends PubSubAction<Tuple<PubSubAction, Object>> {
        private final Map<String, PubSubAction> subActions;

        ParentAction(Map<String, PubSubAction> subActions) {
            this.subActions = ImmutableMap.copyOf(subActions);
        }

        @Override
        void run(PubSub pubsub, Tuple<PubSubAction, Object> subaction) throws Exception {
            subaction.x().run(pubsub, subaction.y());
        }

        @Override
        Tuple<PubSubAction, Object> parse(String ... args) throws Exception {
            if (args.length >= 1) {
                PubSubAction action = this.subActions.get(args[0]);
                if (action != null) {
                    Object actionArguments = action.parse(Arrays.copyOfRange(args, 1, args.length));
                    return Tuple.of(action, actionArguments);
                }
                throw new IllegalArgumentException("Unrecognized entity '" + args[0] + "'.");
            }
            throw new IllegalArgumentException("Missing required entity.");
        }

        @Override
        public String params() {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<String, PubSubAction> entry : this.subActions.entrySet()) {
                builder.append('\n').append(entry.getKey());
                String param = entry.getValue().params();
                if (param == null || param.isEmpty()) continue;
                builder.append(' ').append(param);
            }
            return builder.toString();
        }
    }

    private static class Tuple<X, Y> {
        private final X x;
        private final Y y;

        private Tuple(X x, Y y) {
            this.x = x;
            this.y = y;
        }

        public static <X, Y> Tuple<X, Y> of(X x, Y y) {
            return new Tuple<X, Y>(x, y);
        }

        X x() {
            return this.x;
        }

        Y y() {
            return this.y;
        }
    }

    private static abstract class PubSubAction<T> {
        private PubSubAction() {
        }

        abstract void run(PubSub var1, T var2) throws Exception;

        abstract T parse(String ... var1) throws Exception;

        protected String params() {
            return "";
        }
    }
}

