/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.examples.pubsub.snippets;

import com.google.cloud.pubsub.Message;
import com.google.cloud.pubsub.PubSub;
import com.google.cloud.pubsub.PubSubOptions;
import com.google.cloud.pubsub.Subscription;
import com.google.cloud.pubsub.SubscriptionInfo;

public class CreateSubscriptionAndPullMessages {
    public static void main(String ... args) throws Exception {
        try (PubSub pubsub = (PubSub)PubSubOptions.defaultInstance().service();){
            Subscription subscription = pubsub.create(SubscriptionInfo.of((String)"test-topic", (String)"test-subscription"));
            PubSub.MessageProcessor callback = new PubSub.MessageProcessor(){

                public void process(Message message) throws Exception {
                    System.out.printf("Received message \"%s\"%n", message.payloadAsString());
                }
            };
            try (PubSub.MessageConsumer consumer = subscription.pullAsync(callback, new PubSub.PullOption[0]);){
                Thread.sleep(60000L);
            }
        }
    }
}

