/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.examples.storage.snippets;

import com.google.cloud.examples.storage.snippets.BucketSnippets;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.BucketInfo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.testing.RemoteStorageHelper;
import com.google.common.collect.ImmutableSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ITBucketSnippets {
    private static final Logger log = Logger.getLogger(ITBucketSnippets.class.getName());
    private static final String BUCKET = RemoteStorageHelper.generateBucketName();
    private static final String BLOB1 = "blob1";
    private static final String BLOB2 = "blob2";
    private static final String BLOB3 = "blob3";
    private static final String BLOB4 = "blob4";
    private static final Set<String> BLOBS = ImmutableSet.of((Object)"blob1", (Object)"blob2", (Object)"blob3", (Object)"blob4");
    private static Storage storage;
    private static BucketSnippets bucketSnippets;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @BeforeClass
    public static void beforeClass() {
        RemoteStorageHelper helper = RemoteStorageHelper.create();
        storage = (Storage)helper.options().service();
        bucketSnippets = new BucketSnippets(storage.create(BucketInfo.of((String)BUCKET), new Storage.BucketTargetOption[0]));
    }

    @AfterClass
    public static void afterClass() throws ExecutionException, InterruptedException {
        boolean wasDeleted;
        if (storage != null && !(wasDeleted = RemoteStorageHelper.forceDelete((Storage)storage, (String)BUCKET, (long)5L, (TimeUnit)TimeUnit.SECONDS).booleanValue()) && log.isLoggable(Level.WARNING)) {
            log.log(Level.WARNING, "Deletion of bucket {0} timed out, bucket is not empty", BUCKET);
        }
    }

    @Test
    public void testBucket() {
        Assert.assertTrue((boolean)bucketSnippets.exists());
        Bucket bucket = bucketSnippets.reload();
        Assert.assertNotNull((Object)bucket);
        Bucket updatedBucket = bucketSnippets.update();
        Assert.assertTrue((boolean)updatedBucket.versioningEnabled());
        Blob blob1 = bucketSnippets.createBlobFromByteArray(BLOB1);
        Assert.assertNotNull((Object)blob1);
        Blob blob2 = bucketSnippets.createBlobFromByteArrayWithContentType(BLOB2);
        Assert.assertNotNull((Object)blob2);
        Blob blob3 = bucketSnippets.createBlobFromInputStream(BLOB3);
        Assert.assertNotNull((Object)blob3);
        Blob blob4 = bucketSnippets.createBlobFromInputStreamWithContentType(BLOB4);
        Assert.assertNotNull((Object)blob4);
        Iterator blobIterator = bucketSnippets.listBlobs();
        while (blobIterator.hasNext()) {
            Assert.assertTrue((boolean)BLOBS.contains(((Blob)blobIterator.next()).name()));
        }
        blob1 = bucketSnippets.getBlob(BLOB1, blob1.generation().longValue());
        Assert.assertEquals((Object)BLOB1, (Object)blob1.name());
        List blobs = bucketSnippets.getBlobFromStrings(BLOB2, BLOB3);
        Assert.assertEquals((Object)BLOB2, (Object)((Blob)blobs.get(0)).name());
        Assert.assertEquals((Object)BLOB3, (Object)((Blob)blobs.get(1)).name());
        blobs = bucketSnippets.getBlobFromStringIterable(BLOB3, BLOB4);
        Assert.assertEquals((Object)BLOB3, (Object)((Blob)blobs.get(0)).name());
        Assert.assertEquals((Object)BLOB4, (Object)((Blob)blobs.get(1)).name());
        this.thrown.expect(StorageException.class);
        Assert.assertTrue((boolean)bucketSnippets.delete());
    }
}

