/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.examples.storage.snippets;

import com.google.cloud.examples.storage.snippets.StorageSnippets;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.testing.RemoteStorageHelper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ITStorageSnippets {
    private static final Logger log = Logger.getLogger(ITStorageSnippets.class.getName());
    private static final String BUCKET = RemoteStorageHelper.generateBucketName();
    private static Storage storage;
    private static StorageSnippets storageSnippets;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @BeforeClass
    public static void beforeClass() {
        RemoteStorageHelper helper = RemoteStorageHelper.create();
        storage = (Storage)helper.options().service();
        storageSnippets = new StorageSnippets(storage);
        storageSnippets.createBucket(BUCKET);
    }

    @AfterClass
    public static void afterClass() throws ExecutionException, InterruptedException {
        boolean wasDeleted;
        if (storage != null && !(wasDeleted = RemoteStorageHelper.forceDelete((Storage)storage, (String)BUCKET, (long)5L, (TimeUnit)TimeUnit.SECONDS).booleanValue()) && log.isLoggable(Level.WARNING)) {
            log.log(Level.WARNING, "Deletion of bucket {0} timed out, bucket is not empty", BUCKET);
        }
    }

    @Test
    public void testBlob() {
        String blobName = "directory/test-blob";
        Blob blob = storageSnippets.createBlob(BUCKET, blobName);
        Assert.assertNotNull((Object)blob);
        blob = storageSnippets.getBlobFromId(BUCKET, blobName);
        Assert.assertNotNull((Object)blob);
        blob = storageSnippets.updateBlob(BUCKET, blobName);
        Assert.assertNotNull((Object)blob);
        blob = storageSnippets.updateBlobWithMetageneration(BUCKET, blobName);
        Assert.assertNotNull((Object)blob);
        blob = storageSnippets.copyBlob(BUCKET, blobName, "directory/copy-blob");
        Assert.assertNotNull((Object)blob);
        Iterator blobs = storageSnippets.listBlobsWithDirectoryAndPrefix(BUCKET, "directory");
        while (blobs.hasNext()) {
            Assert.assertTrue((boolean)((Blob)blobs.next()).name().startsWith("directory"));
        }
        blob.delete(new Blob.BlobSourceOption[0]);
        try {
            storageSnippets.getBlobFromStringsWithMetageneration(BUCKET, blobName, -1L);
            Assert.fail((String)"Expected StorageException to be thrown");
        }
        catch (StorageException ex) {
            // empty catch block
        }
        Assert.assertTrue((boolean)storageSnippets.deleteBlob(BUCKET, blobName));
    }

    @Test
    public void testCreateCopyAndGetBlob() {
        String blobName = "test-create-copy-get-blob";
        Blob blob = storageSnippets.createBlobFromByteArray(BUCKET, blobName);
        Assert.assertNotNull((Object)blob);
        Blob copiedBlob = storageSnippets.copyBlobInChunks(BUCKET, blobName, "copy-blob");
        Assert.assertNotNull((Object)copiedBlob);
        try {
            storageSnippets.getBlobFromIdWithMetageneration(BUCKET, blobName, -1L);
            Assert.fail((String)"Expected StorageException to be thrown");
        }
        catch (StorageException ex) {
            // empty catch block
        }
        Assert.assertTrue((boolean)storageSnippets.deleteBlobFromIdWithGeneration(BUCKET, blobName, blob.generation().longValue()));
        copiedBlob.delete(new Blob.BlobSourceOption[0]);
    }

    @Test
    public void testCreateBlobFromInputStream() {
        Blob blob = storageSnippets.createBlobFromInputStream(BUCKET, "test-create-blob-from-input-stream");
        Assert.assertNotNull((Object)blob);
        Assert.assertTrue((boolean)storageSnippets.deleteBlobFromIdWithGeneration(BUCKET, "test-create-blob-from-input-stream", blob.generation().longValue()));
    }

    @Test
    public void testGetBucketWithMetageneration() {
        this.thrown.expect(StorageException.class);
        storageSnippets.getBucketWithMetageneration(BUCKET, -1L);
    }

    @Test
    public void testListBucketsWithSizeAndPrefix() {
        Iterator buckets = storageSnippets.listBucketsWithSizeAndPrefix(BUCKET);
        while (buckets.hasNext()) {
            Assert.assertTrue((boolean)((Bucket)buckets.next()).name().startsWith(BUCKET));
        }
    }

    @Test
    public void testUpdateBucket() {
        Assert.assertNotNull((Object)storageSnippets.updateBucket(BUCKET));
    }

    @Test
    public void testDeleteBucketWithMetageneration() {
        this.thrown.expect(StorageException.class);
        storageSnippets.deleteBucketWithMetageneration(BUCKET, -1L);
    }

    @Test
    public void testComposeBlobs() {
        String blobName = "my_blob_name";
        String sourceBlobName1 = "source_blob_1";
        String sourceBlobName2 = "source_blob_2";
        BlobInfo blobInfo1 = BlobInfo.builder((String)BUCKET, (String)sourceBlobName1).build();
        BlobInfo blobInfo2 = BlobInfo.builder((String)BUCKET, (String)sourceBlobName2).build();
        storage.create(blobInfo1, new Storage.BlobTargetOption[0]);
        storage.create(blobInfo2, new Storage.BlobTargetOption[0]);
        Assert.assertNotNull((Object)storageSnippets.composeBlobs(BUCKET, blobName, sourceBlobName1, sourceBlobName2));
    }

    @Test
    public void testReadWriteAndSignUrl() throws IOException {
        String blobName = "text-read-write-sign-url";
        byte[] content = "Hello, World!".getBytes(StandardCharsets.UTF_8);
        Blob blob = storage.create(BlobInfo.builder((String)BUCKET, (String)blobName).build(), content, new Storage.BlobTargetOption[0]);
        Assert.assertArrayEquals((byte[])content, (byte[])storageSnippets.readBlobFromId(BUCKET, blobName, blob.generation().longValue()));
        Assert.assertArrayEquals((byte[])content, (byte[])storageSnippets.readBlobFromStringsWithGeneration(BUCKET, blobName, blob.generation().longValue()));
        storageSnippets.readerFromId(BUCKET, blobName);
        storageSnippets.readerFromStrings(BUCKET, blobName);
        storageSnippets.writer(BUCKET, blobName);
        URL signedUrl = storageSnippets.signUrl(BUCKET, blobName);
        URLConnection connection = signedUrl.openConnection();
        byte[] readBytes = new byte[content.length];
        try (InputStream responseStream = connection.getInputStream();){
            Assert.assertEquals((long)content.length, (long)responseStream.read(readBytes));
            Assert.assertArrayEquals((byte[])content, (byte[])readBytes);
        }
        signedUrl = storageSnippets.signUrlWithSigner(BUCKET, blobName, System.getenv("GOOGLE_APPLICATION_CREDENTIALS"));
        connection = signedUrl.openConnection();
        responseStream = connection.getInputStream();
        var8_8 = null;
        try {
            Assert.assertEquals((long)content.length, (long)responseStream.read(readBytes));
            Assert.assertArrayEquals((byte[])content, (byte[])readBytes);
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
        finally {
            if (responseStream != null) {
                if (var8_8 != null) {
                    try {
                        responseStream.close();
                    }
                    catch (Throwable x2) {
                        var8_8.addSuppressed(x2);
                    }
                } else {
                    responseStream.close();
                }
            }
        }
        blob.delete(new Blob.BlobSourceOption[0]);
    }

    @Test
    public void testBatch() throws IOException {
        String blobName1 = "test-batch1";
        String blobName2 = "test-batch2";
        storage.create(BlobInfo.builder((String)BUCKET, (String)blobName1).build(), new Storage.BlobTargetOption[0]);
        storage.create(BlobInfo.builder((String)BUCKET, (String)blobName2).build(), new Storage.BlobTargetOption[0]);
        List blobs = storageSnippets.batchGet(BUCKET, blobName1, blobName2);
        Assert.assertEquals((Object)blobName1, (Object)((Blob)blobs.get(0)).name());
        Assert.assertEquals((Object)blobName2, (Object)((Blob)blobs.get(1)).name());
        blobs = storageSnippets.batchUpdate(BUCKET, blobName1, blobName2);
        Assert.assertEquals((Object)blobName1, (Object)((Blob)blobs.get(0)).name());
        Assert.assertEquals((Object)blobName2, (Object)((Blob)blobs.get(1)).name());
        Assert.assertEquals((Object)"text/plain", (Object)((Blob)blobs.get(0)).contentType());
        Assert.assertEquals((Object)"text/plain", (Object)((Blob)blobs.get(1)).contentType());
        Assert.assertNotNull((Object)storageSnippets.batch(BUCKET, blobName1, blobName2));
        List deleted = storageSnippets.batchDelete(BUCKET, blobName1, blobName2);
        Assert.assertFalse((boolean)((Boolean)deleted.get(0)));
        Assert.assertTrue((boolean)((Boolean)deleted.get(1)));
    }

    @Test
    public void testBatchIterable() throws IOException {
        String blobName1 = "test-batch-iterable1";
        String blobName2 = "test-batch-iterable2";
        storage.create(BlobInfo.builder((String)BUCKET, (String)blobName1).build(), new Storage.BlobTargetOption[0]);
        storage.create(BlobInfo.builder((String)BUCKET, (String)blobName2).build(), new Storage.BlobTargetOption[0]);
        List blobs = storageSnippets.batchGetIterable(BUCKET, blobName1, blobName2);
        Assert.assertEquals((Object)blobName1, (Object)((Blob)blobs.get(0)).name());
        Assert.assertEquals((Object)blobName2, (Object)((Blob)blobs.get(1)).name());
        blobs = storageSnippets.batchUpdateIterable(BUCKET, blobName1, blobName2);
        Assert.assertEquals((Object)blobName1, (Object)((Blob)blobs.get(0)).name());
        Assert.assertEquals((Object)blobName2, (Object)((Blob)blobs.get(1)).name());
        Assert.assertEquals((Object)"text/plain", (Object)((Blob)blobs.get(0)).contentType());
        Assert.assertEquals((Object)"text/plain", (Object)((Blob)blobs.get(1)).contentType());
        Assert.assertNotNull((Object)storageSnippets.batch(BUCKET, blobName1, blobName2));
        List deleted = storageSnippets.batchDeleteIterable(BUCKET, blobName1, blobName2);
        Assert.assertFalse((boolean)((Boolean)deleted.get(0)));
        Assert.assertTrue((boolean)((Boolean)deleted.get(1)));
    }
}

