/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.examples.logging;

import com.google.cloud.MonitoredResource;
import com.google.cloud.logging.LogEntry;
import com.google.cloud.logging.Logging;
import com.google.cloud.logging.LoggingOptions;
import com.google.cloud.logging.MetricInfo;
import com.google.cloud.logging.Payload;
import com.google.cloud.logging.Severity;
import com.google.cloud.logging.SinkInfo;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class LoggingExample {
    private static final Map<String, LoggingAction> CREATE_ACTIONS = new HashMap<String, LoggingAction>();
    private static final Map<String, LoggingAction> INFO_ACTIONS = new HashMap<String, LoggingAction>();
    private static final Map<String, LoggingAction> LIST_ACTIONS = new HashMap<String, LoggingAction>();
    private static final Map<String, LoggingAction> DELETE_ACTIONS = new HashMap<String, LoggingAction>();
    private static final Map<String, LoggingAction> ACTIONS = new HashMap<String, LoggingAction>();

    private static void printUsage() {
        StringBuilder actionAndParams = new StringBuilder();
        for (Map.Entry<String, LoggingAction> entry : ACTIONS.entrySet()) {
            actionAndParams.append("\n\t").append(entry.getKey());
            String param = entry.getValue().params();
            if (param == null || param.isEmpty()) continue;
            actionAndParams.append(' ').append(param.replace("\n", "\n\t\t"));
        }
        System.out.printf("Usage: %s [<project_id>] operation [entity] <args>*%s%n", LoggingExample.class.getSimpleName(), actionAndParams);
    }

    /*
     * Loose catch block
     */
    public static void main(String ... args) throws Exception {
        block30: {
            LoggingAction action;
            String actionName;
            if (args.length < 1) {
                System.out.println("Missing required project id and action");
                LoggingExample.printUsage();
                return;
            }
            LoggingOptions.Builder optionsBuilder = LoggingOptions.builder();
            if (args.length >= 2 && !ACTIONS.containsKey(args[0])) {
                actionName = args[1];
                optionsBuilder.projectId(args[0]);
                action = ACTIONS.get(args[1]);
                args = Arrays.copyOfRange(args, 2, args.length);
            } else {
                actionName = args[0];
                action = ACTIONS.get(args[0]);
                args = Arrays.copyOfRange(args, 1, args.length);
            }
            if (action == null) {
                System.out.println("Unrecognized action.");
                LoggingExample.printUsage();
                return;
            }
            Throwable throwable = null;
            try (Logging logging = (Logging)optionsBuilder.build().service();){
                Object arg;
                try {
                    arg = action.parse(args);
                }
                catch (IllegalArgumentException ex) {
                    System.out.printf("Invalid input for action '%s'. %s%n", actionName, ex.getMessage());
                    System.out.printf("Expected: %s%n", action.params());
                    if (logging != null) {
                        if (throwable != null) {
                            try {
                                logging.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            logging.close();
                        }
                    }
                    return;
                }
                catch (Exception ex) {
                    block28: {
                        block29: {
                            System.out.println("Failed to parse arguments.");
                            ex.printStackTrace();
                            if (logging == null) break block28;
                            if (throwable == null) break block29;
                            try {
                                logging.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            break block28;
                        }
                        logging.close();
                    }
                    return;
                }
                action.run(logging, arg);
                break block30;
                {
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throw throwable3;
                    }
                }
            }
        }
    }

    static {
        CREATE_ACTIONS.put("metric", new CreateMetricAction());
        CREATE_ACTIONS.put("sink", new CreateSinkAction());
        INFO_ACTIONS.put("metric", new MetricInfoAction());
        INFO_ACTIONS.put("sink", new SinkInfoAction());
        LIST_ACTIONS.put("metrics", new ListMetricsAction());
        LIST_ACTIONS.put("sinks", new ListSinksAction());
        LIST_ACTIONS.put("entries", new ListEntriesAction());
        LIST_ACTIONS.put("resource-descriptors", new ListResourceDescriptorsAction());
        DELETE_ACTIONS.put("metric", new DeleteMetricAction());
        DELETE_ACTIONS.put("sink", new DeleteSinkAction());
        DELETE_ACTIONS.put("log", new DeleteLogAction());
        ACTIONS.put("create", new ParentAction(CREATE_ACTIONS));
        ACTIONS.put("info", new ParentAction(INFO_ACTIONS));
        ACTIONS.put("list", new ParentAction(LIST_ACTIONS));
        ACTIONS.put("delete", new ParentAction(DELETE_ACTIONS));
        ACTIONS.put("write", new WriteEntryAction());
    }

    private static class DeleteLogAction
    extends LoggingAction<String> {
        private DeleteLogAction() {
        }

        @Override
        public void run(Logging logging, String logName) {
            logging.deleteLog(logName);
            System.out.printf("Deleted log %s%n", logName);
        }

        @Override
        String parse(String ... args) throws Exception {
            if (args.length == 1) {
                return args[0];
            }
            String message = args.length > 1 ? "Too many arguments." : "Missing required log name.";
            throw new IllegalArgumentException(message);
        }

        @Override
        public String params() {
            return "<logName>";
        }
    }

    private static class ListEntriesAction
    extends LoggingAction<String> {
        private ListEntriesAction() {
        }

        @Override
        public void run(Logging logging, String filter) {
            Iterator entryIterator = filter == null ? logging.listLogEntries(new Logging.EntryListOption[0]).iterateAll() : logging.listLogEntries(new Logging.EntryListOption[]{Logging.EntryListOption.filter((String)filter)}).iterateAll();
            while (entryIterator.hasNext()) {
                System.out.println(entryIterator.next());
            }
        }

        @Override
        String parse(String ... args) throws Exception {
            if (args.length == 0) {
                return null;
            }
            if (args.length == 1) {
                return args[0];
            }
            throw new IllegalArgumentException("Too many arguments.");
        }

        @Override
        public String params() {
            return "<filter>?";
        }
    }

    private static class WriteEntryAction
    extends LoggingAction<LogEntry> {
        private WriteEntryAction() {
        }

        @Override
        public void run(Logging logging, LogEntry entry) {
            MonitoredResource resource = MonitoredResource.builder((String)"global").addLabel("project_id", ((LoggingOptions)logging.options()).projectId()).build();
            LogEntry entryWithResource = entry.toBuilder().resource(resource).build();
            logging.write(Collections.singleton(entryWithResource), new Logging.WriteOption[0]);
            System.out.printf("Written entry %s%n", entryWithResource);
        }

        @Override
        LogEntry parse(String ... args) throws Exception {
            if (args.length >= 3) {
                if ((args.length & 1) != 1) {
                    throw new IllegalArgumentException("Labels must be a list of key-value pairs.");
                }
                String logName = args[0];
                Severity severity = Severity.valueOf((String)args[1].toUpperCase());
                String message = args[2];
                HashMap labels = Maps.newHashMapWithExpectedSize((int)((args.length - 3) / 2));
                for (int i = 3; i < args.length; i += 2) {
                    labels.put(args[i], args[i + 1]);
                }
                return LogEntry.builder((Payload)Payload.StringPayload.of((String)message)).logName(logName).severity(severity).labels((Map)labels).build();
            }
            throw new IllegalArgumentException("Missing required arguments.");
        }

        @Override
        public String params() {
            return "<logName> <severity> <message> (<key> <value>)*";
        }
    }

    private static class ListResourceDescriptorsAction
    extends NoArgsAction {
        private ListResourceDescriptorsAction() {
        }

        @Override
        public void run(Logging logging, Void arg) {
            Iterator monitoredResourceIterator = logging.listMonitoredResourceDescriptors(new Logging.ListOption[0]).iterateAll();
            while (monitoredResourceIterator.hasNext()) {
                System.out.println(monitoredResourceIterator.next());
            }
        }
    }

    private static class CreateSinkAction
    extends LoggingAction<SinkInfo> {
        private CreateSinkAction() {
        }

        @Override
        public void run(Logging logging, SinkInfo sink) {
            System.out.printf("Created sink %s%n", logging.create(sink));
        }

        @Override
        SinkInfo parse(String ... args) throws Exception {
            if (args.length >= 3) {
                SinkInfo.Destination.BucketDestination destination;
                if (args.length > 4) {
                    throw new IllegalArgumentException("Too many arguments.");
                }
                String name = args[0];
                switch (args[1]) {
                    case "bucket": {
                        destination = SinkInfo.Destination.BucketDestination.of((String)args[2]);
                        break;
                    }
                    case "dataset": {
                        destination = SinkInfo.Destination.DatasetDestination.of((String)args[2]);
                        break;
                    }
                    case "topic": {
                        destination = SinkInfo.Destination.TopicDestination.of((String)args[2]);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Second argument must be bucket|dataset|topic.");
                    }
                }
                SinkInfo.Builder builder = SinkInfo.builder((String)name, (SinkInfo.Destination)destination);
                if (args.length == 4) {
                    builder.filter(args[3]);
                }
                return builder.build();
            }
            throw new IllegalArgumentException("Missing required sink name, destination or filter.");
        }

        @Override
        public String params() {
            return "<sink> bucket|dataset|topic <destination> <filter>?";
        }
    }

    private static class DeleteSinkAction
    extends SinkAction {
        private DeleteSinkAction() {
        }

        @Override
        public void run(Logging logging, String sink) {
            logging.deleteSink(sink);
            System.out.printf("Deleted sink %s%n", sink);
        }
    }

    private static class SinkInfoAction
    extends SinkAction {
        private SinkInfoAction() {
        }

        @Override
        public void run(Logging logging, String sink) {
            System.out.printf("Sink info: %s%n", logging.getSink(sink));
        }
    }

    private static abstract class SinkAction
    extends LoggingAction<String> {
        private SinkAction() {
        }

        @Override
        String parse(String ... args) throws Exception {
            if (args.length == 1) {
                return args[0];
            }
            String message = args.length > 1 ? "Too many arguments." : "Missing required sink name.";
            throw new IllegalArgumentException(message);
        }

        @Override
        public String params() {
            return "<sink>";
        }
    }

    private static class ListSinksAction
    extends NoArgsAction {
        private ListSinksAction() {
        }

        @Override
        public void run(Logging logging, Void arg) {
            Iterator sinkIterator = logging.listSinks(new Logging.ListOption[0]).iterateAll();
            while (sinkIterator.hasNext()) {
                System.out.println(sinkIterator.next());
            }
        }
    }

    private static class CreateMetricAction
    extends LoggingAction<MetricInfo> {
        private CreateMetricAction() {
        }

        @Override
        public void run(Logging logging, MetricInfo metric) {
            System.out.printf("Created metric %s%n", logging.create(metric));
        }

        @Override
        MetricInfo parse(String ... args) throws Exception {
            if (args.length == 2) {
                return MetricInfo.of((String)args[0], (String)args[1]);
            }
            String message = args.length > 2 ? "Too many arguments." : "Missing required metric name or filter.";
            throw new IllegalArgumentException(message);
        }

        @Override
        public String params() {
            return "<metric> <filter>";
        }
    }

    private static class DeleteMetricAction
    extends MetricAction {
        private DeleteMetricAction() {
        }

        @Override
        public void run(Logging logging, String metric) {
            logging.deleteMetric(metric);
            System.out.printf("Deleted metric %s%n", metric);
        }
    }

    private static class MetricInfoAction
    extends MetricAction {
        private MetricInfoAction() {
        }

        @Override
        public void run(Logging logging, String metric) {
            System.out.printf("Metric info: %s%n", logging.getMetric(metric));
        }
    }

    private static abstract class MetricAction
    extends LoggingAction<String> {
        private MetricAction() {
        }

        @Override
        String parse(String ... args) throws Exception {
            if (args.length == 1) {
                return args[0];
            }
            String message = args.length > 1 ? "Too many arguments." : "Missing required metric name.";
            throw new IllegalArgumentException(message);
        }

        @Override
        public String params() {
            return "<metric>";
        }
    }

    private static class ListMetricsAction
    extends NoArgsAction {
        private ListMetricsAction() {
        }

        @Override
        public void run(Logging logging, Void arg) {
            Iterator metricIterator = logging.listMetrics(new Logging.ListOption[0]).iterateAll();
            while (metricIterator.hasNext()) {
                System.out.println(metricIterator.next());
            }
        }
    }

    private static abstract class NoArgsAction
    extends LoggingAction<Void> {
        private NoArgsAction() {
        }

        @Override
        Void parse(String ... args) throws Exception {
            if (args.length == 0) {
                return null;
            }
            throw new IllegalArgumentException("This action takes no arguments.");
        }
    }

    private static class ParentAction
    extends LoggingAction<Tuple<LoggingAction, Object>> {
        private final Map<String, LoggingAction> subActions;

        ParentAction(Map<String, LoggingAction> subActions) {
            this.subActions = ImmutableMap.copyOf(subActions);
        }

        @Override
        void run(Logging logging, Tuple<LoggingAction, Object> subaction) throws Exception {
            subaction.x().run(logging, subaction.y());
        }

        @Override
        Tuple<LoggingAction, Object> parse(String ... args) throws Exception {
            if (args.length >= 1) {
                LoggingAction action = this.subActions.get(args[0]);
                if (action != null) {
                    Object actionArguments = action.parse(Arrays.copyOfRange(args, 1, args.length));
                    return Tuple.of(action, actionArguments);
                }
                throw new IllegalArgumentException("Unrecognized entity '" + args[0] + "'.");
            }
            throw new IllegalArgumentException("Missing required entity.");
        }

        @Override
        public String params() {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<String, LoggingAction> entry : this.subActions.entrySet()) {
                builder.append('\n').append(entry.getKey());
                String param = entry.getValue().params();
                if (param == null || param.isEmpty()) continue;
                builder.append(' ').append(param);
            }
            return builder.toString();
        }
    }

    private static class Tuple<X, Y> {
        private final X x;
        private final Y y;

        private Tuple(X x, Y y) {
            this.x = x;
            this.y = y;
        }

        public static <X, Y> Tuple<X, Y> of(X x, Y y) {
            return new Tuple<X, Y>(x, y);
        }

        X x() {
            return this.x;
        }

        Y y() {
            return this.y;
        }
    }

    private static abstract class LoggingAction<T> {
        private LoggingAction() {
        }

        abstract void run(Logging var1, T var2) throws Exception;

        abstract T parse(String ... var1) throws Exception;

        protected String params() {
            return "";
        }
    }
}

