/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.examples.storage.snippets;

import com.google.cloud.AuthCredentials;
import com.google.cloud.ReadChannel;
import com.google.cloud.ServiceAccountSigner;
import com.google.cloud.WriteChannel;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.CopyWriter;
import com.google.cloud.storage.Storage;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;

public class BlobSnippets {
    private final Blob blob;

    public BlobSnippets(Blob blob) {
        this.blob = blob;
    }

    public boolean exists() {
        boolean exists = this.blob.exists(new Blob.BlobSourceOption[0]);
        if (exists) {
            // empty if block
        }
        return exists;
    }

    public byte[] content() {
        byte[] content = this.blob.content(new Blob.BlobSourceOption[]{Blob.BlobSourceOption.generationMatch()});
        return content;
    }

    public Blob reload() {
        Blob latestBlob = this.blob.reload(new Blob.BlobSourceOption[]{Blob.BlobSourceOption.generationNotMatch()});
        if (latestBlob == null) {
            // empty if block
        }
        return latestBlob;
    }

    public Blob update() {
        HashMap<String, String> newMetadata = new HashMap<String, String>();
        newMetadata.put("key", "value");
        this.blob.toBuilder().metadata(null).build().update(new Storage.BlobTargetOption[0]);
        Blob updatedBlob = this.blob.toBuilder().metadata(newMetadata).build().update(new Storage.BlobTargetOption[0]);
        return updatedBlob;
    }

    public boolean delete() {
        boolean deleted = this.blob.delete(new Blob.BlobSourceOption[]{Blob.BlobSourceOption.generationMatch()});
        if (deleted) {
            // empty if block
        }
        return deleted;
    }

    public Blob copyToId(String bucketName, String blobName) {
        CopyWriter copyWriter = this.blob.copyTo(BlobId.of((String)bucketName, (String)blobName), new Blob.BlobSourceOption[0]);
        Blob copiedBlob = copyWriter.result();
        return copiedBlob;
    }

    public Blob copyToBucket(String bucketName) {
        CopyWriter copyWriter = this.blob.copyTo(bucketName, new Blob.BlobSourceOption[0]);
        Blob copiedBlob = copyWriter.result();
        return copiedBlob;
    }

    public Blob copyToStrings(String bucketName, String blobName) {
        CopyWriter copyWriter = this.blob.copyTo(bucketName, blobName, new Blob.BlobSourceOption[0]);
        Blob copiedBlob = copyWriter.result();
        return copiedBlob;
    }

    public void reader() throws IOException {
        try (ReadChannel reader = this.blob.reader(new Blob.BlobSourceOption[0]);){
            ByteBuffer bytes = ByteBuffer.allocate(65536);
            while (reader.read(bytes) > 0) {
                bytes.flip();
                bytes.clear();
            }
        }
    }

    public void writer() throws IOException {
        byte[] content = "Hello, World!".getBytes(StandardCharsets.UTF_8);
        try (WriteChannel writer = this.blob.writer(new Storage.BlobWriteOption[0]);){
            try {
                writer.write(ByteBuffer.wrap(content, 0, content.length));
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public URL signUrl() {
        URL signedUrl = this.blob.signUrl(14L, TimeUnit.DAYS, new Storage.SignUrlOption[0]);
        return signedUrl;
    }

    public URL signUrlWithSigner(String keyPath) throws IOException {
        URL signedUrl = this.blob.signUrl(14L, TimeUnit.DAYS, new Storage.SignUrlOption[]{Storage.SignUrlOption.signWith((ServiceAccountSigner)AuthCredentials.createForJson((InputStream)new FileInputStream(keyPath)))});
        return signedUrl;
    }
}

