/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.examples.storage.snippets;

import com.google.cloud.storage.Blob;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.Storage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class BucketSnippets {
    private final Bucket bucket;

    public BucketSnippets(Bucket bucket) {
        this.bucket = bucket;
    }

    public boolean exists() {
        boolean exists = this.bucket.exists(new Bucket.BucketSourceOption[0]);
        if (exists) {
            // empty if block
        }
        return exists;
    }

    public Bucket reload() {
        Bucket latestBucket = this.bucket.reload(new Bucket.BucketSourceOption[]{Bucket.BucketSourceOption.metagenerationMatch()});
        if (latestBucket == null) {
            // empty if block
        }
        return this.bucket;
    }

    public Bucket update() {
        Bucket updatedBucket = this.bucket.toBuilder().versioningEnabled(Boolean.valueOf(true)).build().update(new Storage.BucketTargetOption[0]);
        return updatedBucket;
    }

    public boolean delete() {
        boolean deleted = this.bucket.delete(new Bucket.BucketSourceOption[]{Bucket.BucketSourceOption.metagenerationMatch()});
        if (deleted) {
            // empty if block
        }
        return deleted;
    }

    public Iterator<Blob> listBlobs() {
        Iterator blobIterator = this.bucket.list(new Storage.BlobListOption[0]).iterateAll();
        while (blobIterator.hasNext()) {
            Blob blob = (Blob)blobIterator.next();
        }
        return blobIterator;
    }

    public Blob getBlob(String blobName, long generation) {
        Blob blob = this.bucket.get(blobName, new Storage.BlobGetOption[]{Storage.BlobGetOption.generationMatch((long)generation)});
        return blob;
    }

    public List<Blob> getBlobFromStrings(String blobName1, String blobName2) {
        List blobs = this.bucket.get(blobName1, blobName2, new String[0]);
        for (Blob blob : blobs) {
            if (blob != null) continue;
        }
        return blobs;
    }

    public List<Blob> getBlobFromStringIterable(String blobName1, String blobName2) {
        LinkedList<String> blobNames = new LinkedList<String>();
        blobNames.add(blobName1);
        blobNames.add(blobName2);
        List blobs = this.bucket.get(blobNames);
        for (Blob blob : blobs) {
            if (blob != null) continue;
        }
        return blobs;
    }

    public Blob createBlobFromByteArray(String blobName) {
        Blob blob = this.bucket.create(blobName, "Hello, World!".getBytes(StandardCharsets.UTF_8), new Bucket.BlobTargetOption[0]);
        return blob;
    }

    public Blob createBlobFromInputStream(String blobName) {
        ByteArrayInputStream content = new ByteArrayInputStream("Hello, World!".getBytes(StandardCharsets.UTF_8));
        Blob blob = this.bucket.create(blobName, (InputStream)content, new Bucket.BlobWriteOption[0]);
        return blob;
    }

    public Blob createBlobFromByteArrayWithContentType(String blobName) {
        Blob blob = this.bucket.create(blobName, "Hello, World!".getBytes(StandardCharsets.UTF_8), "text/plain", new Bucket.BlobTargetOption[0]);
        return blob;
    }

    public Blob createBlobFromInputStreamWithContentType(String blobName) {
        ByteArrayInputStream content = new ByteArrayInputStream("Hello, World!".getBytes(StandardCharsets.UTF_8));
        Blob blob = this.bucket.create(blobName, (InputStream)content, "text/plain", new Bucket.BlobWriteOption[0]);
        return blob;
    }
}

