/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.examples.storage.snippets;

import com.google.cloud.AuthCredentials;
import com.google.cloud.BatchResult;
import com.google.cloud.Page;
import com.google.cloud.ReadChannel;
import com.google.cloud.ServiceAccountSigner;
import com.google.cloud.WriteChannel;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.BucketInfo;
import com.google.cloud.storage.CopyWriter;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageBatch;
import com.google.cloud.storage.StorageBatchResult;
import com.google.cloud.storage.StorageException;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class StorageSnippets {
    private final Storage storage;

    public StorageSnippets(Storage storage) {
        this.storage = storage;
    }

    public Bucket createBucket(String bucketName) {
        Bucket bucket = this.storage.create(BucketInfo.of((String)bucketName), new Storage.BucketTargetOption[0]);
        return bucket;
    }

    public Blob createBlob(String bucketName, String blobName) {
        BlobId blobId = BlobId.of((String)bucketName, (String)blobName);
        BlobInfo blobInfo = BlobInfo.builder((BlobId)blobId).contentType("text/plain").build();
        Blob blob = this.storage.create(blobInfo, new Storage.BlobTargetOption[0]);
        return blob;
    }

    public Blob createBlobFromByteArray(String bucketName, String blobName) {
        BlobId blobId = BlobId.of((String)bucketName, (String)blobName);
        BlobInfo blobInfo = BlobInfo.builder((BlobId)blobId).contentType("text/plain").build();
        Blob blob = this.storage.create(blobInfo, "Hello, World!".getBytes(StandardCharsets.UTF_8), new Storage.BlobTargetOption[0]);
        return blob;
    }

    public Blob createBlobFromInputStream(String bucketName, String blobName) {
        ByteArrayInputStream content = new ByteArrayInputStream("Hello, World!".getBytes(StandardCharsets.UTF_8));
        BlobId blobId = BlobId.of((String)bucketName, (String)blobName);
        BlobInfo blobInfo = BlobInfo.builder((BlobId)blobId).contentType("text/plain").build();
        Blob blob = this.storage.create(blobInfo, (InputStream)content, new Storage.BlobWriteOption[0]);
        return blob;
    }

    public Bucket getBucketWithMetageneration(String bucketName, long bucketMetageneration) {
        Bucket bucket = this.storage.get(bucketName, new Storage.BucketGetOption[]{Storage.BucketGetOption.metagenerationMatch((long)bucketMetageneration)});
        return bucket;
    }

    public Blob getBlobFromStringsWithMetageneration(String bucketName, String blobName, long blobMetageneration) {
        Blob blob = this.storage.get(bucketName, blobName, new Storage.BlobGetOption[]{Storage.BlobGetOption.metagenerationMatch((long)blobMetageneration)});
        return blob;
    }

    public Blob getBlobFromId(String bucketName, String blobName) {
        BlobId blobId = BlobId.of((String)bucketName, (String)blobName);
        Blob blob = this.storage.get(blobId);
        return blob;
    }

    public Blob getBlobFromIdWithMetageneration(String bucketName, String blobName, long blobMetageneration) {
        BlobId blobId = BlobId.of((String)bucketName, (String)blobName);
        Blob blob = this.storage.get(blobId, new Storage.BlobGetOption[]{Storage.BlobGetOption.metagenerationMatch((long)blobMetageneration)});
        return blob;
    }

    public Iterator<Bucket> listBucketsWithSizeAndPrefix(String prefix) {
        Page buckets = this.storage.list(new Storage.BucketListOption[]{Storage.BucketListOption.pageSize((long)100L), Storage.BucketListOption.prefix((String)prefix)});
        Iterator bucketIterator = buckets.iterateAll();
        while (bucketIterator.hasNext()) {
            Bucket bucket = (Bucket)bucketIterator.next();
        }
        return bucketIterator;
    }

    public Iterator<Blob> listBlobsWithDirectoryAndPrefix(String bucketName, String directory) {
        Page blobs = this.storage.list(bucketName, new Storage.BlobListOption[]{Storage.BlobListOption.currentDirectory(), Storage.BlobListOption.prefix((String)directory)});
        Iterator blobIterator = blobs.iterateAll();
        while (blobIterator.hasNext()) {
            Blob blob = (Blob)blobIterator.next();
        }
        return blobIterator;
    }

    public Bucket updateBucket(String bucketName) {
        BucketInfo bucketInfo = BucketInfo.builder((String)bucketName).versioningEnabled(Boolean.valueOf(true)).build();
        Bucket bucket = this.storage.update(bucketInfo, new Storage.BucketTargetOption[0]);
        return bucket;
    }

    public Blob updateBlob(String bucketName, String blobName) {
        HashMap<String, String> newMetadata = new HashMap<String, String>();
        newMetadata.put("key", "value");
        this.storage.update(BlobInfo.builder((String)bucketName, (String)blobName).metadata(null).build());
        Blob blob = this.storage.update(BlobInfo.builder((String)bucketName, (String)blobName).metadata(newMetadata).build());
        return blob;
    }

    public Blob updateBlobWithMetageneration(String bucketName, String blobName) {
        Blob blob = this.storage.get(bucketName, blobName, new Storage.BlobGetOption[0]);
        Blob updatedInfo = blob.toBuilder().contentType("text/plain").build();
        this.storage.update((BlobInfo)updatedInfo, new Storage.BlobTargetOption[]{Storage.BlobTargetOption.metagenerationMatch()});
        return blob;
    }

    public boolean deleteBucketWithMetageneration(String bucketName, long bucketMetageneration) {
        boolean deleted = this.storage.delete(bucketName, new Storage.BucketSourceOption[]{Storage.BucketSourceOption.metagenerationMatch((long)bucketMetageneration)});
        if (deleted) {
            // empty if block
        }
        return deleted;
    }

    public boolean deleteBlobFromStringsWithGeneration(String bucketName, String blobName, long blobGeneration) {
        boolean deleted = this.storage.delete(bucketName, blobName, new Storage.BlobSourceOption[]{Storage.BlobSourceOption.generationMatch((long)blobGeneration)});
        if (deleted) {
            // empty if block
        }
        return deleted;
    }

    public boolean deleteBlobFromIdWithGeneration(String bucketName, String blobName, long blobGeneration) {
        BlobId blobId = BlobId.of((String)bucketName, (String)blobName);
        boolean deleted = this.storage.delete(blobId, new Storage.BlobSourceOption[]{Storage.BlobSourceOption.generationMatch((long)blobGeneration)});
        if (deleted) {
            // empty if block
        }
        return deleted;
    }

    public boolean deleteBlob(String bucketName, String blobName) {
        BlobId blobId = BlobId.of((String)bucketName, (String)blobName);
        boolean deleted = this.storage.delete(blobId);
        if (deleted) {
            // empty if block
        }
        return deleted;
    }

    public Blob composeBlobs(String bucketName, String blobName, String sourceBlob1, String sourceBlob2) {
        BlobId blobId = BlobId.of((String)bucketName, (String)blobName);
        BlobInfo blobInfo = BlobInfo.builder((BlobId)blobId).contentType("text/plain").build();
        Storage.ComposeRequest request = Storage.ComposeRequest.builder().target(blobInfo).addSource(new String[]{sourceBlob1}).addSource(new String[]{sourceBlob2}).build();
        Blob blob = this.storage.compose(request);
        return blob;
    }

    public Blob copyBlob(String bucketName, String blobName, String copyBlobName) {
        Storage.CopyRequest request = Storage.CopyRequest.builder().source(BlobId.of((String)bucketName, (String)blobName)).target(BlobId.of((String)bucketName, (String)copyBlobName)).build();
        Blob blob = this.storage.copy(request).result();
        return blob;
    }

    public Blob copyBlobInChunks(String bucketName, String blobName, String copyBlobName) {
        Storage.CopyRequest request = Storage.CopyRequest.builder().source(BlobId.of((String)bucketName, (String)blobName)).target(BlobId.of((String)bucketName, (String)copyBlobName)).build();
        CopyWriter copyWriter = this.storage.copy(request);
        while (!copyWriter.isDone()) {
            copyWriter.copyChunk();
        }
        Blob blob = copyWriter.result();
        return blob;
    }

    public byte[] readBlobFromStringsWithGeneration(String bucketName, String blobName, long blobGeneration) {
        byte[] content = this.storage.readAllBytes(bucketName, blobName, new Storage.BlobSourceOption[]{Storage.BlobSourceOption.generationMatch((long)blobGeneration)});
        return content;
    }

    public byte[] readBlobFromId(String bucketName, String blobName, long blobGeneration) {
        BlobId blobId = BlobId.of((String)bucketName, (String)blobName, (Long)blobGeneration);
        byte[] content = this.storage.readAllBytes(blobId, new Storage.BlobSourceOption[0]);
        return content;
    }

    public Blob batch(String bucketName, String blobName1, String blobName2) {
        StorageBatch batch = this.storage.batch();
        BlobId firstBlob = BlobId.of((String)bucketName, (String)blobName1);
        BlobId secondBlob = BlobId.of((String)bucketName, (String)blobName2);
        batch.delete(firstBlob, new Storage.BlobSourceOption[0]).notify((BatchResult.Callback)new BatchResult.Callback<Boolean, StorageException>(){

            public void success(Boolean result) {
            }

            public void error(StorageException exception) {
            }
        });
        batch.update(BlobInfo.builder((BlobId)secondBlob).contentType("text/plain").build(), new Storage.BlobTargetOption[0]);
        StorageBatchResult result = batch.get(secondBlob, new Storage.BlobGetOption[0]);
        batch.submit();
        Blob blob = (Blob)result.get();
        return blob;
    }

    public void readerFromStrings(String bucketName, String blobName) throws IOException {
        try (ReadChannel reader = this.storage.reader(bucketName, blobName, new Storage.BlobSourceOption[0]);){
            ByteBuffer bytes = ByteBuffer.allocate(65536);
            while (reader.read(bytes) > 0) {
                bytes.flip();
                bytes.clear();
            }
        }
    }

    public void readerFromId(String bucketName, String blobName) throws IOException {
        BlobId blobId = BlobId.of((String)bucketName, (String)blobName);
        try (ReadChannel reader = this.storage.reader(blobId, new Storage.BlobSourceOption[0]);){
            ByteBuffer bytes = ByteBuffer.allocate(65536);
            while (reader.read(bytes) > 0) {
                bytes.flip();
                bytes.clear();
            }
        }
    }

    public void writer(String bucketName, String blobName) throws IOException {
        BlobId blobId = BlobId.of((String)bucketName, (String)blobName);
        byte[] content = "Hello, World!".getBytes(StandardCharsets.UTF_8);
        BlobInfo blobInfo = BlobInfo.builder((BlobId)blobId).contentType("text/plain").build();
        try (WriteChannel writer = this.storage.writer(blobInfo, new Storage.BlobWriteOption[0]);){
            try {
                writer.write(ByteBuffer.wrap(content, 0, content.length));
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public URL signUrl(String bucketName, String blobName) {
        URL signedUrl = this.storage.signUrl(BlobInfo.builder((String)bucketName, (String)blobName).build(), 14L, TimeUnit.DAYS, new Storage.SignUrlOption[0]);
        return signedUrl;
    }

    public URL signUrlWithSigner(String bucketName, String blobName, String keyPath) throws IOException {
        URL signedUrl = this.storage.signUrl(BlobInfo.builder((String)bucketName, (String)blobName).build(), 14L, TimeUnit.DAYS, new Storage.SignUrlOption[]{Storage.SignUrlOption.signWith((ServiceAccountSigner)AuthCredentials.createForJson((InputStream)new FileInputStream(keyPath)))});
        return signedUrl;
    }

    public List<Blob> batchGet(String bucketName, String blobName1, String blobName2) {
        BlobId firstBlob = BlobId.of((String)bucketName, (String)blobName1);
        BlobId secondBlob = BlobId.of((String)bucketName, (String)blobName2);
        List blobs = this.storage.get(new BlobId[]{firstBlob, secondBlob});
        return blobs;
    }

    public List<Blob> batchGetIterable(String bucketName, String blobName1, String blobName2) {
        LinkedList<BlobId> blobIds = new LinkedList<BlobId>();
        blobIds.add(BlobId.of((String)bucketName, (String)blobName1));
        blobIds.add(BlobId.of((String)bucketName, (String)blobName2));
        List blobs = this.storage.get(blobIds);
        return blobs;
    }

    public List<Blob> batchUpdate(String bucketName, String blobName1, String blobName2) {
        Blob firstBlob = this.storage.get(bucketName, blobName1, new Storage.BlobGetOption[0]);
        Blob secondBlob = this.storage.get(bucketName, blobName2, new Storage.BlobGetOption[0]);
        List updatedBlobs = this.storage.update(new BlobInfo[]{firstBlob.toBuilder().contentType("text/plain").build(), secondBlob.toBuilder().contentType("text/plain").build()});
        return updatedBlobs;
    }

    public List<Blob> batchUpdateIterable(String bucketName, String blobName1, String blobName2) {
        Blob firstBlob = this.storage.get(bucketName, blobName1, new Storage.BlobGetOption[0]);
        Blob secondBlob = this.storage.get(bucketName, blobName2, new Storage.BlobGetOption[0]);
        LinkedList<Blob> blobs = new LinkedList<Blob>();
        blobs.add(firstBlob.toBuilder().contentType("text/plain").build());
        blobs.add(secondBlob.toBuilder().contentType("text/plain").build());
        List updatedBlobs = this.storage.update(blobs);
        return updatedBlobs;
    }

    public List<Boolean> batchDelete(String bucketName, String blobName1, String blobName2) {
        BlobId firstBlob = BlobId.of((String)bucketName, (String)blobName1);
        BlobId secondBlob = BlobId.of((String)bucketName, (String)blobName2);
        List deleted = this.storage.delete(new BlobId[]{firstBlob, secondBlob});
        return deleted;
    }

    public List<Boolean> batchDeleteIterable(String bucketName, String blobName1, String blobName2) {
        LinkedList<BlobId> blobIds = new LinkedList<BlobId>();
        blobIds.add(BlobId.of((String)bucketName, (String)blobName1));
        blobIds.add(BlobId.of((String)bucketName, (String)blobName2));
        List deleted = this.storage.delete(blobIds);
        return deleted;
    }
}

