/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.examples.translate;

import com.google.cloud.translate.Detection;
import com.google.cloud.translate.Language;
import com.google.cloud.translate.Translate;
import com.google.cloud.translate.TranslateOptions;
import com.google.cloud.translate.Translation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TranslateExample {
    private static final Map<String, TranslateAction> ACTIONS = new HashMap<String, TranslateAction>();

    private static void printUsage() {
        StringBuilder actionAndParams = new StringBuilder();
        for (Map.Entry<String, TranslateAction> entry : ACTIONS.entrySet()) {
            actionAndParams.append(System.lineSeparator()).append('\t').append(entry.getKey());
            String param = entry.getValue().params();
            if (param == null || param.isEmpty()) continue;
            actionAndParams.append(' ').append(param);
        }
        System.out.printf("Usage: %s [<apiKey>] [<targetLanguage>] operation <args>*%s%n", TranslateExample.class.getSimpleName(), actionAndParams);
    }

    public static void main(String ... args) throws Exception {
        Object arg;
        String actionName;
        if (args.length < 1) {
            System.out.println("Missing required action");
            TranslateExample.printUsage();
            return;
        }
        TranslateOptions.Builder optionsBuilder = TranslateOptions.builder();
        if (args.length >= 3 && !ACTIONS.containsKey(args[1])) {
            optionsBuilder.apiKey(args[0]);
            actionName = args[2];
            optionsBuilder.targetLanguage(args[1]);
            args = Arrays.copyOfRange(args, 3, args.length);
        } else if (args.length >= 2 && !ACTIONS.containsKey(args[0])) {
            optionsBuilder.apiKey(args[0]);
            actionName = args[1];
            args = Arrays.copyOfRange(args, 2, args.length);
        } else {
            actionName = args[0];
            args = Arrays.copyOfRange(args, 1, args.length);
        }
        TranslateAction action = ACTIONS.get(actionName);
        if (action == null) {
            System.out.println("Unrecognized action.");
            TranslateExample.printUsage();
            return;
        }
        try {
            arg = action.parse(args);
        }
        catch (IllegalArgumentException ex) {
            System.out.printf("Invalid input for action '%s'. %s%n", actionName, ex.getMessage());
            System.out.printf("Expected: %s%n", action.params());
            return;
        }
        catch (Exception ex) {
            System.out.println("Failed to parse arguments.");
            ex.printStackTrace();
            return;
        }
        Translate translate = (Translate)optionsBuilder.build().service();
        action.run(translate, arg);
    }

    static {
        ACTIONS.put("languages", new ListLanguagesAction());
        ACTIONS.put("detect", new DetectLanguageAction());
        ACTIONS.put("translate", new TranslateTextAction());
    }

    private static class TranslateTextAction
    extends TranslateAction<List<String>> {
        private TranslateTextAction() {
        }

        @Override
        public void run(Translate translate, List<String> texts) {
            List translations = translate.translate(texts, new Translate.TranslateOption[0]);
            if (texts.size() == 1) {
                System.out.println("Translation is:");
            } else {
                System.out.println("Translations are:");
            }
            for (Translation translation : translations) {
                System.out.println(translation);
            }
        }

        @Override
        List<String> parse(String ... args) throws Exception {
            if (args.length >= 1) {
                return Arrays.asList(args);
            }
            throw new IllegalArgumentException("Missing required texts.");
        }

        @Override
        public String params() {
            return "<text>+";
        }
    }

    private static class DetectLanguageAction
    extends TranslateAction<List<String>> {
        private DetectLanguageAction() {
        }

        @Override
        public void run(Translate translate, List<String> texts) {
            List detections = translate.detect(texts);
            if (texts.size() == 1) {
                System.out.println("Detected language is:");
            } else {
                System.out.println("Detected languages are:");
            }
            for (Detection detection : detections) {
                System.out.println(detection);
            }
        }

        @Override
        List<String> parse(String ... args) throws Exception {
            if (args.length >= 1) {
                return Arrays.asList(args);
            }
            throw new IllegalArgumentException("Missing required texts.");
        }

        @Override
        public String params() {
            return "<text>+";
        }
    }

    private static class ListLanguagesAction
    extends TranslateAction<Void> {
        private ListLanguagesAction() {
        }

        @Override
        public void run(Translate translate, Void arg) {
            List languages = translate.listSupportedLanguages(new Translate.LanguageListOption[0]);
            System.out.println("Supported languages:");
            for (Language language : languages) {
                System.out.println(language);
            }
        }

        @Override
        Void parse(String ... args) throws Exception {
            if (args.length == 0) {
                return null;
            }
            throw new IllegalArgumentException("This action takes no arguments.");
        }
    }

    private static abstract class TranslateAction<T> {
        private TranslateAction() {
        }

        abstract void run(Translate var1, T var2) throws Exception;

        abstract T parse(String ... var1) throws Exception;

        protected String params() {
            return "";
        }
    }
}

