/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.examples.translate.snippets;

import com.google.cloud.translate.Detection;
import com.google.cloud.translate.Language;
import com.google.cloud.translate.Translate;
import com.google.cloud.translate.Translation;
import java.util.LinkedList;
import java.util.List;

public class TranslateSnippets {
    private final Translate translate;

    public TranslateSnippets(Translate translate) {
        this.translate = translate;
    }

    public List<Language> listSupportedLanguages() {
        List languages = this.translate.listSupportedLanguages(new Translate.LanguageListOption[0]);
        return languages;
    }

    public List<Language> listSupportedLanguagesWithTarget() {
        List languages = this.translate.listSupportedLanguages(new Translate.LanguageListOption[]{Translate.LanguageListOption.targetLanguage((String)"es")});
        return languages;
    }

    public List<Detection> detectLanguageOfTextList() {
        LinkedList<String> texts = new LinkedList<String>();
        texts.add("Hello, World!");
        texts.add("\u00a1Hola Mundo!");
        List detections = this.translate.detect(texts);
        return detections;
    }

    public List<Detection> detectLanguageOfTexts() {
        List detections = this.translate.detect(new String[]{"Hello, World!", "\u00a1Hola Mundo!"});
        return detections;
    }

    public Detection detectLanguageOfText() {
        Detection detection = this.translate.detect("Hello, World!");
        return detection;
    }

    public List<Translation> translateTexts() {
        LinkedList<String> texts = new LinkedList<String>();
        texts.add("Hello, World!");
        texts.add("\u00a1Hola Mundo!");
        List translations = this.translate.translate(texts, new Translate.TranslateOption[0]);
        return translations;
    }

    public List<Translation> translateTextsWithOptions() {
        LinkedList<String> texts = new LinkedList<String>();
        texts.add("\u00a1Hola Mundo!");
        List translations = this.translate.translate(texts, new Translate.TranslateOption[]{Translate.TranslateOption.sourceLanguage((String)"es"), Translate.TranslateOption.targetLanguage((String)"de")});
        return translations;
    }

    public Translation translateText() {
        Translation translation = this.translate.translate("\u00a1Hola Mundo!", new Translate.TranslateOption[0]);
        return translation;
    }

    public Translation translateTextWithOptions() {
        Translation translation = this.translate.translate("\u00a1Hola Mundo!", new Translate.TranslateOption[]{Translate.TranslateOption.sourceLanguage((String)"es"), Translate.TranslateOption.targetLanguage((String)"de")});
        return translation;
    }
}

