/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.resourcemanager;

import com.google.api.services.cloudresourcemanager.model.Binding;
import com.google.cloud.IamPolicy;
import com.google.cloud.Identity;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Policy
extends IamPolicy<String> {
    private static final long serialVersionUID = -5573557282693961850L;

    private Policy(Builder builder) {
        super((IamPolicy.Builder)builder);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this.bindings(), this.etag(), this.version());
    }

    public String toString() {
        return this.toPb().toString();
    }

    com.google.api.services.cloudresourcemanager.model.Policy toPb() {
        com.google.api.services.cloudresourcemanager.model.Policy policyPb = new com.google.api.services.cloudresourcemanager.model.Policy();
        LinkedList<Binding> bindingPbList = new LinkedList<Binding>();
        for (Map.Entry binding : this.bindings().entrySet()) {
            Binding bindingPb = new Binding();
            bindingPb.setRole((String)binding.getKey());
            bindingPb.setMembers(Lists.transform(new ArrayList((Collection)binding.getValue()), (Function)new Function<Identity, String>(){

                public String apply(Identity identity) {
                    return identity.strValue();
                }
            }));
            bindingPbList.add(bindingPb);
        }
        policyPb.setBindings(bindingPbList);
        policyPb.setEtag(this.etag());
        policyPb.setVersion(this.version());
        return policyPb;
    }

    static Policy fromPb(com.google.api.services.cloudresourcemanager.model.Policy policyPb) {
        HashMap<String, Set<Identity>> bindings = new HashMap<String, Set<Identity>>();
        for (Binding bindingPb : policyPb.getBindings()) {
            bindings.put(bindingPb.getRole(), (Set<Identity>)ImmutableSet.copyOf((Collection)Lists.transform((List)bindingPb.getMembers(), (Function)new Function<String, Identity>(){

                public Identity apply(String identityPb) {
                    return Identity.valueOf((String)identityPb);
                }
            })));
        }
        return new Builder(bindings, policyPb.getEtag(), policyPb.getVersion()).build();
    }

    public static class Builder
    extends IamPolicy.Builder<String, Builder> {
        private Builder() {
        }

        @VisibleForTesting
        Builder(Map<String, Set<Identity>> bindings, String etag, Integer version) {
            ((Builder)((Builder)this.bindings(bindings)).etag(etag)).version(version);
        }

        public Policy build() {
            return new Policy(this);
        }
    }

    public static enum ProjectRole {
        VIEWER("roles/viewer"),
        EDITOR("roles/editor"),
        OWNER("roles/owner");

        private final String value;

        private ProjectRole(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

