/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.facebookapi;

import com.google.code.facebookapi.ApplicationProperty;
import java.io.Serializable;
import java.util.Map;
import java.util.TreeMap;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationPropertySet
implements Serializable {
    private Map<ApplicationProperty, Boolean> _attributesBool;
    private Map<ApplicationProperty, String> _attributesString;

    public ApplicationPropertySet() {
    }

    public ApplicationPropertySet(String jsonString) throws ClassCastException {
        Map<ApplicationProperty, String> mappings = ApplicationPropertySet.parseProperties(jsonString);
        for (Map.Entry<ApplicationProperty, String> entry : mappings.entrySet()) {
            ApplicationProperty prop = entry.getKey();
            String value = entry.getValue();
            if (prop.isBooleanProperty()) {
                this.setBoolProperty(prop, "1".equals(value));
                continue;
            }
            if (!prop.isStringProperty()) continue;
            this.setStringProperty(prop, value);
        }
    }

    public void setBoolProperty(ApplicationProperty prop, boolean value) {
        if (null == prop || !prop.isBooleanProperty()) {
            throw new IllegalArgumentException("Boolean property expected");
        }
        if (null == this._attributesBool) {
            this._attributesBool = new TreeMap<ApplicationProperty, Boolean>();
        }
        this._attributesBool.put(prop, value);
    }

    public Boolean getBoolProperty(ApplicationProperty prop) {
        if (null == prop || !prop.isBooleanProperty()) {
            throw new IllegalArgumentException("Boolean property expected");
        }
        return null == this._attributesBool ? null : this._attributesBool.get((Object)prop);
    }

    public void setStringProperty(ApplicationProperty prop, String value) {
        if (null == prop || !prop.isStringProperty()) {
            throw new IllegalArgumentException("String property expected");
        }
        if (null == this._attributesString) {
            this._attributesString = new TreeMap<ApplicationProperty, String>();
        }
        this._attributesString.put(prop, value);
    }

    public String getStringProperty(ApplicationProperty prop) {
        if (null == prop || !prop.isStringProperty()) {
            throw new IllegalArgumentException("String property expected");
        }
        return null == this._attributesString ? null : this._attributesString.get((Object)prop);
    }

    public void removeProperty(ApplicationProperty prop) {
        if (prop.isBooleanProperty()) {
            this._attributesBool.remove((Object)prop);
        } else if (prop.isStringProperty()) {
            this._attributesString.remove((Object)prop);
        }
    }

    public boolean isEmpty() {
        return !(null != this._attributesString && !this._attributesString.isEmpty() || null != this._attributesBool && !this._attributesBool.isEmpty());
    }

    public JSONObject jsonify() {
        JSONObject ret = new JSONObject();
        if (null != this._attributesString) {
            for (Map.Entry<ApplicationProperty, String> entry : this._attributesString.entrySet()) {
                try {
                    ret.put(entry.getKey().propertyName(), (Object)entry.getValue().toString());
                }
                catch (Exception ignored) {}
            }
        }
        if (null != this._attributesBool) {
            for (Map.Entry<ApplicationProperty, Object> entry : this._attributesBool.entrySet()) {
                try {
                    ret.put(entry.getKey().propertyName(), entry.getValue());
                }
                catch (Exception ignored) {}
            }
        }
        return ret;
    }

    public String toJsonString() {
        return this.jsonify().toString();
    }

    public static Map<ApplicationProperty, String> parseProperties(String json) {
        String[] parts;
        TreeMap<ApplicationProperty, String> result = new TreeMap<ApplicationProperty, String>();
        if (json == null) {
            return result;
        }
        json = json.matches("\\{.*\\}") ? json.substring(1, json.lastIndexOf("}")) : json.substring(1, json.lastIndexOf("]"));
        for (String part : parts = json.split("\\,")) {
            ApplicationPropertySet.parseFragment(part, result);
        }
        return result;
    }

    private static void parseFragment(String fragment, Map<ApplicationProperty, String> result) {
        if (fragment.startsWith("{")) {
            fragment = fragment.substring(1, fragment.lastIndexOf("}"));
        }
        String keyString = fragment.substring(1);
        keyString = keyString.substring(0, keyString.indexOf(34));
        ApplicationProperty key = ApplicationProperty.getPropertyForString(keyString);
        String value = fragment.substring(fragment.indexOf(":") + 1).replaceAll("\\\\", "");
        if (key.getType().equals("string")) {
            result.put(key, value.substring(1, value.lastIndexOf(34)));
        } else if (value.equals("1")) {
            result.put(key, "true");
        } else {
            result.put(key, "false");
        }
    }
}

