/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DefinitionProvider;
import com.google.javascript.jscomp.DefinitionSite;
import com.google.javascript.jscomp.DefinitionsRemover;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.SimpleDefinitionFinder;
import com.google.javascript.jscomp.UseSite;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.jscomp.graph.Graph;
import com.google.javascript.jscomp.graph.LinkedDirectedGraph;
import com.google.javascript.rhino.Node;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;

public class CallGraph
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final Map<Node, Callsite> callsitesByNode;
    private final Map<Node, Function> functionsByNode;
    private final boolean computeBackwardGraph;
    private final boolean computeForwardGraph;
    private boolean alreadyRun = false;
    @VisibleForTesting
    public static final String MAIN_FUNCTION_NAME = "{main}";
    private Function mainFunction;

    public CallGraph(AbstractCompiler compiler, boolean computeForwardGraph, boolean computeBackwardGraph) {
        Preconditions.checkArgument((computeForwardGraph || computeBackwardGraph ? 1 : 0) != 0);
        this.compiler = compiler;
        this.computeForwardGraph = computeForwardGraph;
        this.computeBackwardGraph = computeBackwardGraph;
        this.callsitesByNode = Maps.newLinkedHashMap();
        this.functionsByNode = Maps.newLinkedHashMap();
    }

    public CallGraph(AbstractCompiler compiler) {
        this(compiler, true, true);
    }

    @Override
    public void process(Node externsRoot, Node jsRoot) {
        Preconditions.checkState((!this.alreadyRun ? 1 : 0) != 0);
        DefinitionProvider definitionProvider = this.constructDefinitionProvider(externsRoot, jsRoot);
        this.createFunctionsAndCallsites(jsRoot, definitionProvider);
        this.fillInFunctionInformation(definitionProvider);
        this.alreadyRun = true;
    }

    public Function getFunctionForAstNode(Node functionNode) {
        Preconditions.checkArgument((boolean)functionNode.isFunction());
        return this.functionsByNode.get(functionNode);
    }

    public Function getMainFunction() {
        return this.mainFunction;
    }

    public Collection<Function> getAllFunctions() {
        return this.functionsByNode.values();
    }

    @VisibleForTesting
    public Function getUniqueFunctionWithName(final String desiredName) {
        Collection functions = Collections2.filter(this.getAllFunctions(), (Predicate)new Predicate<Function>(){

            public boolean apply(Function function) {
                String functionName = function.getName();
                if (functionName != null && desiredName != null) {
                    return desiredName.equals(functionName);
                }
                return desiredName == functionName;
            }
        });
        if (functions.size() == 1) {
            return (Function)functions.iterator().next();
        }
        throw new IllegalStateException("Found " + functions.size() + " functions with name " + desiredName);
    }

    public Callsite getCallsiteForAstNode(Node callsiteNode) {
        Preconditions.checkArgument((callsiteNode.isCall() || callsiteNode.isNew() ? 1 : 0) != 0);
        return this.callsitesByNode.get(callsiteNode);
    }

    public Collection<Callsite> getAllCallsites() {
        return this.callsitesByNode.values();
    }

    private void createFunctionsAndCallsites(Node jsRoot, final DefinitionProvider provider) {
        this.mainFunction = this.createFunction(jsRoot);
        NodeTraversal.traverse(this.compiler, jsRoot, new NodeTraversal.AbstractPostOrderCallback(){

            @Override
            public void visit(NodeTraversal t, Node n, Node parent) {
                int nodeType = n.getType();
                if (nodeType == 37 || nodeType == 30) {
                    Callsite callsite = CallGraph.this.createCallsite(n);
                    Node containingFunctionNode = t.getScopeRoot();
                    Function containingFunction = (Function)CallGraph.this.functionsByNode.get(containingFunctionNode);
                    if (containingFunction == null) {
                        containingFunction = CallGraph.this.createFunction(containingFunctionNode);
                    }
                    callsite.containingFunction = containingFunction;
                    containingFunction.addCallsiteInFunction(callsite);
                    CallGraph.this.connectCallsiteToTargets(callsite, provider);
                } else if (n.isFunction() && !CallGraph.this.functionsByNode.containsKey(n)) {
                    CallGraph.this.createFunction(n);
                }
            }
        });
    }

    private Function createFunction(Node functionNode) {
        Function function = new Function(functionNode);
        this.functionsByNode.put(functionNode, function);
        return function;
    }

    private Callsite createCallsite(Node callsiteNode) {
        Callsite callsite = new Callsite(callsiteNode);
        this.callsitesByNode.put(callsiteNode, callsite);
        return callsite;
    }

    private void connectCallsiteToTargets(Callsite callsite, DefinitionProvider definitionProvider) {
        Collection<DefinitionsRemover.Definition> definitions = this.lookupDefinitionsForTargetsOfCall(callsite.getAstNode(), definitionProvider);
        if (definitions == null) {
            callsite.hasUnknownTarget = true;
        } else {
            for (DefinitionsRemover.Definition definition : definitions) {
                if (definition.isExtern()) {
                    callsite.hasExternTarget = true;
                    continue;
                }
                Node target = definition.getRValue();
                if (target != null && target.isFunction()) {
                    Function targetFunction = this.functionsByNode.get(target);
                    if (targetFunction == null) {
                        targetFunction = this.createFunction(target);
                    }
                    if (this.computeForwardGraph) {
                        callsite.addPossibleTarget(targetFunction);
                    }
                    if (!this.computeBackwardGraph) continue;
                    targetFunction.addCallsitePossiblyTargetingFunction(callsite);
                    continue;
                }
                callsite.hasUnknownTarget = true;
            }
        }
    }

    private void fillInFunctionInformation(DefinitionProvider provider) {
        SimpleDefinitionFinder finder = (SimpleDefinitionFinder)provider;
        for (DefinitionSite definitionSite : finder.getDefinitionSites()) {
            DefinitionsRemover.Definition definition = definitionSite.definition;
            Function function = this.lookupFunctionForDefinition(definition);
            if (function == null) continue;
            for (UseSite useSite : finder.getUseSites(definition)) {
                this.updateFunctionForUse(function, useSite.node);
            }
        }
    }

    private void updateFunctionForUse(Function function, Node useNode) {
        Node useParent = useNode.getParent();
        int parentType = useParent.getType();
        if (parentType != 37 && parentType != 30 || useParent.getFirstChild() != useNode) {
            if (NodeUtil.isGet(useParent)) {
                Node gramps;
                if (useParent.isGetProp() && (NodeUtil.isFunctionObjectApply(gramps = useParent.getParent()) || NodeUtil.isFunctionObjectCall(gramps))) {
                    function.isExposedToCallOrApply = true;
                }
            } else {
                function.isAliased = true;
            }
        }
    }

    private Function lookupFunctionForDefinition(DefinitionsRemover.Definition definition) {
        Node rValue;
        if (definition != null && !definition.isExtern() && (rValue = definition.getRValue()) != null && rValue.isFunction()) {
            Function function = this.functionsByNode.get(rValue);
            Preconditions.checkNotNull((Object)function);
            return function;
        }
        return null;
    }

    public DiGraph<Function, Callsite> getForwardDirectedGraph() {
        return this.constructDirectedGraph(true);
    }

    public DiGraph<Function, Callsite> getBackwardDirectedGraph() {
        return this.constructDirectedGraph(false);
    }

    private static void digraphConnect(DiGraph<Function, Callsite> digraph, Function caller, Callsite callsite, Function callee, boolean forward) {
        Function destination;
        Function source;
        if (forward) {
            source = caller;
            destination = callee;
        } else {
            source = callee;
            destination = caller;
        }
        digraph.connect(source, callsite, destination);
    }

    private DiGraph<Function, Callsite> constructDirectedGraph(boolean forward) {
        LinkedDirectedGraph<Function, Callsite> digraph = LinkedDirectedGraph.createWithoutAnnotations();
        for (Function function : this.getAllFunctions()) {
            ((Graph)digraph).createNode(function);
        }
        if (this.computeForwardGraph) {
            for (Function caller : this.getAllFunctions()) {
                for (Callsite callsite : caller.getCallsitesInFunction()) {
                    for (Function callee : callsite.getPossibleTargets()) {
                        CallGraph.digraphConnect(digraph, caller, callsite, callee, forward);
                    }
                }
            }
        } else {
            for (Function callee : this.getAllFunctions()) {
                for (Callsite callsite : callee.getCallsitesPossiblyTargetingFunction()) {
                    Function caller = callsite.getContainingFunction();
                    CallGraph.digraphConnect(digraph, caller, callsite, callee, forward);
                }
            }
        }
        return digraph;
    }

    private DefinitionProvider constructDefinitionProvider(Node externsRoot, Node jsRoot) {
        SimpleDefinitionFinder defFinder = new SimpleDefinitionFinder(this.compiler);
        defFinder.process(externsRoot, jsRoot);
        return defFinder;
    }

    private Collection<DefinitionsRemover.Definition> lookupDefinitionsForTargetsOfCall(Node callsite, DefinitionProvider definitionProvider) {
        Preconditions.checkArgument((callsite.isCall() || callsite.isNew() ? 1 : 0) != 0);
        Node targetExpression = callsite.getFirstChild();
        Collection<DefinitionsRemover.Definition> definitions = definitionProvider.getDefinitionsReferencedAt(targetExpression);
        if (definitions != null && !definitions.isEmpty()) {
            return definitions;
        }
        return null;
    }

    public class Callsite {
        private final Node astNode;
        private boolean hasUnknownTarget = false;
        private boolean hasExternTarget = false;
        private Function containingFunction = null;
        private Collection<Function> possibleTargets;

        private Callsite(Node callsiteAstNode) {
            this.astNode = callsiteAstNode;
        }

        public Node getAstNode() {
            return this.astNode;
        }

        public Function getContainingFunction() {
            return this.containingFunction;
        }

        public Collection<Function> getPossibleTargets() {
            if (CallGraph.this.computeForwardGraph) {
                if (this.possibleTargets != null) {
                    return this.possibleTargets;
                }
                return ImmutableList.of();
            }
            throw new UnsupportedOperationException("Cannot call getPossibleTargets() on a Callsite from a non-forward CallGraph");
        }

        private void addPossibleTarget(Function target) {
            Preconditions.checkState((boolean)CallGraph.this.computeForwardGraph);
            if (this.possibleTargets == null) {
                this.possibleTargets = new LinkedList<Function>();
            }
            this.possibleTargets.add(target);
        }

        public boolean hasUnknownTarget() {
            return this.hasUnknownTarget;
        }

        public boolean hasExternTarget() {
            return this.hasExternTarget;
        }
    }

    public class Function {
        private final Node astNode;
        private boolean isAliased = false;
        private boolean isExposedToCallOrApply = false;
        private Collection<Callsite> callsitesInFunction;
        private Collection<Callsite> callsitesPossiblyTargetingFunction;

        private Function(Node functionAstNode) {
            this.astNode = functionAstNode;
        }

        public boolean isMain() {
            return this == CallGraph.this.mainFunction;
        }

        public Node getAstNode() {
            return this.astNode;
        }

        public Node getBodyNode() {
            if (this.isMain()) {
                return this.astNode;
            }
            return NodeUtil.getFunctionBody(this.astNode);
        }

        public String getName() {
            if (this.isMain()) {
                return CallGraph.MAIN_FUNCTION_NAME;
            }
            return NodeUtil.getFunctionName(this.astNode);
        }

        public Collection<Callsite> getCallsitesInFunction() {
            if (this.callsitesInFunction != null) {
                return this.callsitesInFunction;
            }
            return ImmutableList.of();
        }

        private void addCallsiteInFunction(Callsite callsite) {
            if (this.callsitesInFunction == null) {
                this.callsitesInFunction = new LinkedList<Callsite>();
            }
            this.callsitesInFunction.add(callsite);
        }

        public Collection<Callsite> getCallsitesPossiblyTargetingFunction() {
            if (CallGraph.this.computeBackwardGraph) {
                if (this.callsitesPossiblyTargetingFunction != null) {
                    return this.callsitesPossiblyTargetingFunction;
                }
                return ImmutableList.of();
            }
            throw new UnsupportedOperationException("Cannot call getCallsitesPossiblyTargetingFunction() on a Function from a non-backward CallGraph");
        }

        private void addCallsitePossiblyTargetingFunction(Callsite callsite) {
            Preconditions.checkState((boolean)CallGraph.this.computeBackwardGraph);
            if (this.callsitesPossiblyTargetingFunction == null) {
                this.callsitesPossiblyTargetingFunction = new LinkedList<Callsite>();
            }
            this.callsitesPossiblyTargetingFunction.add(callsite);
        }

        public boolean isAliased() {
            return this.isAliased;
        }

        public boolean isExposedToCallOrApply() {
            return this.isExposedToCallOrApply;
        }
    }
}

