/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.fuzzing;

import com.google.common.collect.Sets;
import com.google.javascript.jscomp.fuzzing.AbstractFuzzer;
import com.google.javascript.jscomp.fuzzing.ExpressionFuzzer;
import com.google.javascript.jscomp.fuzzing.FuzzingContext;
import com.google.javascript.jscomp.fuzzing.Type;
import com.google.javascript.rhino.Node;
import java.util.Arrays;
import java.util.Set;

class ArrayFuzzer
extends AbstractFuzzer {
    ArrayFuzzer(FuzzingContext context) {
        super(context);
    }

    @Override
    protected Node generate(int budget, Set<Type> types) {
        int arraySize;
        Node node = new Node(63);
        if (budget < 1) {
            budget = 1;
        }
        if ((arraySize = this.generateLength(budget - 1)) > 0) {
            Object[] fuzzers = new AbstractFuzzer[arraySize];
            Arrays.fill(fuzzers, new ExpressionFuzzer(this.context));
            Node[] elements = this.distribute(budget - 1, (AbstractFuzzer[])fuzzers);
            for (int i = 0; i < arraySize; ++i) {
                node.addChildToBack(elements[i]);
            }
        }
        return node;
    }

    @Override
    protected boolean isEnough(int budget) {
        return budget >= 1;
    }

    @Override
    protected String getConfigName() {
        return "array";
    }

    @Override
    protected Set<Type> supportedTypes() {
        return Sets.newHashSet((Object[])new Type[]{Type.ARRAY});
    }
}

