/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.parsing.parser.codegeneration;

import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.parsing.parser.IdentifierToken;
import com.google.javascript.jscomp.parsing.parser.LiteralToken;
import com.google.javascript.jscomp.parsing.parser.PredefinedName;
import com.google.javascript.jscomp.parsing.parser.Token;
import com.google.javascript.jscomp.parsing.parser.TokenType;
import com.google.javascript.jscomp.parsing.parser.trees.ArgumentListTree;
import com.google.javascript.jscomp.parsing.parser.trees.ArrayLiteralExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ArrayPatternTree;
import com.google.javascript.jscomp.parsing.parser.trees.BinaryOperatorTree;
import com.google.javascript.jscomp.parsing.parser.trees.BlockTree;
import com.google.javascript.jscomp.parsing.parser.trees.BreakStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.CallExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.CaseClauseTree;
import com.google.javascript.jscomp.parsing.parser.trees.CatchTree;
import com.google.javascript.jscomp.parsing.parser.trees.ClassDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.CommaExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.Comment;
import com.google.javascript.jscomp.parsing.parser.trees.ConditionalExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ContinueStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.DefaultClauseTree;
import com.google.javascript.jscomp.parsing.parser.trees.DefaultParameterTree;
import com.google.javascript.jscomp.parsing.parser.trees.DoWhileStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.EmptyStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.ExpressionStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.FinallyTree;
import com.google.javascript.jscomp.parsing.parser.trees.ForInStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.ForOfStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.ForStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.FormalParameterListTree;
import com.google.javascript.jscomp.parsing.parser.trees.FunctionDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.GetAccessorTree;
import com.google.javascript.jscomp.parsing.parser.trees.IdentifierExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.IfStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.LabelledStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.LiteralExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.MemberExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.MemberLookupExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.NewExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ObjectLiteralExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ObjectPatternFieldTree;
import com.google.javascript.jscomp.parsing.parser.trees.ObjectPatternTree;
import com.google.javascript.jscomp.parsing.parser.trees.ParenExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ParseTree;
import com.google.javascript.jscomp.parsing.parser.trees.ParseTreeType;
import com.google.javascript.jscomp.parsing.parser.trees.PostfixExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ProgramTree;
import com.google.javascript.jscomp.parsing.parser.trees.PropertyNameAssignmentTree;
import com.google.javascript.jscomp.parsing.parser.trees.RestParameterTree;
import com.google.javascript.jscomp.parsing.parser.trees.ReturnStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.SetAccessorTree;
import com.google.javascript.jscomp.parsing.parser.trees.SpreadExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.SpreadPatternElementTree;
import com.google.javascript.jscomp.parsing.parser.trees.SwitchStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.ThisExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ThrowStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.TryStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.UnaryExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.VariableDeclarationListTree;
import com.google.javascript.jscomp.parsing.parser.trees.VariableDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.VariableStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.WhileStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.WithStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.YieldExpressionTree;
import java.util.Arrays;
import java.util.List;

public final class ParseTreeFactory {
    private ParseTreeFactory() {
    }

    public static Token createOperatorToken(TokenType operator) {
        return new Token(operator, null);
    }

    public static IdentifierToken createIdentifierToken(String identifier) {
        return new IdentifierToken(null, identifier);
    }

    public static Token createPropertyNameToken(String propertyName) {
        return ParseTreeFactory.createIdentifierToken(propertyName);
    }

    public static Token createStringLiteralToken(String value) {
        return new LiteralToken(TokenType.STRING, "\"" + value + "\"", null);
    }

    public static Token createBooleanLiteralToken(boolean value) {
        return new Token(value ? TokenType.TRUE : TokenType.FALSE, null);
    }

    public static Token createNullLiteralToken() {
        return new LiteralToken(TokenType.NULL, "null", null);
    }

    public static Token createNumberLiteralToken(Number value) {
        return new LiteralToken(TokenType.NUMBER, value.toString(), null);
    }

    public static ImmutableList<String> createEmptyParameters() {
        return ImmutableList.of();
    }

    public static ImmutableList<String> createParameters(IdentifierToken parameter) {
        return ImmutableList.of((Object)parameter.value);
    }

    public static ImmutableList<String> createParameters(FormalParameterListTree parameters) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ParseTree parameter : parameters.parameters) {
            if (parameter.isRestParameter()) continue;
            builder.add((Object)parameter.asIdentifierExpression().identifierToken.value);
        }
        return builder.build();
    }

    public static ImmutableList<ParseTree> createStatementList(ParseTree ... statements) {
        return ImmutableList.copyOf((Object[])statements);
    }

    public static ImmutableList<ParseTree> createStatementList(List<ParseTree> head, ParseTree tail) {
        ImmutableList.Builder result = new ImmutableList.Builder();
        result.addAll(head);
        result.add((Object)tail);
        return result.build();
    }

    private static FormalParameterListTree createParameterList(ImmutableList<String> formalParameters) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String parameter : formalParameters) {
            builder.add((Object)ParseTreeFactory.createIdentifierExpression(parameter));
        }
        return new FormalParameterListTree(null, (ImmutableList<ParseTree>)builder.build());
    }

    public static FormalParameterListTree createParameterList(IdentifierToken parameter) {
        return new FormalParameterListTree(null, (ImmutableList<ParseTree>)ImmutableList.of((Object)ParseTreeFactory.createIdentifierExpression(parameter)));
    }

    public static IdentifierExpressionTree createParameterReference(int index) {
        return ParseTreeFactory.createIdentifierExpression(PredefinedName.getParameterName(index));
    }

    private static FormalParameterListTree createParameterList(int numberOfParameters, boolean hasRestParams) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int index = 0; index < numberOfParameters; ++index) {
            String parameterName = PredefinedName.getParameterName(index);
            boolean isRestParameter = index == numberOfParameters - 1 && hasRestParams;
            builder.add((Object)(isRestParameter ? ParseTreeFactory.createRestParameter(parameterName) : ParseTreeFactory.createIdentifierExpression(parameterName)));
        }
        return new FormalParameterListTree(null, (ImmutableList<ParseTree>)builder.build());
    }

    public static FormalParameterListTree createParameterList(int numberOfParameters) {
        return ParseTreeFactory.createParameterList(numberOfParameters, false);
    }

    public static FormalParameterListTree createParameterListWithRestParams(int numberOfParameters) {
        return ParseTreeFactory.createParameterList(numberOfParameters, true);
    }

    public static FormalParameterListTree createParameterList(String ... parameters) {
        ImmutableList.Builder parameterList = new ImmutableList.Builder();
        for (String parameter : parameters) {
            parameterList.add((Object)ParseTreeFactory.createIdentifierExpression(parameter));
        }
        return new FormalParameterListTree(null, (ImmutableList<ParseTree>)parameterList.build());
    }

    public static FormalParameterListTree createEmptyParameterList() {
        return new FormalParameterListTree(null, (ImmutableList<ParseTree>)ImmutableList.of());
    }

    private static ImmutableList<ParseTree> createEmptyList() {
        return ImmutableList.of();
    }

    public static ArgumentListTree createArgumentList(ImmutableList<ParseTree> list) {
        return new ArgumentListTree(null, list);
    }

    public static ArgumentListTree createArgumentList(ParseTree ... list) {
        return new ArgumentListTree(null, (ImmutableList<ParseTree>)ImmutableList.copyOf((Object[])list));
    }

    public static ArgumentListTree createArgumentList(int numberOfArguments) {
        return ParseTreeFactory.createArgumentListFromParameterList(ParseTreeFactory.createParameterList(numberOfArguments));
    }

    public static ArgumentListTree createArgumentListFromParameterList(FormalParameterListTree formalParameterList) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (ParseTree parameter : formalParameterList.parameters) {
            if (parameter.isRestParameter()) {
                builder.add((Object)ParseTreeFactory.createSpreadExpression(ParseTreeFactory.createIdentifierExpression(parameter.asRestParameter().identifier)));
                continue;
            }
            builder.add((Object)parameter);
        }
        return new ArgumentListTree(null, (ImmutableList<ParseTree>)builder.build());
    }

    public static ArgumentListTree createEmptyArgumentList() {
        return new ArgumentListTree(null, ParseTreeFactory.createEmptyList());
    }

    public static ArrayLiteralExpressionTree createArrayLiteralExpression(ImmutableList<ParseTree> list) {
        return new ArrayLiteralExpressionTree(null, list);
    }

    public static ArrayLiteralExpressionTree createEmptyArrayLiteralExpression() {
        return ParseTreeFactory.createArrayLiteralExpression(ParseTreeFactory.createEmptyList());
    }

    public static ArrayPatternTree createArrayPattern(ImmutableList<ParseTree> list) {
        return new ArrayPatternTree(null, list);
    }

    public static BinaryOperatorTree createAssignmentExpression(ParseTree lhs, ParseTree rhs) {
        return new BinaryOperatorTree(null, lhs, ParseTreeFactory.createOperatorToken(TokenType.EQUAL), rhs);
    }

    public static BinaryOperatorTree createBinaryOperator(ParseTree left, Token operator, ParseTree right) {
        return new BinaryOperatorTree(null, left, operator, right);
    }

    public static EmptyStatementTree createEmptyStatement() {
        return new EmptyStatementTree(null);
    }

    public static BlockTree createEmptyBlock() {
        return ParseTreeFactory.createBlock(ParseTreeFactory.createEmptyList());
    }

    public static BlockTree createBlock(ImmutableList<ParseTree> statements) {
        return new BlockTree(null, statements);
    }

    public static BlockTree createBlock(ParseTree ... statements) {
        return new BlockTree(null, (ImmutableList<ParseTree>)ImmutableList.copyOf((Object[])statements));
    }

    public static ParseTree createScopedStatements(ImmutableList<ParseTree> statements) {
        return ParseTreeFactory.createScopedBlock(ParseTreeFactory.createBlock(statements));
    }

    public static ParseTree createScopedStatements(ParseTree ... statements) {
        return ParseTreeFactory.createScopedBlock(ParseTreeFactory.createBlock(statements));
    }

    public static ParseTree createScopedBlock(BlockTree block) {
        return ParseTreeFactory.createExpressionStatement(ParseTreeFactory.createScopedExpression(block));
    }

    public static CallExpressionTree createScopedExpression(BlockTree block) {
        return ParseTreeFactory.createCallCall((ParseTree)ParseTreeFactory.createParenExpression(ParseTreeFactory.createFunctionExpression(ParseTreeFactory.createEmptyParameterList(), block)), (ParseTree)ParseTreeFactory.createThisExpression(), new ParseTree[0]);
    }

    public static CallExpressionTree createCallExpression(ParseTree operand, ArgumentListTree arguments) {
        return new CallExpressionTree(null, operand, arguments);
    }

    public static CallExpressionTree createCallExpression(ParseTree operand) {
        return ParseTreeFactory.createCallExpression(operand, ParseTreeFactory.createEmptyArgumentList());
    }

    public static CallExpressionTree createBoundCall(ParseTree function, ParseTree thisTree) {
        return ParseTreeFactory.createCallExpression(ParseTreeFactory.createMemberExpression(function.type == ParseTreeType.FUNCTION_DECLARATION ? ParseTreeFactory.createParenExpression(function) : function, "bind"), ParseTreeFactory.createArgumentList(thisTree));
    }

    public static CallExpressionTree createLookupGetter(String aggregateName, String propertyName) {
        return ParseTreeFactory.createCallExpression(ParseTreeFactory.createMemberExpression(aggregateName, "prototype", "__lookupGetter__"), ParseTreeFactory.createArgumentList(ParseTreeFactory.createStringLiteral(propertyName)));
    }

    public static BreakStatementTree createBreakStatement() {
        return new BreakStatementTree(null, null);
    }

    public static CallExpressionTree createCallCall(ParseTree function, ParseTree thisExpression, ParseTree ... arguments) {
        List<ParseTree> argumentsAsList = Arrays.asList(arguments);
        return ParseTreeFactory.createCallCall(function, thisExpression, argumentsAsList);
    }

    public static CallExpressionTree createCallCall(ParseTree function, ParseTree thisExpression, List<ParseTree> arguments) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)thisExpression);
        builder.addAll(arguments);
        return ParseTreeFactory.createCallExpression(ParseTreeFactory.createMemberExpression(function, "call"), ParseTreeFactory.createArgumentList((ImmutableList<ParseTree>)builder.build()));
    }

    public static ParseTree createCallCallStatement(ParseTree function, ParseTree thisExpression, ParseTree ... arguments) {
        return ParseTreeFactory.createExpressionStatement(ParseTreeFactory.createCallCall(function, thisExpression, arguments));
    }

    public static CaseClauseTree createCaseClause(ParseTree expression, ImmutableList<ParseTree> statements) {
        return new CaseClauseTree(null, expression, statements);
    }

    public static CatchTree createCatch(IdentifierToken exceptionName, ParseTree catchBody) {
        return new CatchTree(null, exceptionName, catchBody);
    }

    public static ClassDeclarationTree createClassDeclaration(IdentifierToken name, ParseTree superClass, ImmutableList<ParseTree> elements) {
        return new ClassDeclarationTree(null, name, false, superClass, elements);
    }

    public static ClassDeclarationTree createClassExpression(IdentifierToken name, ParseTree superClass, ImmutableList<ParseTree> elements) {
        return new ClassDeclarationTree(null, name, true, superClass, elements);
    }

    public static CommaExpressionTree createCommaExpression(ImmutableList<ParseTree> expressions) {
        return new CommaExpressionTree(null, expressions);
    }

    public static ConditionalExpressionTree createConditionalExpression(ParseTree condition, ParseTree left, ParseTree right) {
        return new ConditionalExpressionTree(null, condition, left, right);
    }

    public static ContinueStatementTree createContinueStatement() {
        return new ContinueStatementTree(null, null);
    }

    public static DefaultClauseTree createDefaultClause(ImmutableList<ParseTree> statements) {
        return new DefaultClauseTree(null, statements);
    }

    public static DefaultParameterTree createDefaultParameter(IdentifierExpressionTree identifier, ParseTree expression) {
        return new DefaultParameterTree(null, identifier, expression);
    }

    public static DoWhileStatementTree createDoWhileStatement(ParseTree body, ParseTree condition) {
        return new DoWhileStatementTree(null, body, condition);
    }

    public static ExpressionStatementTree createAssignmentStatement(ParseTree lhs, ParseTree rhs) {
        return ParseTreeFactory.createExpressionStatement(ParseTreeFactory.createAssignmentExpression(lhs, rhs));
    }

    public static ExpressionStatementTree createCallStatement(ParseTree operand, ArgumentListTree arguments) {
        return ParseTreeFactory.createExpressionStatement(ParseTreeFactory.createCallExpression(operand, arguments));
    }

    public static ExpressionStatementTree createCallStatement(ParseTree operand) {
        return ParseTreeFactory.createExpressionStatement(ParseTreeFactory.createCallExpression(operand));
    }

    public static ExpressionStatementTree createExpressionStatement(ParseTree expression) {
        return new ExpressionStatementTree(null, expression);
    }

    public static FinallyTree createFinally(ParseTree block) {
        return new FinallyTree(null, block);
    }

    public static ForOfStatementTree createForEachStatement(VariableDeclarationListTree initializer, ParseTree collection, ParseTree body) {
        return new ForOfStatementTree(null, initializer, collection, body);
    }

    public static ForInStatementTree createForInStatement(ParseTree initializer, ParseTree collection, ParseTree body) {
        return new ForInStatementTree(null, initializer, collection, body);
    }

    public static ForStatementTree createForStatement(ParseTree variables, ParseTree condition, ParseTree increment, ParseTree body) {
        return new ForStatementTree(null, variables, condition, increment, body);
    }

    public static FunctionDeclarationTree createFunctionExpressionFormals(ImmutableList<String> formalParameters, BlockTree functionBody) {
        return ParseTreeFactory.createFunctionExpression(ParseTreeFactory.createParameterList(formalParameters), functionBody);
    }

    public static FunctionDeclarationTree createFunctionExpression(FormalParameterListTree formalParameterList, BlockTree functionBody) {
        return new FunctionDeclarationTree(null, null, false, false, FunctionDeclarationTree.Kind.EXPRESSION, formalParameterList, functionBody);
    }

    public static FunctionDeclarationTree createFunctionDeclaration(IdentifierToken name, FormalParameterListTree formalParameterList, BlockTree functionBody) {
        return new FunctionDeclarationTree(null, name, false, false, FunctionDeclarationTree.Kind.DECLARATION, formalParameterList, functionBody);
    }

    public static FunctionDeclarationTree createFunctionDeclaration(String name, FormalParameterListTree formalParameterList, BlockTree functionBody) {
        return ParseTreeFactory.createFunctionDeclaration(ParseTreeFactory.createIdentifierToken(name), formalParameterList, functionBody);
    }

    public static GetAccessorTree createGetAccessor(String propertyName, boolean isStatic, BlockTree body) {
        return ParseTreeFactory.createGetAccessor(ParseTreeFactory.createPropertyNameToken(propertyName), isStatic, body);
    }

    public static GetAccessorTree createGetAccessor(Token propertyName, boolean isStatic, BlockTree body) {
        return new GetAccessorTree(null, propertyName, isStatic, body);
    }

    public static IdentifierExpressionTree createIdentifierExpression(String identifier) {
        return ParseTreeFactory.createIdentifierExpression(ParseTreeFactory.createIdentifierToken(identifier));
    }

    public static IdentifierExpressionTree createIdentifierExpression(IdentifierToken identifier) {
        return new IdentifierExpressionTree(null, identifier);
    }

    public static IdentifierExpressionTree createUndefinedExpression() {
        return ParseTreeFactory.createIdentifierExpression("undefined");
    }

    public static IfStatementTree createIfStatement(ParseTree condition, ParseTree ifClause) {
        return ParseTreeFactory.createIfStatement(condition, ifClause, null);
    }

    public static IfStatementTree createIfStatement(ParseTree condition, ParseTree ifClause, ParseTree elseClause) {
        return new IfStatementTree(null, condition, ifClause, elseClause);
    }

    public static LabelledStatementTree createLabelledStatement(IdentifierToken name, ParseTree statement) {
        return new LabelledStatementTree(null, name, statement);
    }

    public static ParseTree createStringLiteral(String value) {
        return new LiteralExpressionTree(null, ParseTreeFactory.createStringLiteralToken(value));
    }

    public static ParseTree createBooleanLiteral(boolean value) {
        return new LiteralExpressionTree(null, ParseTreeFactory.createBooleanLiteralToken(value));
    }

    public static ParseTree createTrueLiteral() {
        return ParseTreeFactory.createBooleanLiteral(true);
    }

    public static ParseTree createFalseLiteral() {
        return ParseTreeFactory.createBooleanLiteral(false);
    }

    public static ParseTree createNullLiteral() {
        return new LiteralExpressionTree(null, ParseTreeFactory.createNullLiteralToken());
    }

    public static ParseTree createNumberLiteral(Number value) {
        return new LiteralExpressionTree(null, ParseTreeFactory.createNumberLiteralToken(value));
    }

    public static MemberExpressionTree createMemberExpression(IdentifierExpressionTree operand, String memberName, String ... memberNames) {
        MemberExpressionTree tree = ParseTreeFactory.createMemberExpression((ParseTree)operand, memberName);
        for (String name : memberNames) {
            tree = ParseTreeFactory.createMemberExpression((ParseTree)tree, name);
        }
        return tree;
    }

    public static MemberExpressionTree createMemberExpression(String operandName, String memberName, String ... memberNames) {
        return ParseTreeFactory.createMemberExpression(ParseTreeFactory.createIdentifierExpression(operandName), memberName, memberNames);
    }

    public static MemberExpressionTree createMemberExpression(ParseTree operand, IdentifierToken memberName) {
        return new MemberExpressionTree(null, operand, memberName);
    }

    public static MemberExpressionTree createMemberExpression(ParseTree operand, String memberName) {
        return ParseTreeFactory.createMemberExpression(operand, ParseTreeFactory.createIdentifierToken(memberName));
    }

    public static MemberLookupExpressionTree createMemberLookupExpression(ParseTree operand, ParseTree memberExpression) {
        return new MemberLookupExpressionTree(null, operand, memberExpression);
    }

    public static MemberExpressionTree createThisExpression(IdentifierToken memberName) {
        return ParseTreeFactory.createMemberExpression((ParseTree)ParseTreeFactory.createThisExpression(), memberName);
    }

    public static MemberExpressionTree createThisExpression(String memberName) {
        return ParseTreeFactory.createMemberExpression((ParseTree)ParseTreeFactory.createThisExpression(), memberName);
    }

    public static NewExpressionTree createNewExpression(ParseTree operand, ArgumentListTree arguments) {
        return new NewExpressionTree(null, operand, arguments);
    }

    public static ParseTree createObjectFreeze(ParseTree value) {
        return ParseTreeFactory.createCallExpression(ParseTreeFactory.createMemberExpression("Object", "freeze", new String[0]), ParseTreeFactory.createArgumentList(value));
    }

    public static ObjectLiteralExpressionTree createObjectLiteralExpression(ParseTree ... propertyNameAndValues) {
        return ParseTreeFactory.createObjectLiteralExpression((ImmutableList<ParseTree>)ImmutableList.copyOf((Object[])propertyNameAndValues));
    }

    public static ObjectLiteralExpressionTree createObjectLiteralExpression(ImmutableList<ParseTree> propertyNameAndValues) {
        return new ObjectLiteralExpressionTree(null, propertyNameAndValues);
    }

    public static ObjectPatternTree createObjectPattern(ImmutableList<ParseTree> list) {
        return new ObjectPatternTree(null, list);
    }

    public static ObjectPatternFieldTree createObjectPatternField(IdentifierToken identifier, ParseTree element) {
        return new ObjectPatternFieldTree(null, identifier, element);
    }

    public static ParenExpressionTree createParenExpression(ParseTree expression) {
        return new ParenExpressionTree(null, expression);
    }

    public static PostfixExpressionTree createPostfixExpression(ParseTree operand, Token operator) {
        return new PostfixExpressionTree(null, operand, operator);
    }

    public static ProgramTree createProgramTree(ImmutableList<ParseTree> sourceElements) {
        return new ProgramTree(null, sourceElements, (ImmutableList<Comment>)ImmutableList.of());
    }

    public static PropertyNameAssignmentTree createPropertyNameAssignment(String identifier, ParseTree value) {
        return ParseTreeFactory.createPropertyNameAssignment(ParseTreeFactory.createIdentifierToken(identifier), value);
    }

    public static PropertyNameAssignmentTree createPropertyNameAssignment(Token propertyName, ParseTree value) {
        return new PropertyNameAssignmentTree(null, propertyName, value);
    }

    public static RestParameterTree createRestParameter(String identifier) {
        return ParseTreeFactory.createRestParameter(new IdentifierToken(null, identifier));
    }

    public static RestParameterTree createRestParameter(IdentifierToken identifier) {
        return new RestParameterTree(null, identifier);
    }

    public static ReturnStatementTree createReturnStatement(ParseTree expression) {
        return new ReturnStatementTree(null, expression);
    }

    public static YieldExpressionTree createYieldStatement(ParseTree expression) {
        return new YieldExpressionTree(null, false, expression);
    }

    public static SetAccessorTree createSetAccessor(String propertyName, boolean isStatic, IdentifierToken parameter, BlockTree body) {
        return ParseTreeFactory.createSetAccessor(ParseTreeFactory.createPropertyNameToken(propertyName), isStatic, parameter, body);
    }

    public static SetAccessorTree createSetAccessor(String propertyName, boolean isStatic, String parameter, BlockTree body) {
        return ParseTreeFactory.createSetAccessor(propertyName, isStatic, ParseTreeFactory.createIdentifierToken(parameter), body);
    }

    public static SetAccessorTree createSetAccessor(Token propertyName, boolean isStatic, IdentifierToken parameter, BlockTree body) {
        return new SetAccessorTree(null, propertyName, isStatic, parameter, body);
    }

    public static SpreadExpressionTree createSpreadExpression(ParseTree expression) {
        return new SpreadExpressionTree(null, expression);
    }

    public static SpreadPatternElementTree createSpreadPatternElement(ParseTree lvalue) {
        return new SpreadPatternElementTree(null, lvalue);
    }

    public static SwitchStatementTree createSwitchStatement(ParseTree expression, ImmutableList<ParseTree> caseClauses) {
        return new SwitchStatementTree(null, expression, caseClauses);
    }

    public static ThisExpressionTree createThisExpression() {
        return new ThisExpressionTree(null);
    }

    public static ThrowStatementTree createThrowStatement(ParseTree value) {
        return new ThrowStatementTree(null, value);
    }

    public static TryStatementTree createTryFinallyStatement(ParseTree body, ParseTree finallyBlock) {
        return ParseTreeFactory.createTryStatement(body, null, finallyBlock);
    }

    public static TryStatementTree createTryStatement(ParseTree body, ParseTree catchBlock, ParseTree finallyBlock) {
        return new TryStatementTree(null, body, catchBlock, finallyBlock);
    }

    public static UnaryExpressionTree createUnaryExpression(Token operator, ParseTree operand) {
        return new UnaryExpressionTree(null, operator, operand);
    }

    public static VariableDeclarationListTree createVariableDeclarationList(TokenType binding, IdentifierToken identifier, ParseTree initializer) {
        return ParseTreeFactory.createVariableDeclarationList(binding, (ImmutableList<VariableDeclarationTree>)ImmutableList.of((Object)ParseTreeFactory.createVariableDeclaration(identifier, initializer)));
    }

    public static VariableDeclarationListTree createVariableDeclarationList(TokenType binding, String identifier, ParseTree initializer) {
        return ParseTreeFactory.createVariableDeclarationList(binding, ParseTreeFactory.createIdentifierToken(identifier), initializer);
    }

    public static VariableDeclarationListTree createVariableDeclarationList(TokenType binding, ImmutableList<VariableDeclarationTree> declarations) {
        return new VariableDeclarationListTree(null, binding, declarations);
    }

    public static VariableDeclarationTree createVariableDeclaration(String identifier, ParseTree initializer) {
        return ParseTreeFactory.createVariableDeclaration(ParseTreeFactory.createIdentifierExpression(identifier), initializer);
    }

    public static VariableDeclarationTree createVariableDeclaration(ParseTree lvalue, ParseTree initializer) {
        return new VariableDeclarationTree(null, lvalue, initializer);
    }

    public static VariableDeclarationTree createVariableDeclaration(IdentifierToken name, ParseTree initializer) {
        return new VariableDeclarationTree(null, ParseTreeFactory.createIdentifierExpression(name), initializer);
    }

    public static VariableStatementTree createVariableStatement(TokenType binding, IdentifierToken identifier, ParseTree initializer) {
        VariableDeclarationListTree list = ParseTreeFactory.createVariableDeclarationList(binding, identifier, initializer);
        return ParseTreeFactory.createVariableStatement(list);
    }

    public static VariableStatementTree createVariableStatement(TokenType binding, String identifier, ParseTree initializer) {
        VariableDeclarationListTree list = ParseTreeFactory.createVariableDeclarationList(binding, identifier, initializer);
        return ParseTreeFactory.createVariableStatement(list);
    }

    public static VariableStatementTree createVariableStatement(VariableDeclarationListTree list) {
        return new VariableStatementTree(null, list);
    }

    public static WhileStatementTree createWhileStatement(ParseTree condition, ParseTree body) {
        return new WhileStatementTree(null, condition, body);
    }

    public static WithStatementTree createWithStatement(ParseTree expression, ParseTree body) {
        return new WithStatementTree(null, expression, body);
    }

    public static ExpressionStatementTree createAssignStateStatement(int state) {
        return ParseTreeFactory.createAssignmentStatement(ParseTreeFactory.createIdentifierExpression("$state"), ParseTreeFactory.createNumberLiteral(state));
    }
}

