/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.collect.Maps;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.RecordType;
import java.util.Collections;
import java.util.HashMap;

public class RecordTypeBuilder {
    private boolean isEmpty = true;
    private boolean isDeclared = true;
    private final JSTypeRegistry registry;
    private final HashMap<String, RecordProperty> properties = Maps.newHashMap();

    public RecordTypeBuilder(JSTypeRegistry registry) {
        this.registry = registry;
    }

    void setSynthesized(boolean synthesized) {
        this.isDeclared = !synthesized;
    }

    public RecordTypeBuilder addProperty(String name, JSType type, Node propertyNode) {
        this.isEmpty = false;
        if (this.properties.containsKey(name)) {
            return null;
        }
        this.properties.put(name, new RecordProperty(type, propertyNode));
        return this;
    }

    public JSType build() {
        if (this.isEmpty) {
            return this.registry.getNativeObjectType(JSTypeNative.OBJECT_TYPE);
        }
        return new RecordType(this.registry, Collections.unmodifiableMap(this.properties), this.isDeclared);
    }

    static class RecordProperty {
        private final JSType type;
        private final Node propertyNode;

        RecordProperty(JSType type, Node propertyNode) {
            this.type = type;
            this.propertyNode = propertyNode;
        }

        public JSType getType() {
            return this.type;
        }

        public Node getPropertyNode() {
            return this.propertyNode;
        }
    }
}

