/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.clients.mapsengine.geojson;

import com.google.api.services.mapsengine.model.Feature;
import com.google.api.services.mapsengine.model.GeoJsonGeometry;
import com.google.api.services.mapsengine.model.GeoJsonMultiPolygon;
import com.google.maps.clients.mapsengine.geojson.Geometry;
import com.google.maps.clients.mapsengine.geojson.Polygon;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MultiPolygon
extends Geometry {
    protected final List<Polygon> polygons;

    public MultiPolygon(List<Polygon> polygons) {
        this.polygons = polygons;
    }

    public MultiPolygon(Feature feature) {
        GeoJsonGeometry geometry = feature.getGeometry();
        if (!(geometry instanceof GeoJsonMultiPolygon)) {
            throw new IllegalArgumentException("Feature is not a MultiPolygon: " + geometry.getType());
        }
        GeoJsonMultiPolygon multiPolygon = (GeoJsonMultiPolygon)geometry;
        List rawPoints = multiPolygon.getCoordinates();
        this.polygons = new ArrayList<Polygon>(rawPoints.size());
        for (List polygonPoints : rawPoints) {
            this.polygons.add(Polygon.fromRawPoints(polygonPoints));
        }
    }

    @Override
    public Feature asFeature(Map<String, Object> properties) {
        if (properties == null) {
            throw new IllegalArgumentException("Properties are required, even if empty");
        }
        ArrayList<List<List<List<Double>>>> coords = new ArrayList<List<List<List<Double>>>>(this.polygons.size());
        for (Polygon polygon : this.polygons) {
            coords.add(polygon.toRawPoints());
        }
        GeoJsonMultiPolygon geometry = new GeoJsonMultiPolygon();
        geometry.setCoordinates(coords);
        Feature feature = new Feature();
        feature.setType("Feature");
        feature.setProperties(properties);
        feature.setGeometry((GeoJsonGeometry)geometry);
        return feature;
    }

    public List<Polygon> getPolygons() {
        return this.polygons;
    }
}

