/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.clients.mapsengine.geojson;

import com.google.api.services.mapsengine.model.Feature;
import com.google.api.services.mapsengine.model.GeoJsonGeometry;
import com.google.api.services.mapsengine.model.GeoJsonPoint;
import com.google.maps.clients.mapsengine.geojson.Geometry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Point
extends Geometry {
    public final double latitude;
    public final double longitude;
    public final double altitude;
    public final boolean hasAltitude;

    public Point(double lat, double lng) {
        if (lat < -90.0 || lat > 90.0) {
            throw new IllegalArgumentException("Latitude is out of bounds");
        }
        if (lng < -180.0 || lng > 180.0) {
            throw new IllegalArgumentException("Longitude is out of bounds");
        }
        this.latitude = lat;
        this.longitude = lng;
        this.hasAltitude = false;
        this.altitude = 0.0;
    }

    public Point(double lat, double lng, double alt) {
        if (lat < -90.0 || lat > 90.0) {
            throw new IllegalArgumentException("Latitude is out of bounds");
        }
        if (lng < -180.0 || lng > 180.0) {
            throw new IllegalArgumentException("Longitude is out of bounds");
        }
        this.latitude = lat;
        this.longitude = lng;
        this.altitude = alt;
        this.hasAltitude = true;
    }

    public Point(Feature feature) {
        GeoJsonGeometry geometry = feature.getGeometry();
        if (!(geometry instanceof GeoJsonPoint)) {
            throw new IllegalArgumentException("Feature is not a Point: " + geometry.getType());
        }
        GeoJsonPoint point = (GeoJsonPoint)geometry;
        List rawPoints = point.getCoordinates();
        if (rawPoints.size() < 2) {
            throw new IllegalArgumentException("Feature must have at least 2 values forming a co-ordinate point");
        }
        this.latitude = (Double)rawPoints.get(1);
        this.longitude = (Double)rawPoints.get(0);
        if (rawPoints.size() > 2) {
            this.altitude = (Double)rawPoints.get(2);
            this.hasAltitude = true;
        } else {
            this.altitude = 0.0;
            this.hasAltitude = false;
        }
    }

    public Point(List<Double> rawPoints) {
        if (rawPoints.size() < 2) {
            throw new IllegalArgumentException("Feature must have at least 2 values forming a co-ordinate point");
        }
        this.latitude = rawPoints.get(1);
        this.longitude = rawPoints.get(0);
        if (rawPoints.size() > 2) {
            this.altitude = rawPoints.get(2);
            this.hasAltitude = true;
        } else {
            this.altitude = 0.0;
            this.hasAltitude = false;
        }
    }

    @Override
    public Feature asFeature(Map<String, Object> properties) {
        if (properties == null) {
            throw new IllegalArgumentException("Properties are required, even if empty");
        }
        ArrayList<Double> coords = new ArrayList<Double>();
        coords.add(this.longitude);
        coords.add(this.latitude);
        if (this.hasAltitude()) {
            coords.add(this.altitude);
        }
        GeoJsonPoint geometry = new GeoJsonPoint();
        geometry.setCoordinates(coords);
        Feature feature = new Feature();
        feature.setType("Feature");
        feature.setProperties(properties);
        feature.setGeometry((GeoJsonGeometry)geometry);
        return feature;
    }

    public List<Double> toCoordinates() {
        ArrayList<Double> coords = new ArrayList<Double>();
        coords.add(this.longitude);
        coords.add(this.latitude);
        if (this.hasAltitude()) {
            coords.add(this.altitude);
        }
        return coords;
    }

    public boolean hasAltitude() {
        return this.hasAltitude;
    }
}

