/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.clients;

import com.google.api.client.http.HttpBackOffUnsuccessfulResponseHandler;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.gson.GsonFactory;
import com.google.maps.clients.ApiErrorResponseJson;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;

public class RateLimitedBackOffRequired
implements HttpBackOffUnsuccessfulResponseHandler.BackOffRequired {
    protected static final List<String> QUOTA_EXCEEDED_REASONS = Arrays.asList("rateLimitExceeded", "userRateLimitExceeded");
    private static final List<Integer> RETRY_ERROR_CODES = Arrays.asList(500, 503, 504);
    protected String responseBody;
    private JsonFactory jsonFactory;

    public RateLimitedBackOffRequired() {
        this.jsonFactory = new GsonFactory();
    }

    public RateLimitedBackOffRequired(JsonFactory jsonFactory) {
        this.jsonFactory = jsonFactory;
    }

    public boolean isRequired(HttpResponse httpResponse) {
        try {
            String reason;
            if (RETRY_ERROR_CODES.contains(httpResponse.getStatusCode())) {
                this.responseBody = null;
                return true;
            }
            Scanner scanner = new Scanner(httpResponse.getContent(), httpResponse.getContentCharset().toString()).useDelimiter("\\A");
            this.responseBody = scanner.next();
            if (this.responseBody == null || this.responseBody.isEmpty()) {
                return false;
            }
            JsonObjectParser jsonParser = this.jsonFactory.createJsonObjectParser();
            ApiErrorResponseJson apiError = (ApiErrorResponseJson)jsonParser.parseAndClose((InputStream)new ByteArrayInputStream(this.responseBody.getBytes()), httpResponse.getContentCharset(), ApiErrorResponseJson.class);
            return apiError != null && apiError.error != null && apiError.error.errors != null && apiError.error.errors.size() == 1 && QUOTA_EXCEEDED_REASONS.contains(reason = apiError.error.errors.get((int)0).reason);
        }
        catch (IOException e) {
            return false;
        }
    }
}

