/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.clients.mapsengine.geojson;

import com.google.api.services.mapsengine.model.Feature;
import com.google.api.services.mapsengine.model.GeoJsonGeometry;
import com.google.api.services.mapsengine.model.GeoJsonMultiPoint;
import com.google.maps.clients.mapsengine.geojson.Geometry;
import com.google.maps.clients.mapsengine.geojson.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MultiPoint
extends Geometry {
    protected final List<Point> points;

    public MultiPoint(List<Point> points) {
        this.points = points;
    }

    public MultiPoint(Feature feature) throws IllegalArgumentException {
        GeoJsonGeometry geometry = feature.getGeometry();
        if (!(geometry instanceof GeoJsonMultiPoint)) {
            throw new IllegalArgumentException("Feature is not a MultiPoint: " + geometry.getType());
        }
        GeoJsonMultiPoint multiPoint = (GeoJsonMultiPoint)geometry;
        List rawPoints = multiPoint.getCoordinates();
        this.points = new ArrayList<Point>(rawPoints.size());
        for (List rawPoint : rawPoints) {
            this.points.add(new Point(rawPoint));
        }
    }

    public List<Point> getPoints() {
        return this.points;
    }

    @Override
    public Feature asFeature(Map<String, Object> properties) {
        if (properties == null) {
            throw new IllegalArgumentException("Properties are required, even if empty");
        }
        ArrayList<List<Double>> coords = new ArrayList<List<Double>>(this.points.size());
        for (Point p : this.points) {
            coords.add(p.toCoordinates());
        }
        GeoJsonMultiPoint geometry = new GeoJsonMultiPoint();
        geometry.setCoordinates(coords);
        Feature feature = new Feature();
        feature.setType("Feature");
        feature.setGeometry((GeoJsonGeometry)geometry);
        feature.setProperties(properties);
        return feature;
    }
}

