/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.processing;

import com.googlecode.androidannotations.annotations.AfterTextChange;
import com.googlecode.androidannotations.helper.APTCodeModelHelper;
import com.googlecode.androidannotations.helper.TextWatcherHelper;
import com.googlecode.androidannotations.processing.DecoratingElementProcessor;
import com.googlecode.androidannotations.processing.EBeanHolder;
import com.googlecode.androidannotations.processing.TextWatcherHolder;
import com.googlecode.androidannotations.rclass.IRClass;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JVar;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

public class AfterTextChangeProcessor
implements DecoratingElementProcessor {
    private final TextWatcherHelper helper;
    private final APTCodeModelHelper codeModelHelper = new APTCodeModelHelper();

    public AfterTextChangeProcessor(ProcessingEnvironment processingEnv, IRClass rClass) {
        this.helper = new TextWatcherHelper(processingEnv, this.getTarget(), rClass, this.codeModelHelper);
    }

    @Override
    public Class<? extends Annotation> getTarget() {
        return AfterTextChange.class;
    }

    @Override
    public void process(Element element, JCodeModel codeModel, EBeanHolder holder) {
        String methodName = element.getSimpleName().toString();
        ExecutableElement executableElement = (ExecutableElement)element;
        List<? extends VariableElement> parameters = executableElement.getParameters();
        int editableParameterPosition = -1;
        int viewParameterPosition = -1;
        TypeMirror viewParameterType = null;
        for (int i = 0; i < parameters.size(); ++i) {
            VariableElement parameter = parameters.get(i);
            TypeMirror parameterType = parameter.asType();
            if ("android.text.Editable".equals(((Object)parameterType).toString())) {
                editableParameterPosition = i;
                continue;
            }
            TypeMirror textViewType = this.helper.typeElementFromQualifiedName("android.widget.TextView").asType();
            if (!this.helper.isSubtype(parameterType, textViewType)) continue;
            viewParameterPosition = i;
            viewParameterType = parameterType;
        }
        List<JFieldRef> idsRefs = this.helper.extractAnnotationFieldRefs(holder, element, IRClass.Res.ID, true);
        for (JFieldRef idRef : idsRefs) {
            TextWatcherHolder textWatcherHolder = this.helper.getOrCreateListener(codeModel, holder, idRef, viewParameterType);
            JMethod methodToCall = textWatcherHolder.afterTextChangedMethod;
            JBlock previousBody = this.codeModelHelper.removeBody(methodToCall);
            JBlock methodBody = methodToCall.body();
            methodBody.add(previousBody);
            JFieldRef activityRef = holder.generatedClass.staticRef("this");
            JInvocation textChangeCall = methodBody.invoke((JExpression)activityRef, methodName);
            for (int i = 0; i < parameters.size(); ++i) {
                if (i == editableParameterPosition) {
                    JVar afterTextChangeEditableParam = this.codeModelHelper.findParameterByName(methodToCall, "s");
                    textChangeCall.arg(afterTextChangeEditableParam);
                    continue;
                }
                if (i != viewParameterPosition) continue;
                JVar viewParameter = textWatcherHolder.viewVariable;
                textChangeCall.arg(viewParameter);
            }
        }
    }
}

