/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.processing;

import com.googlecode.androidannotations.annotations.EBean;
import com.googlecode.androidannotations.api.Scope;
import com.googlecode.androidannotations.helper.APTCodeModelHelper;
import com.googlecode.androidannotations.processing.EBeanHolder;
import com.googlecode.androidannotations.processing.EBeansHolder;
import com.googlecode.androidannotations.processing.GeneratingElementProcessor;
import com.sun.codemodel.ClassType;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JVar;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;

public class EBeanProcessor
implements GeneratingElementProcessor {
    public static final String GET_INSTANCE_METHOD_NAME = "getInstance_";

    @Override
    public Class<? extends Annotation> getTarget() {
        return EBean.class;
    }

    @Override
    public void process(Element element, JCodeModel codeModel, EBeansHolder eBeansHolder) throws Exception {
        TypeElement typeElement = (TypeElement)element;
        String eBeanQualifiedName = typeElement.getQualifiedName().toString();
        String generatedBeanQualifiedName = eBeanQualifiedName + "_";
        JDefinedClass generatedClass = codeModel._class(9, generatedBeanQualifiedName, ClassType.CLASS);
        EBeanHolder holder = eBeansHolder.create(element, this.getTarget(), generatedClass);
        JClass eBeanClass = codeModel.directClass(eBeanQualifiedName);
        holder.generatedClass._extends(eBeanClass);
        EBeansHolder.Classes classes = holder.classes();
        JFieldVar contextField = holder.generatedClass.field(4, classes.CONTEXT, "context_");
        holder.contextRef = contextField;
        holder.afterSetContentView = holder.generatedClass.method(1, codeModel.VOID, "afterSetContentView_");
        JBlock afterSetContentViewBody = holder.afterSetContentView.body();
        afterSetContentViewBody._if(holder.contextRef._instanceof(classes.ACTIVITY).not())._then()._return();
        JMethod findViewById = holder.generatedClass.method(1, classes.VIEW, "findViewById");
        JVar idParam = findViewById.param(codeModel.INT, "id");
        findViewById.javadoc().add("You should check that context is an activity before calling this method");
        JBlock findViewByIdBody = findViewById.body();
        JVar activityVar = findViewByIdBody.decl(classes.ACTIVITY, "activity_", JExpr.cast(classes.ACTIVITY, holder.contextRef));
        findViewByIdBody._return(activityVar.invoke(findViewById).arg(idParam));
        holder.init = holder.generatedClass.method(4, codeModel.VOID, "init_");
        holder.init.annotate(SuppressWarnings.class).param("value", "all");
        APTCodeModelHelper helper = new APTCodeModelHelper();
        holder.initIfActivityBody = helper.ifContextInstanceOfActivity(holder, holder.init.body());
        holder.initActivityRef = helper.castContextToActivity(holder, holder.initIfActivityBody);
        JMethod constructor = holder.generatedClass.constructor(4);
        JVar constructorContextParam = constructor.param(classes.CONTEXT, "context");
        JBlock constructorBody = constructor.body();
        List<ExecutableElement> constructors = ElementFilter.constructorsIn(element.getEnclosedElements());
        ExecutableElement superConstructor = constructors.get(0);
        if (superConstructor.getParameters().size() == 1) {
            constructorBody.invoke("super").arg(constructorContextParam);
        }
        constructorBody.assign(contextField, constructorContextParam);
        constructorBody.invoke(holder.init);
        EBean eBeanAnnotation = element.getAnnotation(EBean.class);
        Scope eBeanScope = eBeanAnnotation.scope();
        boolean hasSingletonScope = eBeanScope == Scope.Singleton;
        JMethod factoryMethod = holder.generatedClass.method(17, holder.generatedClass, GET_INSTANCE_METHOD_NAME);
        JVar factoryMethodContextParam = factoryMethod.param(classes.CONTEXT, "context");
        JBlock factoryMethodBody = factoryMethod.body();
        if (hasSingletonScope) {
            JFieldVar instanceField = holder.generatedClass.field(20, holder.generatedClass, "instance_");
            factoryMethodBody._if(instanceField.eq(JExpr._null()))._then().assign(instanceField, JExpr._new(holder.generatedClass).arg(factoryMethodContextParam.invoke("getApplicationContext")));
            factoryMethodBody._return(instanceField);
        } else {
            factoryMethodBody._return(JExpr._new(holder.generatedClass).arg(factoryMethodContextParam));
        }
        JMethod rebindMethod = holder.generatedClass.method(1, codeModel.VOID, "rebind");
        JVar contextParam = rebindMethod.param(classes.CONTEXT, "context");
        if (!hasSingletonScope) {
            JBlock body = rebindMethod.body();
            body.assign(contextField, contextParam);
            body.invoke(holder.init);
        }
    }
}

