/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.validation;

import com.googlecode.androidannotations.model.AnnotationElements;
import com.googlecode.androidannotations.model.AnnotationElementsHolder;
import com.googlecode.androidannotations.validation.ElementValidator;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;

public class ModelValidator {
    private List<ElementValidator> validators = new ArrayList<ElementValidator>();

    public void register(ElementValidator validator) {
        this.validators.add(validator);
    }

    public AnnotationElements validate(AnnotationElementsHolder extractedModel) {
        AnnotationElementsHolder validatedElements = extractedModel.validatingHolder();
        for (ElementValidator validator : this.validators) {
            Class<? extends Annotation> target = validator.getTarget();
            Set<? extends Element> annotatedElements = extractedModel.getRootAnnotatedElements(target.getName());
            HashSet<Element> validatedAnnotatedElements = new HashSet<Element>();
            validatedElements.putRootAnnotatedElements(target.getName(), validatedAnnotatedElements);
            for (Element element : annotatedElements) {
                if (!validator.validate(element, validatedElements)) continue;
                validatedAnnotatedElements.add(element);
            }
        }
        return validatedElements;
    }
}

