/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.helper;

import com.googlecode.androidannotations.helper.TargetAnnotationHelper;
import com.googlecode.androidannotations.validation.IsValid;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;

public class RestAnnotationHelper
extends TargetAnnotationHelper {
    private static final Pattern NAMES_PATTERN = Pattern.compile("\\{([^/]+?)\\}");

    public RestAnnotationHelper(ProcessingEnvironment processingEnv, Class<? extends Annotation> target) {
        super(processingEnv, target);
    }

    public void urlVariableNamesExistInParameters(ExecutableElement element, List<String> variableNames, IsValid valid) {
        List<? extends VariableElement> parameters = element.getParameters();
        ArrayList<String> parametersName = new ArrayList<String>();
        for (VariableElement variableElement : parameters) {
            parametersName.add(variableElement.getSimpleName().toString());
        }
        for (String string : variableNames) {
            if (parametersName.contains(string)) continue;
            valid.invalidate();
            this.printAnnotationError(element, "%s annotated method has an url variable which name could not be found in the method parameters: " + string);
            return;
        }
    }

    public void urlVariableNamesExistInParametersAndHasNoOneMoreParameter(ExecutableElement element, IsValid valid) {
        if (valid.isValid()) {
            List<? extends VariableElement> parameters;
            List<String> variableNames = this.extractUrlVariableNames(element);
            this.urlVariableNamesExistInParameters(element, variableNames, valid);
            if (valid.isValid() && (parameters = element.getParameters()).size() > variableNames.size()) {
                valid.invalidate();
                this.printAnnotationError(element, "%s annotated method has only url variables in the method parameters");
            }
        }
    }

    public void urlVariableNamesExistInParametersAndHasOnlyOneMoreParameter(ExecutableElement element, IsValid valid) {
        if (valid.isValid()) {
            List<? extends VariableElement> parameters;
            List<String> variableNames = this.extractUrlVariableNames(element);
            this.urlVariableNamesExistInParameters(element, variableNames, valid);
            if (valid.isValid() && (parameters = element.getParameters()).size() > variableNames.size() + 1) {
                valid.invalidate();
                this.printAnnotationError(element, "%s annotated method has more than one entity parameter");
            }
        }
    }

    public List<String> extractUrlVariableNames(ExecutableElement element) {
        boolean hasValueInAnnotation;
        ArrayList<String> variableNames = new ArrayList<String>();
        String uriTemplate = (String)this.extractAnnotationValueParameter(element);
        boolean bl = hasValueInAnnotation = uriTemplate != null;
        if (hasValueInAnnotation) {
            Matcher m = NAMES_PATTERN.matcher(uriTemplate);
            while (m.find()) {
                variableNames.add(m.group(1));
            }
        }
        return variableNames;
    }
}

