/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.model;

import com.googlecode.androidannotations.annotations.res.AnimationRes;
import com.googlecode.androidannotations.annotations.res.BooleanRes;
import com.googlecode.androidannotations.annotations.res.ColorRes;
import com.googlecode.androidannotations.annotations.res.ColorStateListRes;
import com.googlecode.androidannotations.annotations.res.DimensionPixelOffsetRes;
import com.googlecode.androidannotations.annotations.res.DimensionPixelSizeRes;
import com.googlecode.androidannotations.annotations.res.DimensionRes;
import com.googlecode.androidannotations.annotations.res.DrawableRes;
import com.googlecode.androidannotations.annotations.res.HtmlRes;
import com.googlecode.androidannotations.annotations.res.IntArrayRes;
import com.googlecode.androidannotations.annotations.res.IntegerRes;
import com.googlecode.androidannotations.annotations.res.LayoutRes;
import com.googlecode.androidannotations.annotations.res.MovieRes;
import com.googlecode.androidannotations.annotations.res.StringArrayRes;
import com.googlecode.androidannotations.annotations.res.StringRes;
import com.googlecode.androidannotations.annotations.res.TextArrayRes;
import com.googlecode.androidannotations.annotations.res.TextRes;
import com.googlecode.androidannotations.rclass.IRClass;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import javax.lang.model.element.Element;

public enum AndroidRes {
    STRING(IRClass.Res.STRING, StringRes.class, "getString", "java.lang.String"),
    STRING_ARRAY(IRClass.Res.ARRAY, StringArrayRes.class, "getStringArray", "java.lang.String[]"),
    ANIMATION(IRClass.Res.ANIM, AnimationRes.class, "getAnimation", "android.content.res.XmlResourceParser", "android.view.animation.Animation"),
    HTML(IRClass.Res.STRING, HtmlRes.class, "getString", "java.lang.CharSequence", "android.text.Spanned"),
    BOOLEAN(IRClass.Res.BOOL, BooleanRes.class, "getBoolean", "java.lang.Boolean", "boolean"),
    COLOR_STATE_LIST(IRClass.Res.COLOR, ColorStateListRes.class, "getColorStateList", "android.content.res.ColorStateList"),
    DIMENSION(IRClass.Res.DIMEN, DimensionRes.class, "getDimension", "java.lang.Float", "float"),
    DIMENSION_PIXEL_OFFSET(IRClass.Res.DIMEN, DimensionPixelOffsetRes.class, "getDimensionPixelOffset", "java.lang.Integer", "int"),
    DIMENSION_PIXEL_SIZE(IRClass.Res.DIMEN, DimensionPixelSizeRes.class, "getDimensionPixelSize", "java.lang.Integer", "int"),
    DRAWABLE(IRClass.Res.DRAWABLE, DrawableRes.class, "getDrawable", "android.graphics.drawable.Drawable"),
    INT_ARRAY(IRClass.Res.ARRAY, IntArrayRes.class, "getIntArray", "int[]"),
    INTEGER(IRClass.Res.INTEGER, IntegerRes.class, "getInteger", "java.lang.Integer", "int"),
    LAYOUT(IRClass.Res.LAYOUT, LayoutRes.class, "getLayout", "android.content.res.XmlResourceParser"),
    MOVIE(IRClass.Res.MOVIE, MovieRes.class, "getMovie", "android.graphics.Movie"),
    TEXT(IRClass.Res.STRING, TextRes.class, "getText", "java.lang.CharSequence"),
    TEXT_ARRAY(IRClass.Res.ARRAY, TextArrayRes.class, "getTextArray", "java.lang.CharSequence"),
    COLOR(IRClass.Res.COLOR, ColorRes.class, "getColor", "int", "java.lang.Integer");

    private final Class<? extends Annotation> target;
    private final String resourceMethodName;
    private final List<String> allowedTypes;
    private final IRClass.Res rInnerClass;

    private AndroidRes(IRClass.Res rInnerClass, Class<? extends Annotation> target, String resourceMethodName, String ... allowedTypes) {
        this.target = target;
        this.resourceMethodName = resourceMethodName;
        this.allowedTypes = Arrays.asList(allowedTypes);
        this.rInnerClass = rInnerClass;
    }

    public IRClass.Res getRInnerClass() {
        return this.rInnerClass;
    }

    public Class<? extends Annotation> getTarget() {
        return this.target;
    }

    public String getResourceMethodName() {
        return this.resourceMethodName;
    }

    public List<String> getAllowedTypes() {
        return this.allowedTypes;
    }

    public int idFromElement(Element element) {
        Annotation annotation = element.getAnnotation(this.target);
        Method valueMethod = this.target.getMethods()[0];
        try {
            return (Integer)valueMethod.invoke((Object)annotation, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

