/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.model;

import com.googlecode.androidannotations.model.AnnotationElementsHolder;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class ModelExtractor {
    private final ProcessingEnvironment processingEnv;
    private final Set<Class<? extends Annotation>> lookupAnnotations;

    public ModelExtractor(ProcessingEnvironment processingEnv, Set<Class<? extends Annotation>> lookupAnnotations) {
        this.processingEnv = processingEnv;
        this.lookupAnnotations = lookupAnnotations;
    }

    public AnnotationElementsHolder extract(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        AnnotationElementsHolder extractedModel = new AnnotationElementsHolder();
        Set<DeclaredType> annotationTypesToCheck = this.buildAnnotationTypes();
        Set<? extends Element> rootElements = roundEnv.getRootElements();
        Set<TypeElement> rootTypeElements = this.findRootTypeElements(rootElements);
        this.extractAncestorsAnnotations(extractedModel, annotationTypesToCheck, rootTypeElements);
        this.extractRootElementsAnnotations(annotations, roundEnv, extractedModel);
        return extractedModel;
    }

    private Set<DeclaredType> buildAnnotationTypes() {
        HashSet<DeclaredType> annotationTypesToCheck = new HashSet<DeclaredType>();
        for (Class<? extends Annotation> annotation : this.lookupAnnotations) {
            TypeElement typeElement = this.processingEnv.getElementUtils().getTypeElement(annotation.getName());
            annotationTypesToCheck.add((DeclaredType)typeElement.asType());
        }
        return annotationTypesToCheck;
    }

    private Set<TypeElement> findRootTypeElements(Set<? extends Element> rootElements) {
        HashSet<TypeElement> rootTypeElements = new HashSet<TypeElement>();
        for (Element element : rootElements) {
            if (element instanceof TypeElement) {
                rootTypeElements.add((TypeElement)element);
                continue;
            }
            Element enclosingElement = element.getEnclosingElement();
            if (!(enclosingElement instanceof TypeElement)) continue;
            rootTypeElements.add((TypeElement)enclosingElement);
        }
        return rootTypeElements;
    }

    private void extractAncestorsAnnotations(AnnotationElementsHolder extractedModel, Set<DeclaredType> annotationTypesToCheck, Set<TypeElement> rootTypeElements) {
        for (TypeElement rootTypeElement : rootTypeElements) {
            HashSet<TypeElement> ancestors = new HashSet<TypeElement>();
            this.addAncestorsElements(ancestors, rootTypeElement);
            if (ancestors.isEmpty()) continue;
            for (TypeElement ancestor : ancestors) {
                this.extractAnnotations(extractedModel, annotationTypesToCheck, rootTypeElement, ancestor);
                for (Element element : ancestor.getEnclosedElements()) {
                    ElementKind enclosedKind = element.getKind();
                    if (enclosedKind != ElementKind.FIELD && enclosedKind != ElementKind.METHOD) continue;
                    this.extractAnnotations(extractedModel, annotationTypesToCheck, rootTypeElement, element);
                }
            }
        }
    }

    private void extractAnnotations(AnnotationElementsHolder extractedModel, Set<DeclaredType> annotationTypesToCheck, TypeElement rootTypeElement, Element ancestorEnclosedElement) {
        List<? extends AnnotationMirror> ancestorEnclosedElementAnnotations = ancestorEnclosedElement.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : ancestorEnclosedElementAnnotations) {
            DeclaredType annotationType = annotationMirror.getAnnotationType();
            if (!annotationTypesToCheck.contains(annotationType)) continue;
            TypeElement annotation = (TypeElement)annotationType.asElement();
            extractedModel.putAncestorAnnotatedElement(annotation.getQualifiedName().toString(), ancestorEnclosedElement, rootTypeElement);
        }
    }

    private void addAncestorsElements(Set<TypeElement> elements, TypeElement element) {
        DeclaredType ancestorDeclaredType;
        Element ancestorElement;
        TypeElement typeElement;
        TypeMirror ancestorTypeMirror;
        if (element instanceof TypeElement && !this.isRootObjectClass(ancestorTypeMirror = (typeElement = element).getSuperclass()) && ancestorTypeMirror instanceof DeclaredType && (ancestorElement = (ancestorDeclaredType = (DeclaredType)ancestorTypeMirror).asElement()) instanceof TypeElement) {
            elements.add((TypeElement)ancestorElement);
            this.addAncestorsElements(elements, (TypeElement)ancestorElement);
        }
    }

    private boolean isRootObjectClass(TypeMirror typeMirror) {
        return typeMirror.getKind() == TypeKind.NONE;
    }

    private void extractRootElementsAnnotations(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv, AnnotationElementsHolder extractedModel) {
        for (TypeElement typeElement : annotations) {
            extractedModel.putRootAnnotatedElements(typeElement.getQualifiedName().toString(), roundEnv.getElementsAnnotatedWith(typeElement));
        }
    }
}

