/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.processing;

import com.googlecode.androidannotations.model.AnnotationElements;
import com.googlecode.androidannotations.processing.DecoratingElementProcessor;
import com.googlecode.androidannotations.processing.EBeanHolder;
import com.googlecode.androidannotations.processing.EBeansHolder;
import com.googlecode.androidannotations.processing.GeneratingElementProcessor;
import com.sun.codemodel.JCodeModel;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;

public class ModelProcessor {
    private final List<DecoratingElementProcessor> enclosedProcessors = new ArrayList<DecoratingElementProcessor>();
    private final List<GeneratingElementProcessor> typeProcessors = new ArrayList<GeneratingElementProcessor>();

    public void register(DecoratingElementProcessor processor) {
        this.enclosedProcessors.add(processor);
    }

    public void register(GeneratingElementProcessor processor) {
        this.typeProcessors.add(processor);
    }

    public ProcessResult process(AnnotationElements validatedModel) throws Exception {
        Class<? extends Annotation> target;
        JCodeModel codeModel = new JCodeModel();
        EBeansHolder eBeansHolder = new EBeansHolder(codeModel);
        for (GeneratingElementProcessor generatingElementProcessor : this.typeProcessors) {
            target = generatingElementProcessor.getTarget();
            Set<? extends Element> annotatedElements = validatedModel.getRootAnnotatedElements(target.getName());
            for (Element element : annotatedElements) {
                if (this.isAbstractClass(element)) continue;
                generatingElementProcessor.process(element, codeModel, eBeansHolder);
            }
        }
        for (DecoratingElementProcessor decoratingElementProcessor : this.enclosedProcessors) {
            EBeanHolder holder;
            target = decoratingElementProcessor.getTarget();
            Set<? extends Element> rootAnnotatedElements = validatedModel.getRootAnnotatedElements(target.getName());
            for (Element element : rootAnnotatedElements) {
                Element enclosingElement = element instanceof TypeElement ? element : element.getEnclosingElement();
                if (this.isAbstractClass(enclosingElement)) continue;
                holder = eBeansHolder.getEBeanHolder(enclosingElement);
                decoratingElementProcessor.process(element, codeModel, holder);
            }
            Set<AnnotationElements.AnnotatedAndRootElements> ancestorAnnotatedElements = validatedModel.getAncestorAnnotatedElements(target.getName());
            for (AnnotationElements.AnnotatedAndRootElements elements : ancestorAnnotatedElements) {
                holder = eBeansHolder.getEBeanHolder(elements.rootTypeElement);
                if (holder == null) continue;
                decoratingElementProcessor.process(elements.annotatedElement, codeModel, holder);
            }
        }
        return new ProcessResult(codeModel, eBeansHolder.getOriginatingElementsByGeneratedClassQualifiedName());
    }

    private boolean isAbstractClass(Element annotatedElement) {
        if (annotatedElement instanceof TypeElement) {
            TypeElement typeElement = (TypeElement)annotatedElement;
            return typeElement.getKind() == ElementKind.CLASS && typeElement.getModifiers().contains((Object)Modifier.ABSTRACT);
        }
        return false;
    }

    public static class ProcessResult {
        public final JCodeModel codeModel;
        public final Map<String, Element> originatingElementsByGeneratedClassQualifiedName;

        public ProcessResult(JCodeModel codeModel, Map<String, Element> originatingElementsByGeneratedClassQualifiedName) {
            this.codeModel = codeModel;
            this.originatingElementsByGeneratedClassQualifiedName = originatingElementsByGeneratedClassQualifiedName;
        }
    }
}

