/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer;

import com.sun.jna.Pointer;
import org.gstreamer.lowlevel.GstMiniObjectAPI;
import org.gstreamer.lowlevel.GstNative;
import org.gstreamer.lowlevel.NativeObject;
import org.gstreamer.lowlevel.RefCountedObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MiniObject
extends RefCountedObject {
    private static final GstMiniObjectAPI gst = GstNative.load(GstMiniObjectAPI.class);

    public MiniObject(NativeObject.Initializer init) {
        super(init);
    }

    public boolean isWritable() {
        return gst.gst_mini_object_is_writable(this);
    }

    protected <T extends MiniObject> T makeWritable(Class<T> subclass) {
        MiniObject result = gst.gst_mini_object_make_writable(this);
        if (result == null) {
            throw new NullPointerException("Could not make " + subclass.getSimpleName() + " writable");
        }
        return (T)((MiniObject)subclass.cast(result));
    }

    @Override
    protected void ref() {
        gst.gst_mini_object_ref(this);
    }

    @Override
    protected void unref() {
        gst.gst_mini_object_unref(this);
    }

    @Override
    protected void disposeNativeHandle(Pointer ptr) {
        gst.gst_mini_object_unref(ptr);
    }

    public static <T extends MiniObject> T objectFor(Pointer ptr, Class<T> defaultClass, boolean needRef) {
        return (T)((MiniObject)NativeObject.objectFor(ptr, defaultClass, needRef));
    }
}

