/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer;

import com.sun.jna.Pointer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.gstreamer.GstObject;
import org.gstreamer.Plugin;
import org.gstreamer.PluginFeature;
import org.gstreamer.lowlevel.GType;
import org.gstreamer.lowlevel.GlibAPI;
import org.gstreamer.lowlevel.GstNative;
import org.gstreamer.lowlevel.GstPluginAPI;
import org.gstreamer.lowlevel.GstRegistryAPI;
import org.gstreamer.lowlevel.NativeObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Registry
extends GstObject {
    private static final API gst = GstNative.load(API.class);
    private static Logger logger = Logger.getLogger(Registry.class.getName());

    public static Registry getDefault() {
        return GstObject.objectFor(gst.gst_registry_get_default(), Registry.class, false, false);
    }

    public Registry(NativeObject.Initializer init) {
        super(init);
    }

    public Plugin findPlugin(String name) {
        return gst.gst_registry_find_plugin(this, name);
    }

    public boolean addPlugin(Plugin plugin) {
        return gst.gst_registry_add_plugin(this, plugin);
    }

    public void removePlugin(Plugin plugin) {
        gst.gst_registry_remove_plugin(this, plugin);
    }

    public PluginFeature findPluginFeature(String name, GType type) {
        return gst.gst_registry_find_feature(this, name, type);
    }

    public PluginFeature findPluginFeature(String name) {
        return gst.gst_registry_lookup_feature(this, name);
    }

    public List<Plugin> getPluginList() {
        GlibAPI.GList glist = gst.gst_registry_get_plugin_list(this);
        List<Plugin> list = this.objectList(glist, Plugin.class);
        gst.gst_plugin_list_free(glist);
        return list;
    }

    public List<Plugin> getPluginList(PluginFilter filter, boolean onlyReturnFirstMatch) {
        LinkedList<Plugin> list = new LinkedList<Plugin>();
        for (Plugin plugin : this.getPluginList()) {
            if (!filter.accept(plugin)) continue;
            list.add(plugin);
        }
        return list;
    }

    public List<PluginFeature> getPluginFeatureListByType(GType type) {
        GlibAPI.GList glist = gst.gst_registry_get_feature_list(this, type);
        List<PluginFeature> list = this.objectList(glist, PluginFeature.class);
        gst.gst_plugin_feature_list_free(glist);
        return list;
    }

    public List<PluginFeature> getPluginFeatureListByPlugin(String name) {
        GlibAPI.GList glist = gst.gst_registry_get_feature_list_by_plugin(this, name);
        List<PluginFeature> list = this.objectList(glist, PluginFeature.class);
        gst.gst_plugin_feature_list_free(glist);
        return list;
    }

    public boolean scanPath(String path) {
        return gst.gst_registry_scan_path(this, path);
    }

    private <T extends GstObject> List<T> objectList(GlibAPI.GList glist, Class<T> objectClass) {
        ArrayList<T> list = new ArrayList<T>();
        for (GlibAPI.GList next = glist; next != null; next = next.next()) {
            if (next.data == null) continue;
            list.add(GstObject.objectFor(next.data, objectClass, true, true));
        }
        return list;
    }

    public static interface PluginFeatureFilter {
        public boolean accept(PluginFeature var1);
    }

    public static interface PluginFilter {
        public boolean accept(Plugin var1);
    }

    private static interface API
    extends GstPluginAPI,
    GstRegistryAPI {
        public void gst_plugin_feature_list_free(GlibAPI.GList var1);

        public GlibAPI.GList gst_registry_get_plugin_list(Registry var1);

        public GlibAPI.GList gst_registry_plugin_filter(Registry var1, GstRegistryAPI.PluginFilter var2, boolean var3, Pointer var4);

        public GlibAPI.GList gst_registry_feature_filter(Registry var1, GstRegistryAPI.PluginFeatureFilter var2, boolean var3, Pointer var4);

        public GlibAPI.GList gst_registry_get_feature_list(Registry var1, GType var2);

        public GlibAPI.GList gst_registry_get_feature_list_by_plugin(Registry var1, String var2);

        public GlibAPI.GList gst_registry_get_path_list(Registry var1);

        public void gst_plugin_list_free(GlibAPI.GList var1);
    }
}

