/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer;

import org.gstreamer.Fraction;
import org.gstreamer.lowlevel.GValueAPI;
import org.gstreamer.lowlevel.GstValueAPI;

public class ValueList {
    private GValueAPI.GValue value;

    ValueList(GValueAPI.GValue value) {
        this.value = value;
    }

    public int getSize() {
        return GstValueAPI.GSTVALUE_API.gst_value_list_get_size(this.value);
    }

    public double getDouble(int index) {
        return GValueAPI.GVALUE_API.g_value_get_double(this.getValue(index));
    }

    public int getInteger(int index) {
        return GValueAPI.GVALUE_API.g_value_get_int(this.getValue(index));
    }

    public String getString(int index) {
        return GValueAPI.GVALUE_API.g_value_get_string(this.getValue(index));
    }

    public boolean getBoolean(int index) {
        return GValueAPI.GVALUE_API.g_value_get_boolean(this.getValue(index));
    }

    public Fraction getFraction(int index) {
        GValueAPI.GValue value = this.getValue(index);
        return new Fraction(GstValueAPI.GSTVALUE_API.gst_value_get_fraction_numerator(value), GstValueAPI.GSTVALUE_API.gst_value_get_fraction_denominator(value));
    }

    private GValueAPI.GValue getValue(int index) {
        GValueAPI.GValue val = GstValueAPI.GSTVALUE_API.gst_value_list_get_value(this.value, index);
        if (val == null) {
            throw new RuntimeException(String.format("List does not contain value %d", index));
        }
        return val;
    }
}

