/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.swt.overlay;

import com.sun.jna.NativeLong;
import com.sun.jna.Platform;
import java.lang.reflect.Field;
import org.eclipse.swt.widgets.Composite;
import org.gstreamer.Element;
import org.gstreamer.GstException;
import org.gstreamer.interfaces.XOverlay;
import org.gstreamer.lowlevel.GstXOverlayAPI;

public class SWTOverlay
extends XOverlay {
    public static SWTOverlay wrap(Element element) {
        return new SWTOverlay(element);
    }

    private SWTOverlay(Element element) {
        super(element);
    }

    public static long getLinuxHandle(Composite composite) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Class<?> compositeClass = composite.getClass();
        Field embedHandleField = compositeClass.getField("embeddedHandle");
        Class<?> t = embedHandleField.getType();
        if (t.equals(Long.TYPE)) {
            return embedHandleField.getLong(composite);
        }
        if (t.equals(Integer.TYPE)) {
            return embedHandleField.getInt(composite);
        }
        return 0L;
    }

    public static long handle(Composite composite) {
        if (composite == null || (composite.getStyle() | 0x1000000) == 0) {
            return 0L;
        }
        if (Platform.isWindows()) {
            return composite.handle;
        }
        if (Platform.isLinux()) {
            try {
                return SWTOverlay.getLinuxHandle(composite);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0L;
    }

    public void setWindowID(Composite composite) {
        if (composite == null || (composite.getStyle() | 0x1000000) == 0) {
            throw new GstException("Cannot set window ID, in XOverlay interface, composite is null or not SWT.EMBEDDED");
        }
        if (Platform.isWindows()) {
            GstXOverlayAPI.GSTXOVERLAY_API.gst_x_overlay_set_xwindow_id((XOverlay)this, new NativeLong((long)composite.handle));
        } else if (Platform.isLinux()) {
            try {
                GstXOverlayAPI.GSTXOVERLAY_API.gst_x_overlay_set_xwindow_id((XOverlay)this, new NativeLong(SWTOverlay.getLinuxHandle(composite)));
            }
            catch (Exception e) {
                throw new GstException("Cannot set window ID, in XOverlay interface, can't get embeddedHandle. " + e.getLocalizedMessage());
            }
        } else {
            throw new GstException("Cannot set window ID, in XOverlay interface: not supported sink element on platform");
        }
    }
}

