/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.swt.overlay;

import com.sun.jna.Platform;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.gstreamer.BusSyncReply;
import org.gstreamer.Element;
import org.gstreamer.ElementFactory;
import org.gstreamer.Message;
import org.gstreamer.Structure;
import org.gstreamer.event.BusSyncHandler;
import org.gstreamer.swt.overlay.SWTOverlay;

public class VideoComponent
extends Canvas
implements BusSyncHandler,
DisposeListener {
    private static int counter = 0;
    private final Element videosink = ElementFactory.make(Platform.isLinux() ? "xvimagesink" : "directdrawsink", "OverlayVideoComponent" + counter++);
    private final SWTOverlay overlay = SWTOverlay.wrap(this.videosink);
    private Listener exposer;

    public VideoComponent(Composite parent, int style, boolean enableMouseMove) {
        super(parent, style | 0x1000000);
        this.overlay.setWindowID((Composite)this);
        this.mouseMove(enableMouseMove);
    }

    public VideoComponent(Composite parent, int style) {
        this(parent, style, false);
    }

    public synchronized void mouseMove(boolean enable) {
        if (Platform.isLinux() && enable == (this.exposer == null)) {
            if (enable) {
                this.exposer = new Listener(){

                    public void handleEvent(Event event) {
                        VideoComponent.this.expose();
                    }
                };
                this.addListener(11, this.exposer);
                this.getShell().addListener(26, this.exposer);
                this.addDisposeListener(this);
            } else {
                this.removeListener(11, this.exposer);
                this.getShell().removeListener(26, this.exposer);
                this.removeDisposeListener(this);
                this.exposer = null;
            }
            this.videosink.set("handle-events", !enable);
        }
    }

    public void widgetDisposed(DisposeEvent arg0) {
        this.getShell().removeListener(26, this.exposer);
    }

    public void expose() {
        this.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (!VideoComponent.this.isDisposed()) {
                    VideoComponent.this.overlay.expose();
                }
            }
        });
    }

    public void setKeepAspect(boolean keepAspect) {
        this.videosink.set("force-aspect-ratio", keepAspect);
    }

    public Element getElement() {
        return this.videosink;
    }

    public BusSyncReply syncMessage(Message message) {
        Structure s = message.getStructure();
        if (s == null || !s.hasName("prepare-xwindow-id")) {
            return BusSyncReply.PASS;
        }
        this.overlay.setWindowID((Composite)this);
        return BusSyncReply.DROP;
    }
}

