/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah32;

import com.googlecode.javaewah32.BitmapStorage32;
import com.googlecode.javaewah32.EWAHCompressedBitmap32;
import com.googlecode.javaewah32.IteratingBufferedRunningLengthWord32;
import com.googlecode.javaewah32.IteratingRLW32;
import com.googlecode.javaewah32.IteratorAggregation32;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.PriorityQueue;

public class FastAggregation32 {
    public static EWAHCompressedBitmap32 bufferedand(int bufsize, EWAHCompressedBitmap32 ... bitmaps) {
        EWAHCompressedBitmap32 answer = new EWAHCompressedBitmap32();
        FastAggregation32.bufferedandWithContainer(answer, bufsize, bitmaps);
        return answer;
    }

    public static void bufferedandWithContainer(BitmapStorage32 container, int bufsize, EWAHCompressedBitmap32 ... bitmaps) {
        LinkedList<IteratingBufferedRunningLengthWord32> al = new LinkedList<IteratingBufferedRunningLengthWord32>();
        for (EWAHCompressedBitmap32 bitmap : bitmaps) {
            al.add(new IteratingBufferedRunningLengthWord32(bitmap));
        }
        int[] hardbitmap = new int[bufsize * bitmaps.length];
        for (IteratingBufferedRunningLengthWord32 i : al) {
            if (i.size() != 0) continue;
            al.clear();
            break;
        }
        block2: while (!al.isEmpty()) {
            Arrays.fill(hardbitmap, -1);
            int effective = Integer.MAX_VALUE;
            for (IteratingBufferedRunningLengthWord32 i : al) {
                int eff = IteratorAggregation32.inplaceand(hardbitmap, i);
                if (eff >= effective) continue;
                effective = eff;
            }
            for (int k = 0; k < effective; ++k) {
                container.add(hardbitmap[k]);
            }
            for (IteratingBufferedRunningLengthWord32 i : al) {
                if (i.size() != 0) continue;
                al.clear();
                continue block2;
            }
        }
    }

    public static EWAHCompressedBitmap32 bufferedor(int bufsize, EWAHCompressedBitmap32 ... bitmaps) {
        EWAHCompressedBitmap32 answer = new EWAHCompressedBitmap32();
        FastAggregation32.bufferedorWithContainer(answer, bufsize, bitmaps);
        return answer;
    }

    public static void bufferedorWithContainer(BitmapStorage32 container, int bufsize, EWAHCompressedBitmap32 ... bitmaps) {
        int range = 0;
        EWAHCompressedBitmap32[] sbitmaps = (EWAHCompressedBitmap32[])bitmaps.clone();
        Arrays.sort(sbitmaps, new Comparator<EWAHCompressedBitmap32>(){

            @Override
            public int compare(EWAHCompressedBitmap32 a, EWAHCompressedBitmap32 b) {
                return b.sizeinbits - a.sizeinbits;
            }
        });
        ArrayList<IteratingBufferedRunningLengthWord32> al = new ArrayList<IteratingBufferedRunningLengthWord32>();
        for (EWAHCompressedBitmap32 bitmap : sbitmaps) {
            if (bitmap.sizeinbits > range) {
                range = bitmap.sizeinbits;
            }
            al.add(new IteratingBufferedRunningLengthWord32(bitmap));
        }
        int[] hardbitmap = new int[bufsize];
        int maxr = al.size();
        while (maxr > 0) {
            int k;
            int effective = 0;
            for (k = 0; k < maxr; ++k) {
                if (((IteratingBufferedRunningLengthWord32)al.get(k)).size() > 0) {
                    int eff = IteratorAggregation32.inplaceor(hardbitmap, (IteratingRLW32)al.get(k));
                    if (eff <= effective) continue;
                    effective = eff;
                    continue;
                }
                maxr = k;
            }
            for (k = 0; k < effective; ++k) {
                container.add(hardbitmap[k]);
            }
            Arrays.fill(hardbitmap, 0);
        }
        container.setSizeInBits(range);
    }

    public static EWAHCompressedBitmap32 bufferedxor(int bufsize, EWAHCompressedBitmap32 ... bitmaps) {
        EWAHCompressedBitmap32 answer = new EWAHCompressedBitmap32();
        FastAggregation32.bufferedxorWithContainer(answer, bufsize, bitmaps);
        return answer;
    }

    public static void bufferedxorWithContainer(BitmapStorage32 container, int bufsize, EWAHCompressedBitmap32 ... bitmaps) {
        int range = 0;
        EWAHCompressedBitmap32[] sbitmaps = (EWAHCompressedBitmap32[])bitmaps.clone();
        Arrays.sort(sbitmaps, new Comparator<EWAHCompressedBitmap32>(){

            @Override
            public int compare(EWAHCompressedBitmap32 a, EWAHCompressedBitmap32 b) {
                return b.sizeinbits - a.sizeinbits;
            }
        });
        ArrayList<IteratingBufferedRunningLengthWord32> al = new ArrayList<IteratingBufferedRunningLengthWord32>();
        for (EWAHCompressedBitmap32 bitmap : sbitmaps) {
            if (bitmap.sizeinbits > range) {
                range = bitmap.sizeinbits;
            }
            al.add(new IteratingBufferedRunningLengthWord32(bitmap));
        }
        int[] hardbitmap = new int[bufsize];
        int maxr = al.size();
        while (maxr > 0) {
            int k;
            int effective = 0;
            for (k = 0; k < maxr; ++k) {
                if (((IteratingBufferedRunningLengthWord32)al.get(k)).size() > 0) {
                    int eff = IteratorAggregation32.inplacexor(hardbitmap, (IteratingRLW32)al.get(k));
                    if (eff <= effective) continue;
                    effective = eff;
                    continue;
                }
                maxr = k;
            }
            for (k = 0; k < effective; ++k) {
                container.add(hardbitmap[k]);
            }
            Arrays.fill(hardbitmap, 0);
        }
        container.setSizeInBits(range);
    }

    public static void orToContainer(BitmapStorage32 container, EWAHCompressedBitmap32 ... bitmaps) {
        if (bitmaps.length < 2) {
            throw new IllegalArgumentException("We need at least two bitmaps");
        }
        PriorityQueue<EWAHCompressedBitmap32> pq = new PriorityQueue<EWAHCompressedBitmap32>(bitmaps.length, new Comparator<EWAHCompressedBitmap32>(){

            @Override
            public int compare(EWAHCompressedBitmap32 a, EWAHCompressedBitmap32 b) {
                return a.sizeInBytes() - b.sizeInBytes();
            }
        });
        for (EWAHCompressedBitmap32 x : bitmaps) {
            pq.add(x);
        }
        while (pq.size() > 2) {
            EWAHCompressedBitmap32 x1 = pq.poll();
            EWAHCompressedBitmap32 x2 = pq.poll();
            pq.add(x1.or(x2));
        }
        pq.poll().orToContainer(pq.poll(), container);
    }

    public static void xorToContainer(BitmapStorage32 container, EWAHCompressedBitmap32 ... bitmaps) {
        if (bitmaps.length < 2) {
            throw new IllegalArgumentException("We need at least two bitmaps");
        }
        PriorityQueue<EWAHCompressedBitmap32> pq = new PriorityQueue<EWAHCompressedBitmap32>(bitmaps.length, new Comparator<EWAHCompressedBitmap32>(){

            @Override
            public int compare(EWAHCompressedBitmap32 a, EWAHCompressedBitmap32 b) {
                return a.sizeInBytes() - b.sizeInBytes();
            }
        });
        for (EWAHCompressedBitmap32 x : bitmaps) {
            pq.add(x);
        }
        while (pq.size() > 2) {
            EWAHCompressedBitmap32 x1 = pq.poll();
            EWAHCompressedBitmap32 x2 = pq.poll();
            pq.add(x1.xor(x2));
        }
        pq.poll().xorToContainer(pq.poll(), container);
    }

    /*
     * Unable to fully structure code
     */
    public static void legacy_orWithContainer(BitmapStorage32 container, EWAHCompressedBitmap32 ... bitmaps) {
        if (bitmaps.length == 2) {
            bitmaps[0].orToContainer(bitmaps[1], container);
            return;
        }
        sortedBitmaps = (EWAHCompressedBitmap32[])bitmaps.clone();
        Arrays.sort(sortedBitmaps, new Comparator<EWAHCompressedBitmap32>(){

            @Override
            public int compare(EWAHCompressedBitmap32 a, EWAHCompressedBitmap32 b) {
                return a.sizeinbits < b.sizeinbits ? 1 : (a.sizeinbits == b.sizeinbits ? 0 : -1);
            }
        });
        rlws = new IteratingBufferedRunningLengthWord32[bitmaps.length];
        maxAvailablePos = 0;
        for (EWAHCompressedBitmap32 bitmap : sortedBitmaps) {
            iterator = bitmap.getEWAHIterator();
            if (!iterator.hasNext()) continue;
            rlws[maxAvailablePos++] = new IteratingBufferedRunningLengthWord32(iterator);
        }
        if (maxAvailablePos == 0) {
            container.setSizeInBits(0);
            return;
        }
        maxSize = sortedBitmaps[0].sizeinbits;
        block1: while (true) {
            maxOneRl = 0;
            minZeroRl = 0x7FFFFFFF;
            minSize = 0x7FFFFFFF;
            numEmptyRl = 0;
            for (i = 0; i < maxAvailablePos; ++i) {
                rlw = rlws[i];
                size = rlw.size();
                if (size == 0) {
                    maxAvailablePos = i;
                    break;
                }
                minSize = Math.min(minSize, size);
                if (rlw.getRunningBit()) {
                    rl = rlw.getRunningLength();
                    maxOneRl = Math.max(maxOneRl, rl);
                    minZeroRl = 0;
                    if (rl != 0 || size <= 0) continue;
                    ++numEmptyRl;
                    continue;
                }
                rl = rlw.getRunningLength();
                minZeroRl = Math.min(minZeroRl, rl);
                if (rl != 0 || size <= 0) continue;
                ++numEmptyRl;
            }
            if (maxAvailablePos == 0) break;
            if (maxAvailablePos == 1) {
                rlws[0].discharge(container);
                break;
            }
            if (maxOneRl > 0) {
                container.addStreamOfEmptyWords(true, maxOneRl);
                i = 0;
                while (true) {
                    if (i >= maxAvailablePos) continue block1;
                    rlw = rlws[i];
                    rlw.discardFirstWords(maxOneRl);
                    ++i;
                }
            }
            if (minZeroRl > 0) {
                container.addStreamOfEmptyWords(false, minZeroRl);
                i = 0;
                while (true) {
                    if (i >= maxAvailablePos) continue block1;
                    rlw = rlws[i];
                    rlw.discardFirstWords(minZeroRl);
                    ++i;
                }
            }
            index = 0;
            if (numEmptyRl == 1) {
                emptyRl = null;
                minNonEmptyRl = 0x7FFFFFFF;
                for (i = 0; i < maxAvailablePos; ++i) {
                    rlw = rlws[i];
                    rl = rlw.getRunningLength();
                    if (rl == 0) {
                        if (!FastAggregation32.$assertionsDisabled && emptyRl != null) {
                            throw new AssertionError();
                        }
                        emptyRl = rlw;
                        continue;
                    }
                    minNonEmptyRl = Math.min(minNonEmptyRl, rl);
                }
                v0 = wordsToWrite = minNonEmptyRl > minSize ? minSize : minNonEmptyRl;
                if (emptyRl != null) {
                    emptyRl.writeLiteralWords(wordsToWrite, container);
                }
                index += wordsToWrite;
            }
            while (index < minSize) {
                word = 0;
                for (i = 0; i < maxAvailablePos; ++i) {
                    rlw = rlws[i];
                    if (rlw.getRunningLength() > index) continue;
                    word |= rlw.getLiteralWordAt(index - rlw.getRunningLength());
                }
                container.add(word);
                ++index;
            }
            i = 0;
            while (true) {
                if (i < maxAvailablePos) ** break;
                continue block1;
                rlw = rlws[i];
                rlw.discardFirstWords(minSize);
                ++i;
            }
            break;
        }
        container.setSizeInBits(maxSize);
    }
}

