/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah.symmetric;

import com.googlecode.javaewah.BitmapStorage;
import com.googlecode.javaewah.datastructure.StaticBitSet;
import com.googlecode.javaewah.symmetric.EWAHPointer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public abstract class UpdateableBitmapFunction {
    EWAHPointer[] rw = new EWAHPointer[0];
    int hammingWeight = 0;
    int litWeight = 0;
    boolean[] b = new boolean[0];
    final StaticBitSet litwlist = new StaticBitSet(0);

    UpdateableBitmapFunction() {
    }

    public final int getNumberOfLiterals() {
        return this.litwlist.cardinality();
    }

    public final Iterable<EWAHPointer> getLiterals() {
        return new Iterable<EWAHPointer>(){

            @Override
            public Iterator<EWAHPointer> iterator() {
                return new Iterator<EWAHPointer>(){
                    int k;
                    {
                        this.k = UpdateableBitmapFunction.this.litwlist.nextSetBit(0);
                    }

                    @Override
                    public boolean hasNext() {
                        return this.k >= 0;
                    }

                    @Override
                    public EWAHPointer next() {
                        EWAHPointer answer = UpdateableBitmapFunction.this.rw[this.k];
                        this.k = UpdateableBitmapFunction.this.litwlist.nextSetBit(this.k + 1);
                        return answer;
                    }

                    @Override
                    public void remove() {
                        throw new RuntimeException("N/A");
                    }
                };
            }
        };
    }

    public final void fillWithLiterals(List<EWAHPointer> container) {
        int k = this.litwlist.nextSetBit(0);
        while (k >= 0) {
            container.add(this.rw[k]);
            k = this.litwlist.nextSetBit(k + 1);
        }
    }

    public final void resize(int newsize) {
        this.rw = Arrays.copyOf(this.rw, newsize);
        this.litwlist.resize(newsize);
        this.b = Arrays.copyOf(this.b, newsize);
    }

    public void setLiteral(int pos) {
        if (!this.litwlist.get(pos)) {
            this.litwlist.set(pos);
            ++this.litWeight;
            if (this.b[pos]) {
                this.b[pos] = false;
                --this.hammingWeight;
            }
        }
    }

    public void clearLiteral(int pos) {
        if (this.litwlist.get(pos)) {
            this.litwlist.set(pos, false);
            --this.litWeight;
        }
    }

    public final void setZero(int pos) {
        if (this.b[pos]) {
            this.b[pos] = false;
            --this.hammingWeight;
        } else {
            this.clearLiteral(pos);
        }
    }

    public final void setOne(int pos) {
        if (!this.b[pos]) {
            this.clearLiteral(pos);
            this.b[pos] = true;
            ++this.hammingWeight;
        }
    }

    public abstract void dispatch(BitmapStorage var1, int var2, int var3);
}

