/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah32;

import com.googlecode.javaewah.CloneableIterator;
import com.googlecode.javaewah32.BufferedRunningLengthWord32;
import com.googlecode.javaewah32.EWAHIterator32;
import com.googlecode.javaewah32.IteratingRLW32;

public class BufferedIterator32
implements IteratingRLW32,
Cloneable {
    private BufferedRunningLengthWord32 brlw;
    private int[] buffer;
    private int literalWordStartPosition;
    private EWAHIterator32 iterator;
    private CloneableIterator<EWAHIterator32> masterIterator;

    public BufferedIterator32(CloneableIterator<EWAHIterator32> iterator) {
        this.masterIterator = iterator;
        if (this.masterIterator.hasNext()) {
            this.iterator = this.masterIterator.next();
            this.brlw = new BufferedRunningLengthWord32(this.iterator.next());
            this.literalWordStartPosition = this.iterator.literalWords() + this.brlw.literalWordOffset;
            this.buffer = this.iterator.buffer();
        }
    }

    @Override
    public void discardFirstWords(int x) {
        while (x > 0) {
            if (this.brlw.RunningLength > x) {
                this.brlw.RunningLength -= x;
                return;
            }
            this.brlw.RunningLength = 0;
            int toDiscard = (x -= this.brlw.RunningLength) > this.brlw.NumberOfLiteralWords ? this.brlw.NumberOfLiteralWords : x;
            this.literalWordStartPosition += toDiscard;
            this.brlw.NumberOfLiteralWords -= toDiscard;
            if ((x -= toDiscard) <= 0 && this.brlw.size() != 0 || this.next()) continue;
            break;
        }
    }

    @Override
    public void discardRunningWords() {
        this.brlw.RunningLength = 0;
        if (this.brlw.getNumberOfLiteralWords() == 0) {
            this.next();
        }
    }

    @Override
    public boolean next() {
        if (!this.iterator.hasNext() && !this.reload()) {
            this.brlw.NumberOfLiteralWords = 0;
            this.brlw.RunningLength = 0;
            return false;
        }
        this.brlw.reset(this.iterator.next());
        this.literalWordStartPosition = this.iterator.literalWords();
        return true;
    }

    private boolean reload() {
        if (!this.masterIterator.hasNext()) {
            return false;
        }
        this.iterator = this.masterIterator.next();
        this.buffer = this.iterator.buffer();
        return true;
    }

    @Override
    public int getLiteralWordAt(int index) {
        return this.buffer[this.literalWordStartPosition + index];
    }

    @Override
    public int getNumberOfLiteralWords() {
        return this.brlw.NumberOfLiteralWords;
    }

    @Override
    public boolean getRunningBit() {
        return this.brlw.RunningBit;
    }

    @Override
    public int getRunningLength() {
        return this.brlw.RunningLength;
    }

    @Override
    public int size() {
        return this.brlw.size();
    }

    @Override
    public BufferedIterator32 clone() throws CloneNotSupportedException {
        BufferedIterator32 answer = (BufferedIterator32)super.clone();
        answer.brlw = this.brlw.clone();
        answer.buffer = this.buffer;
        answer.iterator = this.iterator.clone();
        answer.literalWordStartPosition = this.literalWordStartPosition;
        answer.masterIterator = this.masterIterator.clone();
        return answer;
    }
}

