/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah;

import com.googlecode.javaewah.EWAHCompressedBitmap;
import com.googlecode.javaewah.RunningLengthWord;
import java.util.Stack;

final class ReverseEWAHIterator {
    private Stack<Integer> positions;
    private int pointer = 0;
    protected RunningLengthWord rlw;

    public ReverseEWAHIterator(EWAHCompressedBitmap a, int sizeInWords) {
        this.rlw = new RunningLengthWord(a, this.pointer);
        this.positions = new Stack();
        this.positions.ensureCapacity(sizeInWords);
        while (this.pointer < sizeInWords) {
            this.positions.push(this.pointer);
            this.rlw.position = this.pointer;
            this.pointer += this.rlw.getNumberOfLiteralWords() + 1;
        }
    }

    public long[] buffer() {
        return this.rlw.parent.buffer;
    }

    public int position() {
        return this.pointer;
    }

    public boolean hasPrevious() {
        return !this.positions.isEmpty();
    }

    public RunningLengthWord previous() {
        this.rlw.position = this.pointer = this.positions.pop().intValue();
        return this.rlw;
    }
}

