/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jeeunit.concurrent;

import com.googlecode.jeeunit.concurrent.Repeat;
import com.googlecode.jeeunit.concurrent.impl.ConcurrentRunnerScheduler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;

public class ConcurrentRunner
extends BlockJUnit4ClassRunner {
    private Repeat repeatDefault = (Repeat)this.getDescription().getAnnotation(Repeat.class);

    public ConcurrentRunner(Class<?> klass) throws Throwable {
        super(klass);
        this.setScheduler(new ConcurrentRunnerScheduler(klass));
    }

    protected List<FrameworkMethod> getChildren() {
        ArrayList<FrameworkMethod> children = new ArrayList<FrameworkMethod>();
        List testMethods = super.getChildren();
        for (FrameworkMethod testMethod : testMethods) {
            Repeat repeat = (Repeat)testMethod.getAnnotation(Repeat.class);
            if (repeat == null) {
                repeat = this.repeatDefault;
            }
            if (repeat == null) {
                children.add(testMethod);
                continue;
            }
            for (int i = 0; i < repeat.times(); ++i) {
                children.add(new RepeatedFrameworkMethod(testMethod.getMethod(), i));
            }
        }
        return children;
    }

    private class RepeatedFrameworkMethod
    extends FrameworkMethod {
        private int number;

        public RepeatedFrameworkMethod(Method method, int i) {
            super(method);
            this.number = i;
        }

        public String getName() {
            return String.format("%s[%d]", super.getName(), this.number);
        }
    }
}

