/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jeeunit.concurrent.impl;

import com.googlecode.jeeunit.concurrent.Concurrent;
import com.googlecode.jeeunit.concurrent.impl.NamedThreadFactory;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.junit.runners.model.RunnerScheduler;

public class ConcurrentRunnerScheduler
implements RunnerScheduler {
    private ExecutorService executorService;
    private CompletionService<Void> completionService;
    private Queue<Future<Void>> tasks = new LinkedList<Future<Void>>();

    public ConcurrentRunnerScheduler(Class<?> klass) {
        int numThreads = klass.isAnnotationPresent(Concurrent.class) ? klass.getAnnotation(Concurrent.class).threads() : 1;
        this.executorService = Executors.newFixedThreadPool(numThreads, new NamedThreadFactory(klass.getSimpleName()));
        this.completionService = new ExecutorCompletionService<Void>(this.executorService);
    }

    public void schedule(Runnable childStatement) {
        this.tasks.offer(this.completionService.submit(childStatement, null));
    }

    public void finished() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suiteFinished() {
        try {
            while (!this.tasks.isEmpty()) {
                this.tasks.remove(this.completionService.take());
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            while (!this.tasks.isEmpty()) {
                this.tasks.poll().cancel(true);
            }
            this.executorService.shutdownNow();
        }
    }
}

